/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ss.formula;

import org.apache.poi.ss.formula.CellCacheEntry;
import org.apache.poi.ss.formula.FormulaCellCacheEntry;

final class FormulaCellCacheEntrySet {
    private int _size;
    private FormulaCellCacheEntry[] _arr = FormulaCellCacheEntry.EMPTY_ARRAY;

    public FormulaCellCacheEntry[] toArray() {
        int nItems = this._size;
        if (nItems < 1) {
            return FormulaCellCacheEntry.EMPTY_ARRAY;
        }
        FormulaCellCacheEntry[] result = new FormulaCellCacheEntry[nItems];
        int j = 0;
        for (int i2 = 0; i2 < this._arr.length; ++i2) {
            FormulaCellCacheEntry cce = this._arr[i2];
            if (cce == null) continue;
            result[j++] = cce;
        }
        if (j != nItems) {
            throw new IllegalStateException("size mismatch");
        }
        return result;
    }

    public void add(CellCacheEntry cce) {
        if (this._size * 3 >= this._arr.length * 2) {
            FormulaCellCacheEntry[] prevArr = this._arr;
            CellCacheEntry[] newArr = new FormulaCellCacheEntry[4 + this._arr.length * 3 / 2];
            for (int i2 = 0; i2 < prevArr.length; ++i2) {
                FormulaCellCacheEntry prevCce = this._arr[i2];
                if (prevCce == null) continue;
                FormulaCellCacheEntrySet.addInternal(newArr, prevCce);
            }
            this._arr = newArr;
        }
        if (FormulaCellCacheEntrySet.addInternal(this._arr, cce)) {
            ++this._size;
        }
    }

    private static boolean addInternal(CellCacheEntry[] arr, CellCacheEntry cce) {
        CellCacheEntry item;
        int startIx;
        int i2;
        for (i2 = startIx = cce.hashCode() % arr.length; i2 < arr.length; ++i2) {
            item = arr[i2];
            if (item == cce) {
                return false;
            }
            if (item != null) continue;
            arr[i2] = cce;
            return true;
        }
        for (i2 = 0; i2 < startIx; ++i2) {
            item = arr[i2];
            if (item == cce) {
                return false;
            }
            if (item != null) continue;
            arr[i2] = cce;
            return true;
        }
        throw new IllegalStateException("No empty space found");
    }

    public boolean remove(CellCacheEntry cce) {
        FormulaCellCacheEntry item;
        int startIx;
        int i2;
        FormulaCellCacheEntry[] arr = this._arr;
        if (this._size * 3 < this._arr.length && this._arr.length > 8) {
            boolean found = false;
            FormulaCellCacheEntry[] prevArr = this._arr;
            CellCacheEntry[] newArr = new FormulaCellCacheEntry[this._arr.length / 2];
            for (int i3 = 0; i3 < prevArr.length; ++i3) {
                FormulaCellCacheEntry prevCce = this._arr[i3];
                if (prevCce == null) continue;
                if (prevCce == cce) {
                    found = true;
                    --this._size;
                    continue;
                }
                FormulaCellCacheEntrySet.addInternal(newArr, prevCce);
            }
            this._arr = newArr;
            return found;
        }
        for (i2 = startIx = cce.hashCode() % arr.length; i2 < arr.length; ++i2) {
            item = arr[i2];
            if (item != cce) continue;
            arr[i2] = null;
            --this._size;
            return true;
        }
        for (i2 = 0; i2 < startIx; ++i2) {
            item = arr[i2];
            if (item != cce) continue;
            arr[i2] = null;
            --this._size;
            return true;
        }
        return false;
    }
}

