/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.formula.functions;

import org.apache.poi.hssf.record.formula.eval.AreaEval;
import org.apache.poi.hssf.record.formula.eval.ErrorEval;
import org.apache.poi.hssf.record.formula.eval.Eval;
import org.apache.poi.hssf.record.formula.eval.EvaluationException;
import org.apache.poi.hssf.record.formula.eval.OperandResolver;
import org.apache.poi.hssf.record.formula.eval.ValueEval;
import org.apache.poi.hssf.record.formula.functions.Function;
import org.apache.poi.hssf.record.formula.functions.LookupUtils;

public final class Hlookup
implements Function {
    public Eval evaluate(Eval[] args, int srcCellRow, short srcCellCol) {
        Eval arg3 = null;
        switch (args.length) {
            case 4: {
                arg3 = args[3];
            }
            case 3: {
                break;
            }
            default: {
                return ErrorEval.VALUE_INVALID;
            }
        }
        try {
            ValueEval lookupValue = OperandResolver.getSingleValue(args[0], srcCellRow, srcCellCol);
            AreaEval tableArray = LookupUtils.resolveTableArrayArg(args[1]);
            boolean isRangeLookup = LookupUtils.resolveRangeLookupArg(arg3, srcCellRow, srcCellCol);
            int colIndex = LookupUtils.lookupIndexOfValue(lookupValue, LookupUtils.createRowVector(tableArray, 0), isRangeLookup);
            int rowIndex = LookupUtils.resolveRowOrColIndexArg(args[2], srcCellRow, srcCellCol);
            LookupUtils.ValueVector resultCol = this.createResultColumnVector(tableArray, rowIndex);
            return resultCol.getItem(colIndex);
        }
        catch (EvaluationException e2) {
            return e2.getErrorEval();
        }
    }

    private LookupUtils.ValueVector createResultColumnVector(AreaEval tableArray, int rowIndex) throws EvaluationException {
        if (rowIndex >= tableArray.getHeight()) {
            throw EvaluationException.invalidRef();
        }
        return LookupUtils.createRowVector(tableArray, rowIndex);
    }
}

