/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import java.util.Iterator;
import org.apache.poi.hssf.record.ExtSSTRecord;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.hssf.record.SSTDeserializer;
import org.apache.poi.hssf.record.SSTRecordSizeCalculator;
import org.apache.poi.hssf.record.SSTSerializer;
import org.apache.poi.hssf.record.UnicodeString;
import org.apache.poi.util.IntMapper;

public class SSTRecord
extends Record {
    private static UnicodeString EMPTY_STRING = new UnicodeString("");
    static final int MAX_RECORD_SIZE = 8228;
    static final int STD_RECORD_OVERHEAD = 4;
    static final int SST_RECORD_OVERHEAD = 12;
    static final int MAX_DATA_SPACE = 8216;
    static final int STRING_MINIMAL_OVERHEAD = 3;
    public static final short sid = 252;
    private int field_1_num_strings;
    private int field_2_num_unique_strings;
    private IntMapper field_3_strings;
    private SSTDeserializer deserializer;
    int[] bucketAbsoluteOffsets;
    int[] bucketRelativeOffsets;

    public SSTRecord() {
        this.field_1_num_strings = 0;
        this.field_2_num_unique_strings = 0;
        this.field_3_strings = new IntMapper();
        this.deserializer = new SSTDeserializer(this.field_3_strings);
    }

    public int addString(UnicodeString string) {
        int rval;
        ++this.field_1_num_strings;
        UnicodeString ucs = string == null ? EMPTY_STRING : string;
        int index = this.field_3_strings.getIndex(ucs);
        if (index != -1) {
            rval = index;
        } else {
            rval = this.field_3_strings.size();
            ++this.field_2_num_unique_strings;
            SSTDeserializer.addToStringTable(this.field_3_strings, ucs);
        }
        return rval;
    }

    public int getNumStrings() {
        return this.field_1_num_strings;
    }

    public int getNumUniqueStrings() {
        return this.field_2_num_unique_strings;
    }

    public void setNumStrings(int count) {
        this.field_1_num_strings = count;
    }

    public void setNumUniqueStrings(int count) {
        this.field_2_num_unique_strings = count;
    }

    public UnicodeString getString(int id) {
        return (UnicodeString)this.field_3_strings.get(id);
    }

    public boolean isString16bit(int id) {
        UnicodeString unicodeString = (UnicodeString)this.field_3_strings.get(id);
        return (unicodeString.getOptionFlags() & 1) == 1;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[SST]\n");
        buffer.append("    .numstrings     = ").append(Integer.toHexString(this.getNumStrings())).append("\n");
        buffer.append("    .uniquestrings  = ").append(Integer.toHexString(this.getNumUniqueStrings())).append("\n");
        for (int k = 0; k < this.field_3_strings.size(); ++k) {
            UnicodeString s2 = (UnicodeString)this.field_3_strings.get(k);
            buffer.append("    .string_" + k + "      = ").append(s2.getDebugInfo()).append("\n");
        }
        buffer.append("[/SST]\n");
        return buffer.toString();
    }

    public short getSid() {
        return 252;
    }

    public int hashCode() {
        return this.field_2_num_unique_strings;
    }

    public boolean equals(Object o) {
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        SSTRecord other = (SSTRecord)o;
        return this.field_1_num_strings == other.field_1_num_strings && this.field_2_num_unique_strings == other.field_2_num_unique_strings && this.field_3_strings.equals(other.field_3_strings);
    }

    public SSTRecord(RecordInputStream in) {
        this.field_1_num_strings = in.readInt();
        this.field_2_num_unique_strings = in.readInt();
        this.field_3_strings = new IntMapper();
        this.deserializer = new SSTDeserializer(this.field_3_strings);
        this.deserializer.manufactureStrings(this.field_2_num_unique_strings, in);
    }

    Iterator getStrings() {
        return this.field_3_strings.iterator();
    }

    int countStrings() {
        return this.field_3_strings.size();
    }

    public int serialize(int offset, byte[] data) {
        SSTSerializer serializer = new SSTSerializer(this.field_3_strings, this.getNumStrings(), this.getNumUniqueStrings());
        int bytes = serializer.serialize(offset, data);
        this.bucketAbsoluteOffsets = serializer.getBucketAbsoluteOffsets();
        this.bucketRelativeOffsets = serializer.getBucketRelativeOffsets();
        return bytes;
    }

    public int getRecordSize() {
        SSTRecordSizeCalculator calculator = new SSTRecordSizeCalculator(this.field_3_strings);
        int recordSize = calculator.getRecordSize();
        return recordSize;
    }

    SSTDeserializer getDeserializer() {
        return this.deserializer;
    }

    public ExtSSTRecord createExtSSTRecord(int sstOffset) {
        if (this.bucketAbsoluteOffsets == null || this.bucketAbsoluteOffsets == null) {
            throw new IllegalStateException("SST record has not yet been serialized.");
        }
        ExtSSTRecord extSST = new ExtSSTRecord();
        extSST.setNumStringsPerBucket((short)8);
        int[] absoluteOffsets = (int[])this.bucketAbsoluteOffsets.clone();
        int[] relativeOffsets = (int[])this.bucketRelativeOffsets.clone();
        int i2 = 0;
        while (i2 < absoluteOffsets.length) {
            int n = i2++;
            absoluteOffsets[n] = absoluteOffsets[n] + sstOffset;
        }
        extSST.setBucketOffsets(absoluteOffsets, relativeOffsets);
        return extSST;
    }

    public int calcExtSSTRecordSize() {
        return ExtSSTRecord.getRecordSizeForStrings(this.field_3_strings.size());
    }
}

