/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.util.LittleEndian;

public class DimensionsRecord
extends Record {
    public static final short sid = 512;
    private int field_1_first_row;
    private int field_2_last_row;
    private short field_3_first_col;
    private short field_4_last_col;
    private short field_5_zero;

    public DimensionsRecord() {
    }

    public DimensionsRecord(RecordInputStream in) {
        this.field_1_first_row = in.readInt();
        this.field_2_last_row = in.readInt();
        this.field_3_first_col = in.readShort();
        this.field_4_last_col = in.readShort();
        this.field_5_zero = in.readShort();
    }

    public void setFirstRow(int row) {
        this.field_1_first_row = row;
    }

    public void setLastRow(int row) {
        this.field_2_last_row = row;
    }

    public void setFirstCol(short col2) {
        this.field_3_first_col = col2;
    }

    public void setLastCol(short col2) {
        this.field_4_last_col = col2;
    }

    public int getFirstRow() {
        return this.field_1_first_row;
    }

    public int getLastRow() {
        return this.field_2_last_row;
    }

    public short getFirstCol() {
        return this.field_3_first_col;
    }

    public short getLastCol() {
        return this.field_4_last_col;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[DIMENSIONS]\n");
        buffer.append("    .firstrow       = ").append(Integer.toHexString(this.getFirstRow())).append("\n");
        buffer.append("    .lastrow        = ").append(Integer.toHexString(this.getLastRow())).append("\n");
        buffer.append("    .firstcol       = ").append(Integer.toHexString(this.getFirstCol())).append("\n");
        buffer.append("    .lastcol        = ").append(Integer.toHexString(this.getLastCol())).append("\n");
        buffer.append("    .zero           = ").append(Integer.toHexString(this.field_5_zero)).append("\n");
        buffer.append("[/DIMENSIONS]\n");
        return buffer.toString();
    }

    public int serialize(int offset, byte[] data) {
        LittleEndian.putShort(data, 0 + offset, (short)512);
        LittleEndian.putShort(data, 2 + offset, (short)14);
        LittleEndian.putInt(data, 4 + offset, this.getFirstRow());
        LittleEndian.putInt(data, 8 + offset, this.getLastRow());
        LittleEndian.putShort(data, 12 + offset, this.getFirstCol());
        LittleEndian.putShort(data, 14 + offset, this.getLastCol());
        LittleEndian.putShort(data, 16 + offset, (short)0);
        return this.getRecordSize();
    }

    public int getRecordSize() {
        return 18;
    }

    public short getSid() {
        return 512;
    }

    public Object clone() {
        DimensionsRecord rec = new DimensionsRecord();
        rec.field_1_first_row = this.field_1_first_row;
        rec.field_2_last_row = this.field_2_last_row;
        rec.field_3_first_col = this.field_3_first_col;
        rec.field_4_last_col = this.field_4_last_col;
        rec.field_5_zero = this.field_5_zero;
        return rec;
    }
}

