/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.poi.hssf.model.DrawingManager2;
import org.apache.poi.hssf.model.Model;
import org.apache.poi.hssf.model.RecordOrderer;
import org.apache.poi.hssf.model.RecordStream;
import org.apache.poi.hssf.model.RowBlocksReader;
import org.apache.poi.hssf.record.BOFRecord;
import org.apache.poi.hssf.record.CalcCountRecord;
import org.apache.poi.hssf.record.CalcModeRecord;
import org.apache.poi.hssf.record.CellValueRecordInterface;
import org.apache.poi.hssf.record.ColumnInfoRecord;
import org.apache.poi.hssf.record.DefaultColWidthRecord;
import org.apache.poi.hssf.record.DefaultRowHeightRecord;
import org.apache.poi.hssf.record.DeltaRecord;
import org.apache.poi.hssf.record.DimensionsRecord;
import org.apache.poi.hssf.record.DrawingRecord;
import org.apache.poi.hssf.record.EOFRecord;
import org.apache.poi.hssf.record.EscherAggregate;
import org.apache.poi.hssf.record.GridsetRecord;
import org.apache.poi.hssf.record.GutsRecord;
import org.apache.poi.hssf.record.IterationRecord;
import org.apache.poi.hssf.record.ObjRecord;
import org.apache.poi.hssf.record.ObjectProtectRecord;
import org.apache.poi.hssf.record.PaneRecord;
import org.apache.poi.hssf.record.PasswordRecord;
import org.apache.poi.hssf.record.PrintGridlinesRecord;
import org.apache.poi.hssf.record.PrintHeadersRecord;
import org.apache.poi.hssf.record.ProtectRecord;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordBase;
import org.apache.poi.hssf.record.RefModeRecord;
import org.apache.poi.hssf.record.RowRecord;
import org.apache.poi.hssf.record.SCLRecord;
import org.apache.poi.hssf.record.SaveRecalcRecord;
import org.apache.poi.hssf.record.ScenarioProtectRecord;
import org.apache.poi.hssf.record.SelectionRecord;
import org.apache.poi.hssf.record.UncalcedRecord;
import org.apache.poi.hssf.record.WSBoolRecord;
import org.apache.poi.hssf.record.WindowTwoRecord;
import org.apache.poi.hssf.record.aggregates.ColumnInfoRecordsAggregate;
import org.apache.poi.hssf.record.aggregates.ConditionalFormattingTable;
import org.apache.poi.hssf.record.aggregates.DataValidityTable;
import org.apache.poi.hssf.record.aggregates.MergedCellsTable;
import org.apache.poi.hssf.record.aggregates.PageSettingsBlock;
import org.apache.poi.hssf.record.aggregates.RecordAggregate;
import org.apache.poi.hssf.record.aggregates.RowRecordsAggregate;
import org.apache.poi.hssf.record.formula.FormulaShifter;
import org.apache.poi.hssf.util.CellRangeAddress;
import org.apache.poi.hssf.util.PaneInformation;
import org.apache.poi.util.POILogFactory;
import org.apache.poi.util.POILogger;

public final class Sheet
implements Model {
    public static final short LeftMargin = 0;
    public static final short RightMargin = 1;
    public static final short TopMargin = 2;
    public static final short BottomMargin = 3;
    private static POILogger log = POILogFactory.getLogger(class$org$apache$poi$hssf$model$Sheet == null ? (class$org$apache$poi$hssf$model$Sheet = Sheet.class$("org.apache.poi.hssf.model.Sheet")) : class$org$apache$poi$hssf$model$Sheet);
    protected ArrayList records = null;
    protected PrintGridlinesRecord printGridlines = null;
    protected GridsetRecord gridset = null;
    private GutsRecord _gutsRecord;
    protected DefaultColWidthRecord defaultcolwidth = null;
    protected DefaultRowHeightRecord defaultrowheight = null;
    private PageSettingsBlock _psBlock;
    protected ProtectRecord protect = null;
    protected ObjectProtectRecord objprotect = null;
    protected ScenarioProtectRecord scenprotect = null;
    protected PasswordRecord password = null;
    protected WindowTwoRecord windowTwo = null;
    protected SelectionRecord selection = null;
    private final MergedCellsTable _mergedCellsTable = new MergedCellsTable();
    ColumnInfoRecordsAggregate _columnInfos;
    private DimensionsRecord _dimensions;
    protected final RowRecordsAggregate _rowsAggregate;
    private DataValidityTable _dataValidityTable = null;
    private ConditionalFormattingTable condFormatting;
    private Iterator rowRecIterator = null;
    protected boolean _isUncalced = false;
    public static final byte PANE_LOWER_RIGHT = 0;
    public static final byte PANE_UPPER_RIGHT = 1;
    public static final byte PANE_LOWER_LEFT = 2;
    public static final byte PANE_UPPER_LEFT = 3;
    static /* synthetic */ Class class$org$apache$poi$hssf$model$Sheet;

    public static Sheet createSheet(RecordStream rs) {
        return new Sheet(rs);
    }

    private Sheet(RecordStream rs) {
        RowRecordsAggregate rra = null;
        this.records = new ArrayList(128);
        int bofEofNestingLevel = 0;
        int dimsloc = -1;
        while (rs.hasNext()) {
            int recSid = rs.peekNextSid();
            if (recSid == 432) {
                this.condFormatting = new ConditionalFormattingTable(rs);
                this.records.add(this.condFormatting);
                continue;
            }
            if (recSid == 125) {
                this._columnInfos = new ColumnInfoRecordsAggregate(rs);
                this.records.add(this._columnInfos);
                continue;
            }
            if (recSid == 434) {
                this._dataValidityTable = new DataValidityTable(rs);
                this.records.add(this._dataValidityTable);
                continue;
            }
            if (RecordOrderer.isRowBlockRecord(recSid) && bofEofNestingLevel == 1) {
                if (rra != null) {
                    throw new RuntimeException("row/cell records found in the wrong place");
                }
                RowBlocksReader rbr = new RowBlocksReader(rs);
                this._mergedCellsTable.addRecords(rbr.getLooseMergedCells());
                rra = new RowRecordsAggregate(rbr.getPlainRecordStream(), rbr.getSharedFormulaManager());
                this.records.add(rra);
                continue;
            }
            if (PageSettingsBlock.isComponentRecord(recSid)) {
                PageSettingsBlock psb = new PageSettingsBlock(rs);
                if (bofEofNestingLevel == 1 && this._psBlock == null) {
                    this._psBlock = psb;
                }
                this.records.add(psb);
                continue;
            }
            if (recSid == 229) {
                this._mergedCellsTable.read(rs);
                continue;
            }
            Record rec = rs.getNext();
            if (recSid == 523) continue;
            if (recSid == 94) {
                this._isUncalced = true;
                continue;
            }
            if (recSid == 2057) {
                ++bofEofNestingLevel;
                if (log.check(1)) {
                    log.log(1, "Hit BOF record. Nesting increased to " + bofEofNestingLevel);
                }
            } else if (recSid == 10) {
                --bofEofNestingLevel;
                if (log.check(1)) {
                    log.log(1, "Hit EOF record. Nesting decreased to " + bofEofNestingLevel);
                }
                if (bofEofNestingLevel == 0) {
                    this.records.add(rec);
                    break;
                }
            } else if (recSid == 512) {
                if (this._columnInfos == null) {
                    this._columnInfos = new ColumnInfoRecordsAggregate();
                    this.records.add(this._columnInfos);
                }
                this._dimensions = (DimensionsRecord)rec;
                dimsloc = this.records.size();
            } else if (recSid == 85) {
                this.defaultcolwidth = (DefaultColWidthRecord)rec;
            } else if (recSid == 549) {
                this.defaultrowheight = (DefaultRowHeightRecord)rec;
            } else if (recSid == 43) {
                this.printGridlines = (PrintGridlinesRecord)rec;
            } else if (recSid == 130) {
                this.gridset = (GridsetRecord)rec;
            } else if (recSid == 29) {
                this.selection = (SelectionRecord)rec;
            } else if (recSid == 574) {
                this.windowTwo = (WindowTwoRecord)rec;
            } else if (recSid == 18) {
                this.protect = (ProtectRecord)rec;
            } else if (recSid == 99) {
                this.objprotect = (ObjectProtectRecord)rec;
            } else if (recSid == 221) {
                this.scenprotect = (ScenarioProtectRecord)rec;
            } else if (recSid == 19) {
                this.password = (PasswordRecord)rec;
            }
            this.records.add(rec);
        }
        if (this._dimensions == null) {
            throw new RuntimeException("DimensionsRecord was not found");
        }
        if (this.windowTwo == null) {
            throw new RuntimeException("WINDOW2 was not found");
        }
        if (rra == null) {
            rra = new RowRecordsAggregate();
            this.records.add(dimsloc + 1, rra);
        }
        this._rowsAggregate = rra;
        RecordOrderer.addNewSheetRecord(this.records, this._mergedCellsTable);
        if (log.check(1)) {
            log.log(1, "sheet createSheet (existing file) exited");
        }
    }

    public Sheet cloneSheet() {
        ArrayList<Record> clonedRecords = new ArrayList<Record>(this.records.size());
        for (int i2 = 0; i2 < this.records.size(); ++i2) {
            RecordBase rb = (RecordBase)this.records.get(i2);
            if (rb instanceof RecordAggregate) {
                ((RecordAggregate)rb).visitContainedRecords(new RecordCloner(clonedRecords));
                continue;
            }
            Record rec = (Record)((Record)rb).clone();
            clonedRecords.add(rec);
        }
        return Sheet.createSheet(new RecordStream(clonedRecords, 0));
    }

    public static Sheet createSheet() {
        return new Sheet();
    }

    private Sheet() {
        this.records = new ArrayList(32);
        if (log.check(1)) {
            log.log(1, "Sheet createsheet from scratch called");
        }
        this.records.add(Sheet.createBOF());
        this.records.add(Sheet.createCalcMode());
        this.records.add(Sheet.createCalcCount());
        this.records.add(Sheet.createRefMode());
        this.records.add(Sheet.createIteration());
        this.records.add(Sheet.createDelta());
        this.records.add(Sheet.createSaveRecalc());
        this.records.add(Sheet.createPrintHeaders());
        this.printGridlines = Sheet.createPrintGridlines();
        this.records.add(this.printGridlines);
        this.gridset = Sheet.createGridset();
        this.records.add(this.gridset);
        this._gutsRecord = Sheet.createGuts();
        this.records.add(this._gutsRecord);
        this.defaultrowheight = Sheet.createDefaultRowHeight();
        this.records.add(this.defaultrowheight);
        this.records.add(Sheet.createWSBool());
        this._psBlock = new PageSettingsBlock();
        this.records.add(this._psBlock);
        this.defaultcolwidth = Sheet.createDefaultColWidth();
        this.records.add(this.defaultcolwidth);
        ColumnInfoRecordsAggregate columns = new ColumnInfoRecordsAggregate();
        this.records.add(columns);
        this._columnInfos = columns;
        this._dimensions = Sheet.createDimensions();
        this.records.add(this._dimensions);
        this._rowsAggregate = new RowRecordsAggregate();
        this.records.add(this._rowsAggregate);
        this.windowTwo = Sheet.createWindowTwo();
        this.records.add(this.windowTwo);
        this.selection = Sheet.createSelection();
        this.records.add(this.selection);
        this.records.add(this._mergedCellsTable);
        this.records.add(EOFRecord.instance);
        if (log.check(1)) {
            log.log(1, "Sheet createsheet from scratch exit");
        }
    }

    public RowRecordsAggregate getRowsAggregate() {
        return this._rowsAggregate;
    }

    private MergedCellsTable getMergedRecords() {
        return this._mergedCellsTable;
    }

    public void updateFormulasAfterCellShift(FormulaShifter shifter, int externSheetIndex) {
        this.getRowsAggregate().updateFormulasAfterRowShift(shifter, externSheetIndex);
        this.getConditionalFormattingTable().updateFormulasAfterCellShift(shifter, externSheetIndex);
    }

    public int addMergedRegion(int rowFrom, int colFrom, int rowTo, int colTo) {
        if (rowTo < rowFrom) {
            throw new IllegalArgumentException("The 'to' row (" + rowTo + ") must not be less than the 'from' row (" + rowFrom + ")");
        }
        if (colTo < colFrom) {
            throw new IllegalArgumentException("The 'to' col (" + colTo + ") must not be less than the 'from' col (" + colFrom + ")");
        }
        MergedCellsTable mrt = this.getMergedRecords();
        mrt.addArea(rowFrom, colFrom, rowTo, colTo);
        return mrt.getNumberOfMergedRegions() - 1;
    }

    public void removeMergedRegion(int index) {
        MergedCellsTable mrt = this.getMergedRecords();
        if (index >= mrt.getNumberOfMergedRegions()) {
            return;
        }
        mrt.remove(index);
    }

    public CellRangeAddress getMergedRegionAt(int index) {
        MergedCellsTable mrt = this.getMergedRecords();
        if (index >= mrt.getNumberOfMergedRegions()) {
            return null;
        }
        return mrt.get(index);
    }

    public int getNumMergedRegions() {
        return this.getMergedRecords().getNumberOfMergedRegions();
    }

    public ConditionalFormattingTable getConditionalFormattingTable() {
        if (this.condFormatting == null) {
            this.condFormatting = new ConditionalFormattingTable();
            RecordOrderer.addNewSheetRecord(this.records, this.condFormatting);
        }
        return this.condFormatting;
    }

    public void setDimensions(int firstrow, short firstcol, int lastrow, short lastcol) {
        if (log.check(1)) {
            log.log(1, "Sheet.setDimensions");
            log.log(1, "firstrow" + firstrow + "firstcol" + firstcol + "lastrow" + lastrow + "lastcol" + lastcol);
        }
        this._dimensions.setFirstCol(firstcol);
        this._dimensions.setFirstRow(firstrow);
        this._dimensions.setLastCol(lastcol);
        this._dimensions.setLastRow(lastrow);
        if (log.check(1)) {
            log.log(1, "Sheet.setDimensions exiting");
        }
    }

    public void visitContainedRecords(RecordAggregate.RecordVisitor rv, int offset) {
        RecordAggregate.PositionTrackingVisitor ptv = new RecordAggregate.PositionTrackingVisitor(rv, offset);
        boolean haveSerializedIndex = false;
        for (int k = 0; k < this.records.size(); ++k) {
            RecordBase record = (RecordBase)this.records.get(k);
            if (record instanceof RecordAggregate) {
                RecordAggregate agg = (RecordAggregate)record;
                agg.visitContainedRecords(ptv);
            } else {
                ptv.visitRecord((Record)record);
            }
            if (!(record instanceof BOFRecord) || haveSerializedIndex) continue;
            haveSerializedIndex = true;
            if (this._isUncalced) {
                ptv.visitRecord(new UncalcedRecord());
            }
            if (this._rowsAggregate == null) continue;
            int initRecsSize = this.getSizeOfInitialSheetRecords(k);
            int currentPos = ptv.getPosition();
            ptv.visitRecord(this._rowsAggregate.createIndexRecord(currentPos, initRecsSize));
        }
    }

    private int getSizeOfInitialSheetRecords(int bofRecordIndex) {
        RecordBase tmpRec;
        int result = 0;
        for (int j = bofRecordIndex + 1; j < this.records.size() && !((tmpRec = (RecordBase)this.records.get(j)) instanceof RowRecordsAggregate); ++j) {
            result += tmpRec.getRecordSize();
        }
        if (this._isUncalced) {
            result += UncalcedRecord.getStaticRecordSize();
        }
        return result;
    }

    public void addValueRecord(int row, CellValueRecordInterface col2) {
        if (log.check(1)) {
            log.log(1, "add value record  row" + row);
        }
        DimensionsRecord d2 = this._dimensions;
        if (col2.getColumn() > d2.getLastCol()) {
            d2.setLastCol((short)(col2.getColumn() + 1));
        }
        if (col2.getColumn() < d2.getFirstCol()) {
            d2.setFirstCol(col2.getColumn());
        }
        this._rowsAggregate.insertCell(col2);
    }

    public void removeValueRecord(int row, CellValueRecordInterface col2) {
        log.logFormatted(1, "remove value record row %", new int[]{row});
        this._rowsAggregate.removeCell(col2);
    }

    public void replaceValueRecord(CellValueRecordInterface newval) {
        if (log.check(1)) {
            log.log(1, "replaceValueRecord ");
        }
        this._rowsAggregate.removeCell(newval);
        this._rowsAggregate.insertCell(newval);
    }

    public void addRow(RowRecord row) {
        RowRecord existingRow;
        if (log.check(1)) {
            log.log(1, "addRow ");
        }
        DimensionsRecord d2 = this._dimensions;
        if (row.getRowNumber() >= d2.getLastRow()) {
            d2.setLastRow(row.getRowNumber() + 1);
        }
        if (row.getRowNumber() < d2.getFirstRow()) {
            d2.setFirstRow(row.getRowNumber());
        }
        if ((existingRow = this._rowsAggregate.getRow(row.getRowNumber())) != null) {
            this._rowsAggregate.removeRow(existingRow);
        }
        this._rowsAggregate.insertRow(row);
        if (log.check(1)) {
            log.log(1, "exit addRow");
        }
    }

    public void removeRow(RowRecord row) {
        this._rowsAggregate.removeRow(row);
    }

    public CellValueRecordInterface[] getValueRecords() {
        return this._rowsAggregate.getValueRecords();
    }

    public RowRecord getNextRow() {
        if (this.rowRecIterator == null) {
            this.rowRecIterator = this._rowsAggregate.getIterator();
        }
        if (!this.rowRecIterator.hasNext()) {
            return null;
        }
        return (RowRecord)this.rowRecIterator.next();
    }

    public RowRecord getRow(int rownum) {
        return this._rowsAggregate.getRow(rownum);
    }

    static BOFRecord createBOF() {
        BOFRecord retval = new BOFRecord();
        retval.setVersion((short)1536);
        retval.setType((short)16);
        retval.setBuild((short)3515);
        retval.setBuildYear((short)1996);
        retval.setHistoryBitMask(193);
        retval.setRequiredVersion(6);
        return retval;
    }

    private static CalcModeRecord createCalcMode() {
        CalcModeRecord retval = new CalcModeRecord();
        retval.setCalcMode((short)1);
        return retval;
    }

    private static CalcCountRecord createCalcCount() {
        CalcCountRecord retval = new CalcCountRecord();
        retval.setIterations((short)100);
        return retval;
    }

    private static RefModeRecord createRefMode() {
        RefModeRecord retval = new RefModeRecord();
        retval.setMode((short)1);
        return retval;
    }

    private static IterationRecord createIteration() {
        IterationRecord retval = new IterationRecord();
        retval.setIteration(false);
        return retval;
    }

    private static DeltaRecord createDelta() {
        DeltaRecord retval = new DeltaRecord();
        retval.setMaxChange(0.001);
        return retval;
    }

    private static SaveRecalcRecord createSaveRecalc() {
        SaveRecalcRecord retval = new SaveRecalcRecord();
        retval.setRecalc(true);
        return retval;
    }

    private static PrintHeadersRecord createPrintHeaders() {
        PrintHeadersRecord retval = new PrintHeadersRecord();
        retval.setPrintHeaders(false);
        return retval;
    }

    private static PrintGridlinesRecord createPrintGridlines() {
        PrintGridlinesRecord retval = new PrintGridlinesRecord();
        retval.setPrintGridlines(false);
        return retval;
    }

    private static GridsetRecord createGridset() {
        GridsetRecord retval = new GridsetRecord();
        retval.setGridset(true);
        return retval;
    }

    private static GutsRecord createGuts() {
        GutsRecord retval = new GutsRecord();
        retval.setLeftRowGutter((short)0);
        retval.setTopColGutter((short)0);
        retval.setRowLevelMax((short)0);
        retval.setColLevelMax((short)0);
        return retval;
    }

    private GutsRecord getGutsRecord() {
        if (this._gutsRecord == null) {
            GutsRecord result = Sheet.createGuts();
            RecordOrderer.addNewSheetRecord(this.records, result);
            this._gutsRecord = result;
        }
        return this._gutsRecord;
    }

    private static DefaultRowHeightRecord createDefaultRowHeight() {
        DefaultRowHeightRecord retval = new DefaultRowHeightRecord();
        retval.setOptionFlags((short)0);
        retval.setRowHeight((short)255);
        return retval;
    }

    private static WSBoolRecord createWSBool() {
        WSBoolRecord retval = new WSBoolRecord();
        retval.setWSBool1((byte)4);
        retval.setWSBool2((byte)-63);
        return retval;
    }

    private static DefaultColWidthRecord createDefaultColWidth() {
        DefaultColWidthRecord retval = new DefaultColWidthRecord();
        retval.setColWidth(8);
        return retval;
    }

    public int getDefaultColumnWidth() {
        return this.defaultcolwidth.getColWidth();
    }

    public boolean isGridsPrinted() {
        if (this.gridset == null) {
            this.gridset = Sheet.createGridset();
            int loc = this.findFirstRecordLocBySid((short)10);
            this.records.add(loc, this.gridset);
        }
        return !this.gridset.getGridset();
    }

    public void setGridsPrinted(boolean value) {
        this.gridset.setGridset(!value);
    }

    public void setDefaultColumnWidth(int dcw) {
        this.defaultcolwidth.setColWidth(dcw);
    }

    public void setDefaultRowHeight(short dch) {
        this.defaultrowheight.setRowHeight(dch);
    }

    public short getDefaultRowHeight() {
        return this.defaultrowheight.getRowHeight();
    }

    public int getColumnWidth(int columnIndex) {
        ColumnInfoRecord ci = this._columnInfos.findColumnInfo(columnIndex);
        if (ci != null) {
            return ci.getColumnWidth();
        }
        return 256 * this.defaultcolwidth.getColWidth();
    }

    public short getXFIndexForColAt(short columnIndex) {
        ColumnInfoRecord ci = this._columnInfos.findColumnInfo(columnIndex);
        if (ci != null) {
            return (short)ci.getXFIndex();
        }
        return 15;
    }

    public void setColumnWidth(int column, int width) {
        this.setColumn(column, null, new Integer(width), null, null, null);
    }

    public boolean isColumnHidden(int columnIndex) {
        ColumnInfoRecord cir = this._columnInfos.findColumnInfo(columnIndex);
        if (cir == null) {
            return false;
        }
        return cir.getHidden();
    }

    public void setColumnHidden(int column, boolean hidden) {
        this.setColumn(column, null, null, null, hidden, null);
    }

    public void setDefaultColumnStyle(int column, int styleIndex) {
        this.setColumn(column, new Short((short)styleIndex), null, null, null, null);
    }

    private void setColumn(int column, Short xfStyle, Integer width, Integer level, Boolean hidden, Boolean collapsed) {
        this._columnInfos.setColumn(column, xfStyle, width, level, hidden, collapsed);
    }

    public void groupColumnRange(int fromColumn, int toColumn, boolean indent) {
        this._columnInfos.groupColumnRange(fromColumn, toColumn, indent);
        int maxLevel = this._columnInfos.getMaxOutlineLevel();
        GutsRecord guts = this.getGutsRecord();
        guts.setColLevelMax((short)(maxLevel + 1));
        if (maxLevel == 0) {
            guts.setTopColGutter((short)0);
        } else {
            guts.setTopColGutter((short)(29 + 12 * (maxLevel - 1)));
        }
    }

    private static DimensionsRecord createDimensions() {
        DimensionsRecord retval = new DimensionsRecord();
        retval.setFirstCol((short)0);
        retval.setLastRow(1);
        retval.setFirstRow(0);
        retval.setLastCol((short)1);
        return retval;
    }

    private static WindowTwoRecord createWindowTwo() {
        WindowTwoRecord retval = new WindowTwoRecord();
        retval.setOptions((short)1718);
        retval.setTopRow((short)0);
        retval.setLeftCol((short)0);
        retval.setHeaderColor(64);
        retval.setPageBreakZoom((short)0);
        retval.setNormalZoom((short)0);
        return retval;
    }

    private static SelectionRecord createSelection() {
        return new SelectionRecord(0, 0);
    }

    public short getTopRow() {
        return this.windowTwo == null ? (short)0 : this.windowTwo.getTopRow();
    }

    public void setTopRow(short topRow) {
        if (this.windowTwo != null) {
            this.windowTwo.setTopRow(topRow);
        }
    }

    public void setLeftCol(short leftCol) {
        if (this.windowTwo != null) {
            this.windowTwo.setLeftCol(leftCol);
        }
    }

    public short getLeftCol() {
        return this.windowTwo == null ? (short)0 : this.windowTwo.getLeftCol();
    }

    public int getActiveCellRow() {
        if (this.selection == null) {
            return 0;
        }
        return this.selection.getActiveCellRow();
    }

    public void setActiveCellRow(int row) {
        if (this.selection != null) {
            this.selection.setActiveCellRow(row);
        }
    }

    public short getActiveCellCol() {
        if (this.selection == null) {
            return 0;
        }
        return (short)this.selection.getActiveCellCol();
    }

    public void setActiveCellCol(short col2) {
        if (this.selection != null) {
            this.selection.setActiveCellCol(col2);
        }
    }

    public List getRecords() {
        return this.records;
    }

    public GridsetRecord getGridsetRecord() {
        return this.gridset;
    }

    public Record findFirstRecordBySid(short sid) {
        int ix = this.findFirstRecordLocBySid(sid);
        if (ix < 0) {
            return null;
        }
        return (Record)this.records.get(ix);
    }

    public void setSCLRecord(SCLRecord sclRecord) {
        int oldRecordLoc = this.findFirstRecordLocBySid((short)160);
        if (oldRecordLoc == -1) {
            int windowRecordLoc = this.findFirstRecordLocBySid((short)574);
            this.records.add(windowRecordLoc + 1, sclRecord);
        } else {
            this.records.set(oldRecordLoc, sclRecord);
        }
    }

    public int findFirstRecordLocBySid(short sid) {
        int max = this.records.size();
        for (int i2 = 0; i2 < max; ++i2) {
            Record record;
            Object rb = this.records.get(i2);
            if (!(rb instanceof Record) || (record = (Record)rb).getSid() != sid) continue;
            return i2;
        }
        return -1;
    }

    public WindowTwoRecord getWindowTwo() {
        return this.windowTwo;
    }

    public PrintGridlinesRecord getPrintGridlines() {
        return this.printGridlines;
    }

    public void setPrintGridlines(PrintGridlinesRecord newPrintGridlines) {
        this.printGridlines = newPrintGridlines;
    }

    public void setSelected(boolean sel) {
        this.windowTwo.setSelected(sel);
    }

    public void createFreezePane(int colSplit, int rowSplit, int topRow, int leftmostColumn) {
        int paneLoc = this.findFirstRecordLocBySid((short)65);
        if (paneLoc != -1) {
            this.records.remove(paneLoc);
        }
        int loc = this.findFirstRecordLocBySid((short)574);
        PaneRecord pane = new PaneRecord();
        pane.setX((short)colSplit);
        pane.setY((short)rowSplit);
        pane.setTopRow((short)topRow);
        pane.setLeftColumn((short)leftmostColumn);
        if (rowSplit == 0) {
            pane.setTopRow((short)0);
            pane.setActivePane((short)1);
        } else if (colSplit == 0) {
            pane.setLeftColumn((short)64);
            pane.setActivePane((short)2);
        } else {
            pane.setActivePane((short)0);
        }
        this.records.add(loc + 1, pane);
        this.windowTwo.setFreezePanes(true);
        this.windowTwo.setFreezePanesNoSplit(true);
        SelectionRecord sel = (SelectionRecord)this.findFirstRecordBySid((short)29);
        sel.setPane((byte)pane.getActivePane());
    }

    public void createSplitPane(int xSplitPos, int ySplitPos, int topRow, int leftmostColumn, int activePane) {
        int paneLoc = this.findFirstRecordLocBySid((short)65);
        if (paneLoc != -1) {
            this.records.remove(paneLoc);
        }
        int loc = this.findFirstRecordLocBySid((short)574);
        PaneRecord r = new PaneRecord();
        r.setX((short)xSplitPos);
        r.setY((short)ySplitPos);
        r.setTopRow((short)topRow);
        r.setLeftColumn((short)leftmostColumn);
        r.setActivePane((short)activePane);
        this.records.add(loc + 1, r);
        this.windowTwo.setFreezePanes(false);
        this.windowTwo.setFreezePanesNoSplit(false);
        SelectionRecord sel = (SelectionRecord)this.findFirstRecordBySid((short)29);
        sel.setPane((byte)0);
    }

    public PaneInformation getPaneInformation() {
        PaneRecord rec = (PaneRecord)this.findFirstRecordBySid((short)65);
        if (rec == null) {
            return null;
        }
        return new PaneInformation(rec.getX(), rec.getY(), rec.getTopRow(), rec.getLeftColumn(), (byte)rec.getActivePane(), this.windowTwo.getFreezePanes());
    }

    public SelectionRecord getSelection() {
        return this.selection;
    }

    public void setSelection(SelectionRecord selection) {
        this.selection = selection;
    }

    private static ProtectRecord createProtect() {
        if (log.check(1)) {
            log.log(1, "create protect record with protection disabled");
        }
        ProtectRecord retval = new ProtectRecord();
        retval.setProtect(false);
        return retval;
    }

    private static ObjectProtectRecord createObjectProtect() {
        if (log.check(1)) {
            log.log(1, "create protect record with protection disabled");
        }
        ObjectProtectRecord retval = new ObjectProtectRecord();
        retval.setProtect(false);
        return retval;
    }

    private static ScenarioProtectRecord createScenarioProtect() {
        if (log.check(1)) {
            log.log(1, "create protect record with protection disabled");
        }
        ScenarioProtectRecord retval = new ScenarioProtectRecord();
        retval.setProtect(false);
        return retval;
    }

    public ProtectRecord getProtect() {
        if (this.protect == null) {
            this.protect = Sheet.createProtect();
            int loc = this.findFirstRecordLocBySid((short)85);
            this.records.add(loc, this.protect);
        }
        return this.protect;
    }

    public PasswordRecord getPassword() {
        if (this.password == null) {
            this.password = Sheet.createPassword();
            int loc = this.findFirstRecordLocBySid((short)10);
            this.records.add(loc, this.password);
        }
        return this.password;
    }

    private static PasswordRecord createPassword() {
        if (log.check(1)) {
            log.log(1, "create password record with 00 password");
        }
        PasswordRecord retval = new PasswordRecord();
        retval.setPassword((short)0);
        return retval;
    }

    public void setDisplayGridlines(boolean show) {
        this.windowTwo.setDisplayGridlines(show);
    }

    public boolean isDisplayGridlines() {
        return this.windowTwo.getDisplayGridlines();
    }

    public void setDisplayFormulas(boolean show) {
        this.windowTwo.setDisplayFormulas(show);
    }

    public boolean isDisplayFormulas() {
        return this.windowTwo.getDisplayFormulas();
    }

    public void setDisplayRowColHeadings(boolean show) {
        this.windowTwo.setDisplayRowColHeadings(show);
    }

    public boolean isDisplayRowColHeadings() {
        return this.windowTwo.getDisplayRowColHeadings();
    }

    public boolean getUncalced() {
        return this._isUncalced;
    }

    public void setUncalced(boolean uncalced) {
        this._isUncalced = uncalced;
    }

    public int aggregateDrawingRecords(DrawingManager2 drawingManager, boolean createIfMissing) {
        boolean noDrawingRecordsFound;
        int loc = this.findFirstRecordLocBySid((short)236);
        boolean bl = noDrawingRecordsFound = loc == -1;
        if (noDrawingRecordsFound) {
            if (!createIfMissing) {
                return -1;
            }
            EscherAggregate aggregate = new EscherAggregate(drawingManager);
            loc = this.findFirstRecordLocBySid((short)9876);
            if (loc == -1) {
                loc = this.findFirstRecordLocBySid((short)574);
            } else {
                this.getRecords().remove(loc);
            }
            this.getRecords().add(loc, aggregate);
            return loc;
        }
        List records = this.getRecords();
        EscherAggregate r = EscherAggregate.createAggregate(records, loc, drawingManager);
        int startloc = loc;
        while (loc + 1 < records.size() && records.get(loc) instanceof DrawingRecord && records.get(loc + 1) instanceof ObjRecord) {
            loc += 2;
        }
        int endloc = loc - 1;
        for (int i2 = 0; i2 < endloc - startloc + 1; ++i2) {
            records.remove(startloc);
        }
        records.add(startloc, r);
        return startloc;
    }

    public void preSerialize() {
        Iterator iterator = this.getRecords().iterator();
        while (iterator.hasNext()) {
            RecordBase r = (RecordBase)iterator.next();
            if (!(r instanceof EscherAggregate)) continue;
            r.getRecordSize();
        }
    }

    public PageSettingsBlock getPageSettings() {
        if (this._psBlock == null) {
            this._psBlock = new PageSettingsBlock();
            RecordOrderer.addNewSheetRecord(this.records, this._psBlock);
        }
        return this._psBlock;
    }

    public void setColumnGroupCollapsed(int columnNumber, boolean collapsed) {
        if (collapsed) {
            this._columnInfos.collapseColumn(columnNumber);
        } else {
            this._columnInfos.expandColumn(columnNumber);
        }
    }

    public void protectSheet(String password, boolean objects, boolean scenarios) {
        int protIdx = -1;
        ProtectRecord prec = this.getProtect();
        PasswordRecord pass = this.getPassword();
        prec.setProtect(true);
        pass.setPassword(PasswordRecord.hashPassword(password));
        if (this.objprotect == null && objects || this.scenprotect != null && scenarios) {
            protIdx = this.records.indexOf(this.protect);
        }
        if (this.objprotect == null && objects) {
            ObjectProtectRecord rec = Sheet.createObjectProtect();
            rec.setProtect(true);
            this.records.add(protIdx + 1, rec);
            this.objprotect = rec;
        }
        if (this.scenprotect == null && scenarios) {
            ScenarioProtectRecord srec = Sheet.createScenarioProtect();
            srec.setProtect(true);
            this.records.add(protIdx + 2, srec);
            this.scenprotect = srec;
        }
    }

    public void unprotectSheet(boolean sheet, boolean objects, boolean scenarios) {
        if (!sheet) {
            ProtectRecord prec = this.getProtect();
            prec.setProtect(sheet);
            PasswordRecord pass = this.getPassword();
            pass.setPassword((short)0);
        }
        if (this.objprotect != null && !objects) {
            this.objprotect.setProtect(false);
        }
        if (this.scenprotect != null && !scenarios) {
            this.scenprotect.setProtect(false);
        }
    }

    public boolean[] isProtected() {
        return new boolean[]{this.protect != null && this.protect.getProtect(), this.objprotect != null && this.objprotect.getProtect(), this.scenprotect != null && this.scenprotect.getProtect()};
    }

    public void groupRowRange(int fromRow, int toRow, boolean indent) {
        for (int rowNum = fromRow; rowNum <= toRow; ++rowNum) {
            RowRecord row = this.getRow(rowNum);
            if (row == null) {
                row = RowRecordsAggregate.createRow(rowNum);
                this.addRow(row);
            }
            int level = row.getOutlineLevel();
            level = indent ? ++level : --level;
            level = Math.max(0, level);
            level = Math.min(7, level);
            row.setOutlineLevel((short)level);
        }
        this.recalcRowGutter();
    }

    private void recalcRowGutter() {
        int maxLevel = 0;
        Iterator iterator = this._rowsAggregate.getIterator();
        while (iterator.hasNext()) {
            RowRecord rowRecord = (RowRecord)iterator.next();
            maxLevel = Math.max(rowRecord.getOutlineLevel(), maxLevel);
        }
        GutsRecord guts = this.getGutsRecord();
        guts.setRowLevelMax((short)(maxLevel + 1));
        guts.setLeftRowGutter((short)(29 + 12 * maxLevel));
    }

    public DataValidityTable getOrCreateDataValidityTable() {
        if (this._dataValidityTable == null) {
            DataValidityTable result = new DataValidityTable();
            RecordOrderer.addNewSheetRecord(this.records, result);
            this._dataValidityTable = result;
        }
        return this._dataValidityTable;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static final class RecordCloner
    implements RecordAggregate.RecordVisitor {
        private final List _destList;

        public RecordCloner(List destList) {
            this._destList = destList;
        }

        public void visitRecord(Record r) {
            this._destList.add(r.clone());
        }
    }
}

