/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.javaflow.stores;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.apache.bcel.util.ClassLoaderRepository;
import org.apache.bcel.util.Repository;
import org.apache.commons.javaflow.bytecode.transformation.ResourceTransformer;
import org.apache.commons.javaflow.bytecode.transformation.bcel.BcelClassTransformer;
import org.apache.commons.javaflow.stores.TransformingResourceStore;
import org.apache.commons.jci.stores.MemoryResourceStore;
import org.apache.commons.jci.stores.ResourceStore;
import org.apache.commons.jci.stores.TransactionalResourceStore;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class JavaflowResourceStore
extends TransactionalResourceStore {
    private static final Log log = LogFactory.getLog(class$org$apache$commons$javaflow$stores$JavaflowResourceStore == null ? (class$org$apache$commons$javaflow$stores$JavaflowResourceStore = JavaflowResourceStore.class$("org.apache.commons.javaflow.stores.JavaflowResourceStore")) : class$org$apache$commons$javaflow$stores$JavaflowResourceStore);
    private final TransformingResourceStore tstore;
    private final Collection changes = new ArrayList();
    static /* synthetic */ Class class$org$apache$commons$javaflow$stores$JavaflowResourceStore;

    public JavaflowResourceStore() {
        this((ResourceStore)new MemoryResourceStore());
    }

    public JavaflowResourceStore(ResourceStore pStore) {
        super(pStore);
        this.tstore = new TransformingResourceStore(pStore, new ResourceTransformer[]{new BcelClassTransformer()});
        org.apache.bcel.Repository.setRepository((Repository)new ClassLoaderRepository(((Object)((Object)this)).getClass().getClassLoader()));
    }

    public void write(String pResourceName, byte[] pResourceData) {
        super.write(pResourceName, pResourceData);
        this.changes.add(pResourceName);
    }

    public void onStart() {
        this.changes.clear();
    }

    public void onStop() {
        if (this.changes.size() > 0) {
            log.debug("rewriting" + this.changes);
            Iterator it = this.changes.iterator();
            while (it.hasNext()) {
                String clazzName = (String)it.next();
                try {
                    byte[] oldClazz = super.read(clazzName);
                    if (oldClazz == null) {
                        throw new ClassNotFoundException("could not find " + clazzName);
                    }
                    this.tstore.write(clazzName, oldClazz);
                    log.debug("rewrote " + clazzName);
                }
                catch (ClassNotFoundException e2) {
                    log.error("", e2);
                }
            }
            this.changes.clear();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

