/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.javaflow.bytecode.transformation.bcel.analyser;

import java.util.HashMap;
import java.util.Hashtable;
import org.apache.bcel.generic.ATHROW;
import org.apache.bcel.generic.BranchInstruction;
import org.apache.bcel.generic.GotoInstruction;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.JsrInstruction;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.RET;
import org.apache.bcel.generic.ReturnInstruction;
import org.apache.bcel.generic.Select;
import org.apache.bcel.generic.Visitor;
import org.apache.bcel.verifier.exc.AssertionViolatedException;
import org.apache.bcel.verifier.exc.StructuralCodeConstraintException;
import org.apache.commons.javaflow.bytecode.transformation.bcel.analyser.ExceptionHandler;
import org.apache.commons.javaflow.bytecode.transformation.bcel.analyser.ExceptionHandlers;
import org.apache.commons.javaflow.bytecode.transformation.bcel.analyser.ExecutionPath;
import org.apache.commons.javaflow.bytecode.transformation.bcel.analyser.ExecutionVisitor;
import org.apache.commons.javaflow.bytecode.transformation.bcel.analyser.Frame;
import org.apache.commons.javaflow.bytecode.transformation.bcel.analyser.InstructionContext;
import org.apache.commons.javaflow.bytecode.transformation.bcel.analyser.LocalVariables;
import org.apache.commons.javaflow.bytecode.transformation.bcel.analyser.OperandStack;
import org.apache.commons.javaflow.bytecode.transformation.bcel.analyser.Subroutine;
import org.apache.commons.javaflow.bytecode.transformation.bcel.analyser.Subroutines;

public class ControlFlowGraph {
    private final Subroutines subroutines;
    private final ExceptionHandlers exceptionhandlers;
    private Hashtable instructionContexts = new Hashtable();

    public ControlFlowGraph(MethodGen method_gen) {
        this.subroutines = new Subroutines(method_gen);
        this.exceptionhandlers = new ExceptionHandlers(method_gen);
        InstructionHandle[] instructionhandles = method_gen.getInstructionList().getInstructionHandles();
        for (int i2 = 0; i2 < instructionhandles.length; ++i2) {
            this.instructionContexts.put(instructionhandles[i2], new InstructionContextImpl(instructionhandles[i2]));
        }
    }

    public InstructionContext contextOf(InstructionHandle inst) {
        InstructionContext ic = (InstructionContext)this.instructionContexts.get(inst);
        if (ic == null) {
            throw new AssertionViolatedException("InstructionContext requested for an InstructionHandle that's not known!");
        }
        return ic;
    }

    public InstructionContext[] contextsOf(InstructionHandle[] insts) {
        InstructionContext[] ret = new InstructionContext[insts.length];
        for (int i2 = 0; i2 < insts.length; ++i2) {
            ret[i2] = this.contextOf(insts[i2]);
        }
        return ret;
    }

    public InstructionContext[] getInstructionContexts() {
        InstructionContext[] ret = new InstructionContext[this.instructionContexts.values().size()];
        return this.instructionContexts.values().toArray(ret);
    }

    public boolean isDead(InstructionHandle i2) {
        return this.subroutines.subroutineOf(i2) == null;
    }

    private class InstructionContextImpl
    implements InstructionContext {
        private InstructionHandle instruction;
        private HashMap inFrames;
        private HashMap outFrames;
        private ExecutionPath executionPredecessors = null;

        public InstructionContextImpl(InstructionHandle inst) {
            if (inst == null) {
                throw new AssertionViolatedException("Cannot instantiate InstructionContextImpl from NULL.");
            }
            this.instruction = inst;
            this.inFrames = new HashMap();
            this.outFrames = new HashMap();
        }

        public ExceptionHandler[] getExceptionHandlers() {
            return ControlFlowGraph.this.exceptionhandlers.getExceptionHandlers(this.getInstruction());
        }

        public Frame getOutFrame(ExecutionPath execChain) {
            this.executionPredecessors = execChain;
            InstructionContext jsr = this.lastExecutionJSR();
            Frame org = (Frame)this.outFrames.get(jsr);
            if (org == null) {
                throw new AssertionViolatedException("outFrame not set! This:\n" + this + "\nExecutionChain: " + this.getExecutionChain() + "\nOutFrames: '" + this.outFrames + "'.");
            }
            return org.getClone();
        }

        public Frame getInFrame() {
            InstructionContext jsr = this.lastExecutionJSR();
            Frame org = (Frame)this.inFrames.get(jsr);
            if (org == null) {
                throw new AssertionViolatedException("inFrame not set! This:\n" + this + "\nInFrames: '" + this.inFrames + "'.");
            }
            return org.getClone();
        }

        public boolean execute(Frame inFrame, ExecutionPath execPreds, ExecutionVisitor ev) {
            ExecutionPath oldExecPreds = this.executionPredecessors;
            this.executionPredecessors = execPreds;
            if (this.lastExecutionJSR() == null && ControlFlowGraph.this.subroutines.subroutineOf(this.getInstruction()) != ControlFlowGraph.this.subroutines.getTopLevel()) {
                return false;
            }
            if (this.lastExecutionJSR() != null && ControlFlowGraph.this.subroutines.subroutineOf(this.getInstruction()) == ControlFlowGraph.this.subroutines.getTopLevel()) {
                return false;
            }
            Frame inF = (Frame)this.inFrames.get(this.lastExecutionJSR());
            if (inF == null) {
                this.inFrames.put(this.lastExecutionJSR(), inFrame);
                inF = inFrame;
            } else {
                if (inF.equals(inFrame)) {
                    return false;
                }
                if (!this.mergeInFrames(inFrame)) {
                    return false;
                }
            }
            Frame workingFrame = inF.getClone();
            ev.setFrame(workingFrame);
            this.getInstruction().accept((Visitor)ev);
            this.outFrames.put(this.lastExecutionJSR(), workingFrame);
            return true;
        }

        public String toString() {
            String ret = this.getInstruction().toString(false) + "\t[InstructionContext]";
            return ret;
        }

        private boolean mergeInFrames(Frame inFrame) {
            Frame inF = (Frame)this.inFrames.get(this.lastExecutionJSR());
            OperandStack oldstack = inF.getStack().getClone();
            LocalVariables oldlocals = inF.getLocals().getClone();
            try {
                inF.getStack().merge(inFrame.getStack());
                inF.getLocals().merge(inFrame.getLocals());
            }
            catch (StructuralCodeConstraintException sce) {
                this.extendMessageWithFlow(sce);
                throw sce;
            }
            return !oldstack.equals(inF.getStack()) || !oldlocals.equals(inF.getLocals());
        }

        private String getExecutionChain() {
            return this.executionPredecessors.toString() + "\n" + this.toString();
        }

        private void extendMessageWithFlow(StructuralCodeConstraintException e2) {
            String s2 = "Execution flow:\n";
            e2.extendMessage("", s2 + this.getExecutionChain());
        }

        public InstructionHandle getInstruction() {
            return this.instruction;
        }

        private InstructionContext lastExecutionJSR() {
            return this.executionPredecessors.lastExecutionJSR();
        }

        public InstructionContext[] getSuccessors() {
            return ControlFlowGraph.this.contextsOf(this._getSuccessors());
        }

        private InstructionHandle[] _getSuccessors() {
            InstructionHandle[] empty = new InstructionHandle[]{};
            InstructionHandle[] single = new InstructionHandle[1];
            InstructionHandle[] pair = new InstructionHandle[2];
            Instruction inst = this.getInstruction().getInstruction();
            if (inst instanceof RET) {
                Subroutine s2 = ControlFlowGraph.this.subroutines.subroutineOf(this.getInstruction());
                if (s2 == null) {
                    throw new AssertionViolatedException("Asking for successors of a RET in dead code?!");
                }
                throw new AssertionViolatedException("DID YOU REALLY WANT TO ASK FOR RET'S SUCCS?");
            }
            if (inst instanceof ReturnInstruction) {
                return empty;
            }
            if (inst instanceof ATHROW) {
                return empty;
            }
            if (inst instanceof JsrInstruction) {
                single[0] = ((JsrInstruction)inst).getTarget();
                return single;
            }
            if (inst instanceof GotoInstruction) {
                single[0] = ((GotoInstruction)inst).getTarget();
                return single;
            }
            if (inst instanceof BranchInstruction) {
                if (inst instanceof Select) {
                    InstructionHandle[] matchTargets = ((Select)inst).getTargets();
                    InstructionHandle[] ret = new InstructionHandle[matchTargets.length + 1];
                    ret[0] = ((Select)inst).getTarget();
                    System.arraycopy(matchTargets, 0, ret, 1, matchTargets.length);
                    return ret;
                }
                pair[0] = this.getInstruction().getNext();
                pair[1] = ((BranchInstruction)inst).getTarget();
                return pair;
            }
            single[0] = this.getInstruction().getNext();
            return single;
        }
    }
}

