/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.javaflow.ant;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import org.apache.commons.javaflow.bytecode.transformation.ResourceTransformer;
import org.apache.commons.javaflow.bytecode.transformation.asm.AsmClassTransformer;
import org.apache.commons.javaflow.bytecode.transformation.bcel.BcelClassTransformer;
import org.apache.commons.javaflow.utils.RewritingUtils;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.MatchingTask;

public class AntRewriteTask
extends MatchingTask {
    private ResourceTransformer transformer;
    private File dstDir;
    private File srcDir;

    public void setDstDir(File pFile) {
        this.dstDir = pFile;
    }

    public void setSrcDir(File pFile) {
        this.srcDir = pFile;
        this.fileset.setDir(this.srcDir);
    }

    public void setMode(String name) {
        if ((name = name.toLowerCase()).equals("bcel")) {
            this.transformer = new BcelClassTransformer();
        } else if (name.equals("asm")) {
            this.transformer = new AsmClassTransformer();
        } else {
            throw new BuildException("Unrecognized mode: " + name);
        }
    }

    protected void checkParameters() throws BuildException {
        this.checkDir(this.srcDir, "srcDir");
        this.checkDir(this.dstDir, "dstDir");
    }

    private void checkDir(File pDir, String pDescription) {
        if (pDir == null) {
            throw new BuildException("no " + pDescription + " directory is specified", this.getLocation());
        }
        if (!pDir.exists()) {
            throw new BuildException(pDescription + " directory \"" + pDir + "\" does not exist", this.getLocation());
        }
        if (!pDir.isDirectory()) {
            throw new BuildException(pDescription + " directory \"" + pDir + "\" is not a directory", this.getLocation());
        }
    }

    public void execute() throws BuildException {
        DirectoryScanner ds = this.fileset.getDirectoryScanner(this.getProject());
        String[] fileNames = ds.getIncludedFiles();
        if (this.transformer == null) {
            this.transformer = new BcelClassTransformer();
        }
        try {
            for (int i2 = 0; i2 < fileNames.length; ++i2) {
                String fileName = fileNames[i2];
                File source = new File(this.srcDir, fileName);
                File destination = new File(this.dstDir, fileName);
                if (!destination.getParentFile().exists()) {
                    this.log("Creating dir: " + destination.getParentFile(), 3);
                    destination.getParentFile().mkdirs();
                }
                if (source.lastModified() < destination.lastModified()) {
                    this.log("Omitting " + source + " as " + destination + " is up to date", 3);
                    continue;
                }
                if (fileName.endsWith(".class")) {
                    this.log("Rewriting " + source + " to " + destination, 3);
                    System.out.println("Rewriting " + source);
                    RewritingUtils.rewriteClassFile(source, this.transformer, destination);
                }
                if (!fileName.endsWith(".jar") && !fileName.endsWith(".ear") && !fileName.endsWith(".zip") && !fileName.endsWith(".war")) continue;
                this.log("Rewriting " + source + " to " + destination, 3);
                RewritingUtils.rewriteJar(new JarInputStream(new FileInputStream(source)), this.transformer, new JarOutputStream(new FileOutputStream(destination)));
            }
        }
        catch (IOException e2) {
            throw new BuildException((Throwable)e2);
        }
    }
}

