/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections;

import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class FastHashMap
extends HashMap {
    protected HashMap map = null;
    protected boolean fast = false;

    public FastHashMap() {
        this.map = new HashMap();
    }

    public FastHashMap(int capacity) {
        this.map = new HashMap(capacity);
    }

    public FastHashMap(int capacity, float factor) {
        this.map = new HashMap(capacity, factor);
    }

    public FastHashMap(Map map2) {
        this.map = new HashMap(map2);
    }

    public boolean getFast() {
        return this.fast;
    }

    public void setFast(boolean fast) {
        this.fast = fast;
    }

    public Object get(Object key) {
        if (this.fast) {
            return this.map.get(key);
        }
        HashMap hashMap = this.map;
        synchronized (hashMap) {
            Object v = this.map.get(key);
            return v;
        }
    }

    public int size() {
        if (this.fast) {
            return this.map.size();
        }
        HashMap hashMap = this.map;
        synchronized (hashMap) {
            int n = this.map.size();
            return n;
        }
    }

    public boolean isEmpty() {
        if (this.fast) {
            return this.map.isEmpty();
        }
        HashMap hashMap = this.map;
        synchronized (hashMap) {
            boolean bl = this.map.isEmpty();
            return bl;
        }
    }

    public boolean containsKey(Object key) {
        if (this.fast) {
            return this.map.containsKey(key);
        }
        HashMap hashMap = this.map;
        synchronized (hashMap) {
            boolean bl = this.map.containsKey(key);
            return bl;
        }
    }

    public boolean containsValue(Object value) {
        if (this.fast) {
            return this.map.containsValue(value);
        }
        HashMap hashMap = this.map;
        synchronized (hashMap) {
            boolean bl = this.map.containsValue(value);
            return bl;
        }
    }

    public Object put(Object key, Object value) {
        if (this.fast) {
            FastHashMap fastHashMap = this;
            synchronized (fastHashMap) {
                HashMap temp = (HashMap)this.map.clone();
                Object result = temp.put(key, value);
                this.map = temp;
                Object object2 = result;
                return object2;
            }
        }
        HashMap hashMap = this.map;
        synchronized (hashMap) {
            Object object3 = this.map.put(key, value);
            return object3;
        }
    }

    public void putAll(Map in) {
        if (this.fast) {
            FastHashMap fastHashMap = this;
            synchronized (fastHashMap) {
                HashMap temp = (HashMap)this.map.clone();
                temp.putAll(in);
                this.map = temp;
            }
        }
        HashMap hashMap = this.map;
        synchronized (hashMap) {
            this.map.putAll(in);
        }
    }

    public Object remove(Object key) {
        if (this.fast) {
            FastHashMap fastHashMap = this;
            synchronized (fastHashMap) {
                HashMap temp = (HashMap)this.map.clone();
                Object result = temp.remove(key);
                this.map = temp;
                Object v = result;
                return v;
            }
        }
        HashMap hashMap = this.map;
        synchronized (hashMap) {
            Object v = this.map.remove(key);
            return v;
        }
    }

    public void clear() {
        if (this.fast) {
            FastHashMap fastHashMap = this;
            synchronized (fastHashMap) {
                this.map = new HashMap();
            }
        }
        HashMap hashMap = this.map;
        synchronized (hashMap) {
            this.map.clear();
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        Map mo = (Map)o;
        if (this.fast) {
            if (mo.size() != this.map.size()) {
                return false;
            }
            Iterator i2 = this.map.entrySet().iterator();
            while (i2.hasNext()) {
                Map.Entry e2 = i2.next();
                Object key = e2.getKey();
                Object value = e2.getValue();
                if (!(value == null ? mo.get(key) != null || !mo.containsKey(key) : !value.equals(mo.get(key)))) continue;
                return false;
            }
            return true;
        }
        HashMap hashMap = this.map;
        synchronized (hashMap) {
            if (mo.size() != this.map.size()) {
                boolean e2 = false;
                return e2;
            }
            Iterator i3 = this.map.entrySet().iterator();
            while (i3.hasNext()) {
                Map.Entry e3 = i3.next();
                Object key = e3.getKey();
                Object value = e3.getValue();
                if (value == null) {
                    if (mo.get(key) == null && mo.containsKey(key)) continue;
                    boolean bl = false;
                    return bl;
                }
                if (value.equals(mo.get(key))) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
    }

    public int hashCode() {
        if (this.fast) {
            int h7 = 0;
            Iterator i2 = this.map.entrySet().iterator();
            while (i2.hasNext()) {
                h7 += ((Object)i2.next()).hashCode();
            }
            return h7;
        }
        HashMap hashMap = this.map;
        synchronized (hashMap) {
            int h8 = 0;
            Iterator i3 = this.map.entrySet().iterator();
            while (i3.hasNext()) {
                h8 += ((Object)i3.next()).hashCode();
            }
            int n = h8;
            return n;
        }
    }

    public Object clone() {
        FastHashMap results = null;
        if (this.fast) {
            results = new FastHashMap((Map)this.map);
        } else {
            HashMap hashMap = this.map;
            synchronized (hashMap) {
                results = new FastHashMap((Map)this.map);
            }
        }
        results.setFast(this.getFast());
        return results;
    }

    public Set entrySet() {
        return new EntrySet();
    }

    public Set keySet() {
        return new KeySet();
    }

    public Collection values() {
        return new Values();
    }

    private class EntrySet
    extends CollectionView
    implements Set {
        private EntrySet() {
        }

        protected Collection get(Map map2) {
            return map2.entrySet();
        }

        protected Object iteratorNext(Map.Entry entry) {
            return entry;
        }
    }

    private class Values
    extends CollectionView {
        private Values() {
        }

        protected Collection get(Map map2) {
            return map2.values();
        }

        protected Object iteratorNext(Map.Entry entry) {
            return entry.getValue();
        }
    }

    private class KeySet
    extends CollectionView
    implements Set {
        private KeySet() {
        }

        protected Collection get(Map map2) {
            return map2.keySet();
        }

        protected Object iteratorNext(Map.Entry entry) {
            return entry.getKey();
        }
    }

    private abstract class CollectionView
    implements Collection {
        protected abstract Collection get(Map var1);

        protected abstract Object iteratorNext(Map.Entry var1);

        public void clear() {
            if (FastHashMap.this.fast) {
                FastHashMap fastHashMap = FastHashMap.this;
                synchronized (fastHashMap) {
                    FastHashMap.this.map = new HashMap();
                }
            }
            HashMap hashMap = FastHashMap.this.map;
            synchronized (hashMap) {
                this.get(FastHashMap.this.map).clear();
            }
        }

        public boolean remove(Object o) {
            if (FastHashMap.this.fast) {
                FastHashMap fastHashMap = FastHashMap.this;
                synchronized (fastHashMap) {
                    HashMap temp = (HashMap)FastHashMap.this.map.clone();
                    boolean r = this.get(temp).remove(o);
                    FastHashMap.this.map = temp;
                    boolean bl = r;
                    return bl;
                }
            }
            HashMap hashMap = FastHashMap.this.map;
            synchronized (hashMap) {
                boolean bl = this.get(FastHashMap.this.map).remove(o);
                return bl;
            }
        }

        public boolean removeAll(Collection o) {
            if (FastHashMap.this.fast) {
                FastHashMap fastHashMap = FastHashMap.this;
                synchronized (fastHashMap) {
                    HashMap temp = (HashMap)FastHashMap.this.map.clone();
                    boolean r = this.get(temp).removeAll(o);
                    FastHashMap.this.map = temp;
                    boolean bl = r;
                    return bl;
                }
            }
            HashMap hashMap = FastHashMap.this.map;
            synchronized (hashMap) {
                boolean bl = this.get(FastHashMap.this.map).removeAll(o);
                return bl;
            }
        }

        public boolean retainAll(Collection o) {
            if (FastHashMap.this.fast) {
                FastHashMap fastHashMap = FastHashMap.this;
                synchronized (fastHashMap) {
                    HashMap temp = (HashMap)FastHashMap.this.map.clone();
                    boolean r = this.get(temp).retainAll(o);
                    FastHashMap.this.map = temp;
                    boolean bl = r;
                    return bl;
                }
            }
            HashMap hashMap = FastHashMap.this.map;
            synchronized (hashMap) {
                boolean bl = this.get(FastHashMap.this.map).retainAll(o);
                return bl;
            }
        }

        public int size() {
            if (FastHashMap.this.fast) {
                return this.get(FastHashMap.this.map).size();
            }
            HashMap hashMap = FastHashMap.this.map;
            synchronized (hashMap) {
                int n = this.get(FastHashMap.this.map).size();
                return n;
            }
        }

        public boolean isEmpty() {
            if (FastHashMap.this.fast) {
                return this.get(FastHashMap.this.map).isEmpty();
            }
            HashMap hashMap = FastHashMap.this.map;
            synchronized (hashMap) {
                boolean bl = this.get(FastHashMap.this.map).isEmpty();
                return bl;
            }
        }

        public boolean contains(Object o) {
            if (FastHashMap.this.fast) {
                return this.get(FastHashMap.this.map).contains(o);
            }
            HashMap hashMap = FastHashMap.this.map;
            synchronized (hashMap) {
                boolean bl = this.get(FastHashMap.this.map).contains(o);
                return bl;
            }
        }

        public boolean containsAll(Collection o) {
            if (FastHashMap.this.fast) {
                return this.get(FastHashMap.this.map).containsAll(o);
            }
            HashMap hashMap = FastHashMap.this.map;
            synchronized (hashMap) {
                boolean bl = this.get(FastHashMap.this.map).containsAll(o);
                return bl;
            }
        }

        public Object[] toArray(Object[] o) {
            if (FastHashMap.this.fast) {
                return this.get(FastHashMap.this.map).toArray(o);
            }
            HashMap hashMap = FastHashMap.this.map;
            synchronized (hashMap) {
                Object[] objectArray = this.get(FastHashMap.this.map).toArray(o);
                return objectArray;
            }
        }

        public Object[] toArray() {
            if (FastHashMap.this.fast) {
                return this.get(FastHashMap.this.map).toArray();
            }
            HashMap hashMap = FastHashMap.this.map;
            synchronized (hashMap) {
                Object[] objectArray = this.get(FastHashMap.this.map).toArray();
                return objectArray;
            }
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (FastHashMap.this.fast) {
                return this.get(FastHashMap.this.map).equals(o);
            }
            HashMap hashMap = FastHashMap.this.map;
            synchronized (hashMap) {
                boolean bl = this.get(FastHashMap.this.map).equals(o);
                return bl;
            }
        }

        public int hashCode() {
            if (FastHashMap.this.fast) {
                return this.get(FastHashMap.this.map).hashCode();
            }
            HashMap hashMap = FastHashMap.this.map;
            synchronized (hashMap) {
                int n = this.get(FastHashMap.this.map).hashCode();
                return n;
            }
        }

        public boolean add(Object o) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(Collection c2) {
            throw new UnsupportedOperationException();
        }

        public Iterator iterator() {
            return new CollectionViewIterator();
        }

        private class CollectionViewIterator
        implements Iterator {
            private Map expected;
            private Map.Entry lastReturned = null;
            private Iterator iterator;

            public CollectionViewIterator() {
                this.expected = ((CollectionView)CollectionView.this).FastHashMap.this.map;
                this.iterator = this.expected.entrySet().iterator();
            }

            public boolean hasNext() {
                if (this.expected != ((CollectionView)CollectionView.this).FastHashMap.this.map) {
                    throw new ConcurrentModificationException();
                }
                return this.iterator.hasNext();
            }

            public Object next() {
                if (this.expected != ((CollectionView)CollectionView.this).FastHashMap.this.map) {
                    throw new ConcurrentModificationException();
                }
                this.lastReturned = (Map.Entry)this.iterator.next();
                return CollectionView.this.iteratorNext(this.lastReturned);
            }

            public void remove() {
                if (this.lastReturned == null) {
                    throw new IllegalStateException();
                }
                if (((CollectionView)CollectionView.this).FastHashMap.this.fast) {
                    FastHashMap fastHashMap = FastHashMap.this;
                    synchronized (fastHashMap) {
                        if (this.expected != ((CollectionView)CollectionView.this).FastHashMap.this.map) {
                            throw new ConcurrentModificationException();
                        }
                        FastHashMap.this.remove(this.lastReturned.getKey());
                        this.lastReturned = null;
                        this.expected = ((CollectionView)CollectionView.this).FastHashMap.this.map;
                    }
                } else {
                    this.iterator.remove();
                    this.lastReturned = null;
                }
            }
        }
    }
}

