/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.barbecue;

import net.sourceforge.barbecue.Barcode;
import net.sourceforge.barbecue.BarcodeException;
import net.sourceforge.barbecue.linear.codabar.CodabarBarcode;
import net.sourceforge.barbecue.linear.code128.Code128Barcode;
import net.sourceforge.barbecue.linear.code128.UCCEAN128Barcode;
import net.sourceforge.barbecue.linear.code39.Code39Barcode;
import net.sourceforge.barbecue.twod.pdf417.PDF417Barcode;

public final class BarcodeFactory {
    private BarcodeFactory() {
    }

    public static Barcode createCode128(String string) throws BarcodeException {
        return new Code128Barcode(string, 3);
    }

    public static Barcode createCode128A(String string) throws BarcodeException {
        return new Code128Barcode(string, 0);
    }

    public static Barcode createCode128B(String string) throws BarcodeException {
        return new Code128Barcode(string, 1);
    }

    public static Barcode createCode128C(String string) throws BarcodeException {
        return new Code128Barcode(string, 2);
    }

    public static Barcode createUCC128(String string, String string2) throws BarcodeException {
        return new UCCEAN128Barcode(string, string2);
    }

    public static Barcode createEAN128(String string) throws BarcodeException {
        return new UCCEAN128Barcode("01", string);
    }

    public static Barcode createUSPS(String string) throws BarcodeException {
        return new UCCEAN128Barcode("420", string);
    }

    public static Barcode createShipmentIdentificationNumber(String string) throws BarcodeException {
        return new UCCEAN128Barcode("402", string);
    }

    public static Barcode createSSCC18(String string) throws BarcodeException {
        return new UCCEAN128Barcode("00", string);
    }

    public static Barcode createSCC14ShippingCode(String string) throws BarcodeException {
        return new UCCEAN128Barcode("01", string);
    }

    public static Barcode createGlobalTradeItemNumber(String string) throws BarcodeException {
        return new UCCEAN128Barcode("01", string);
    }

    public static Barcode createPDF417(String string) throws BarcodeException {
        return new PDF417Barcode(string);
    }

    public static Barcode createCode39(String string, boolean bl) throws BarcodeException {
        return new Code39Barcode(string, bl);
    }

    public static Barcode create3of9(String string, boolean bl) throws BarcodeException {
        return new Code39Barcode(string, bl);
    }

    public static Barcode createUSD3(String string, boolean bl) throws BarcodeException {
        return new Code39Barcode(string, bl);
    }

    public static Barcode createCodabar(String string) throws BarcodeException {
        return new CodabarBarcode(string);
    }

    public static Barcode createUSD4(String string) throws BarcodeException {
        return new CodabarBarcode(string);
    }

    public static Barcode createNW7(String string) throws BarcodeException {
        return new CodabarBarcode(string);
    }

    public static Barcode createMonarch(String string) throws BarcodeException {
        return new CodabarBarcode(string);
    }

    public static Barcode create2of7(String string) throws BarcodeException {
        return new CodabarBarcode(string);
    }
}

