/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export;

import java.awt.Dimension;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.jasperreports.engine.JRAbstractExporter;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.JRGenericElementType;
import net.sf.jasperreports.engine.JRGenericPrintElement;
import net.sf.jasperreports.engine.JRImageRenderer;
import net.sf.jasperreports.engine.JRLineBox;
import net.sf.jasperreports.engine.JROrigin;
import net.sf.jasperreports.engine.JRPen;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintEllipse;
import net.sf.jasperreports.engine.JRPrintFrame;
import net.sf.jasperreports.engine.JRPrintGraphicElement;
import net.sf.jasperreports.engine.JRPrintHyperlink;
import net.sf.jasperreports.engine.JRPrintHyperlinkParameter;
import net.sf.jasperreports.engine.JRPrintHyperlinkParameters;
import net.sf.jasperreports.engine.JRPrintImage;
import net.sf.jasperreports.engine.JRPrintLine;
import net.sf.jasperreports.engine.JRPrintPage;
import net.sf.jasperreports.engine.JRPrintRectangle;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.JRPropertiesHolder;
import net.sf.jasperreports.engine.JRPropertiesMap;
import net.sf.jasperreports.engine.JRRenderable;
import net.sf.jasperreports.engine.JRReportFont;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.JRWrappingSvgRenderer;
import net.sf.jasperreports.engine.export.JRExportProgressMonitor;
import net.sf.jasperreports.engine.export.JRHyperlinkProducerFactory;
import net.sf.jasperreports.engine.export.JRXmlExporterParameter;
import net.sf.jasperreports.engine.util.JRValueStringUtils;
import net.sf.jasperreports.engine.util.JRXmlWriteHelper;
import net.sf.jasperreports.engine.xml.JRXmlConstants;
import org.w3c.tools.codec.Base64Encoder;

public class JRXmlExporter
extends JRAbstractExporter {
    private static final String XML_EXPORTER_PROPERTIES_PREFIX = "net.sf.jasperreports.export.xml.";
    private static final String PROPERTY_START_PAGE_INDEX = "net.sf.jasperreports.export.xml.start.page.index";
    private static final String PROPERTY_END_PAGE_INDEX = "net.sf.jasperreports.export.xml.end.page.index";
    private static final String PROPERTY_PAGE_COUNT = "net.sf.jasperreports.export.xml.page.count";
    protected static final String DEFAULT_XML_ENCODING = "UTF-8";
    protected static final String DEFAULT_OBJECT_TYPE = "java.lang.String";
    protected static final String HTML_FILES_SUFFIX = "_files";
    protected static final String IMAGE_PREFIX = "img_";
    protected JRXmlWriteHelper xmlWriter = null;
    protected String encoding = null;
    protected JRExportProgressMonitor progressMonitor = null;
    protected Map rendererToImagePathMap = null;
    protected Map imageNameToImageDataMap = null;
    protected Map fontsMap = new HashMap();
    protected Map stylesMap = new HashMap();
    protected String dtdLocation = null;
    protected boolean isEmbeddingImages = true;
    protected File destFile = null;
    protected File imagesDir = null;
    private static int imageId = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportReport() throws JRException {
        block17: {
            this.progressMonitor = (JRExportProgressMonitor)this.parameters.get(JRExporterParameter.PROGRESS_MONITOR);
            this.setOffset();
            try {
                this.setExportContext();
                this.setInput();
                if (!this.parameters.containsKey(JRExporterParameter.FILTER)) {
                    this.filter = this.createFilter(XML_EXPORTER_PROPERTIES_PREFIX);
                }
                this.setPageRange();
                this.dtdLocation = (String)this.parameters.get(JRXmlExporterParameter.DTD_LOCATION);
                if (this.dtdLocation == null) {
                    this.dtdLocation = "http://jasperreports.sourceforge.net/dtds/jasperprint.dtd";
                }
                this.encoding = (String)this.parameters.get(JRExporterParameter.CHARACTER_ENCODING);
                if (this.encoding == null) {
                    this.encoding = DEFAULT_XML_ENCODING;
                }
                this.setHyperlinkProducerFactory();
                StringBuffer sb = (StringBuffer)this.parameters.get(JRExporterParameter.OUTPUT_STRING_BUFFER);
                if (sb != null) {
                    StringBuffer buffer = this.exportReportToBuffer();
                    sb.append(buffer.toString());
                    break block17;
                }
                Writer outWriter = (Writer)this.parameters.get(JRExporterParameter.OUTPUT_WRITER);
                if (outWriter != null) {
                    try {
                        this.exportReportToStream(outWriter);
                        break block17;
                    }
                    catch (IOException e2) {
                        throw new JRException("Error writing to writer : " + this.jasperPrint.getName(), e2);
                    }
                }
                OutputStream os = (OutputStream)this.parameters.get(JRExporterParameter.OUTPUT_STREAM);
                if (os != null) {
                    try {
                        this.exportReportToStream(new OutputStreamWriter(os, this.encoding));
                        break block17;
                    }
                    catch (Exception e3) {
                        throw new JRException("Error writing to OutputStream : " + this.jasperPrint.getName(), e3);
                    }
                }
                this.destFile = (File)this.parameters.get(JRExporterParameter.OUTPUT_FILE);
                if (this.destFile == null) {
                    String fileName = (String)this.parameters.get(JRExporterParameter.OUTPUT_FILE_NAME);
                    if (fileName != null) {
                        this.destFile = new File(fileName);
                    } else {
                        throw new JRException("No output specified for the exporter.");
                    }
                }
                this.imagesDir = new File(this.destFile.getParent(), this.destFile.getName() + HTML_FILES_SUFFIX);
                Boolean isEmbeddingImagesParameter = (Boolean)this.parameters.get(JRXmlExporterParameter.IS_EMBEDDING_IMAGES);
                if (isEmbeddingImagesParameter == null) {
                    isEmbeddingImagesParameter = Boolean.TRUE;
                }
                this.isEmbeddingImages = isEmbeddingImagesParameter;
                this.exportReportToFile();
            }
            finally {
                this.resetExportContext();
            }
        }
    }

    protected void setHyperlinkProducerFactory() {
        this.hyperlinkProducerFactory = (JRHyperlinkProducerFactory)this.parameters.get(JRExporterParameter.HYPERLINK_PRODUCER_FACTORY);
    }

    protected void exportReportToFile() throws JRException {
        Set imageNames;
        this.rendererToImagePathMap = new HashMap();
        this.imageNameToImageDataMap = new HashMap();
        Writer writer = null;
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this.destFile);
            writer = new BufferedWriter(new OutputStreamWriter((OutputStream)fileOutputStream, this.encoding));
            this.exportReportToStream(writer);
        }
        catch (IOException e2) {
            throw new JRException("Error writing to file : " + this.destFile, e2);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e3) {}
            }
        }
        if (!this.isEmbeddingImages && (imageNames = this.imageNameToImageDataMap.keySet()) != null && imageNames.size() > 0) {
            if (!this.imagesDir.exists()) {
                this.imagesDir.mkdir();
            }
            Iterator it = imageNames.iterator();
            while (it.hasNext()) {
                String imageName = (String)it.next();
                byte[] imageData = (byte[])this.imageNameToImageDataMap.get(imageName);
                File imageFile = new File(this.imagesDir, imageName);
                FileOutputStream fos = null;
                try {
                    fos = new FileOutputStream(imageFile);
                    ((OutputStream)fos).write(imageData, 0, imageData.length);
                }
                catch (IOException e4) {
                    throw new JRException("Error writing to image file : " + imageFile, e4);
                }
                finally {
                    if (fos == null) continue;
                    try {
                        ((OutputStream)fos).close();
                    }
                    catch (IOException e5) {}
                }
            }
        }
    }

    protected StringBuffer exportReportToBuffer() throws JRException {
        StringWriter buffer = new StringWriter();
        try {
            this.exportReportToStream(buffer);
        }
        catch (IOException e2) {
            throw new JRException("Error while exporting report to buffer", e2);
        }
        return buffer.getBuffer();
    }

    protected void exportReportToStream(Writer writer) throws JRException, IOException {
        List pages;
        JRStyle[] styles;
        JRReportFont[] fonts;
        this.xmlWriter = new JRXmlWriteHelper(writer);
        this.xmlWriter.writeProlog(this.encoding);
        this.xmlWriter.writePublicDoctype("jasperPrint", "-//JasperReports//DTD JasperPrint//EN", this.dtdLocation);
        this.xmlWriter.startElement("jasperPrint");
        this.xmlWriter.addEncodedAttribute("name", this.jasperPrint.getName());
        this.xmlWriter.addAttribute("pageWidth", this.jasperPrint.getPageWidth());
        this.xmlWriter.addAttribute("pageHeight", this.jasperPrint.getPageHeight());
        this.xmlWriter.addAttribute("orientation", this.jasperPrint.getOrientation(), JRXmlConstants.getOrientationMap(), (byte)1);
        this.xmlWriter.addAttribute("formatFactoryClass", this.jasperPrint.getFormatFactoryClass());
        this.xmlWriter.addEncodedAttribute("locale", this.jasperPrint.getLocaleCode());
        this.xmlWriter.addEncodedAttribute("timezone", this.jasperPrint.getTimeZoneId());
        this.xmlWriter.startElement("property");
        this.xmlWriter.addEncodedAttribute("name", PROPERTY_START_PAGE_INDEX);
        this.xmlWriter.addEncodedAttribute("value", String.valueOf(this.startPageIndex));
        this.xmlWriter.closeElement();
        this.xmlWriter.startElement("property");
        this.xmlWriter.addEncodedAttribute("name", PROPERTY_END_PAGE_INDEX);
        this.xmlWriter.addEncodedAttribute("value", String.valueOf(this.endPageIndex));
        this.xmlWriter.closeElement();
        this.xmlWriter.startElement("property");
        this.xmlWriter.addEncodedAttribute("name", PROPERTY_PAGE_COUNT);
        this.xmlWriter.addEncodedAttribute("value", this.jasperPrint.getPages() == null ? null : String.valueOf(this.jasperPrint.getPages().size()));
        this.xmlWriter.closeElement();
        this.exportProperties(this.jasperPrint);
        JROrigin[] origins = this.jasperPrint.getOrigins();
        if (origins != null && origins.length > 0) {
            for (int i2 = 0; i2 < origins.length; ++i2) {
                this.exportOrigin(origins[i2]);
            }
        }
        if ((fonts = this.jasperPrint.getFonts()) != null && fonts.length > 0) {
            for (int i3 = 0; i3 < fonts.length; ++i3) {
                this.fontsMap.put(fonts[i3].getName(), fonts[i3]);
                this.exportReportFont(fonts[i3]);
            }
        }
        if ((styles = this.jasperPrint.getStyles()) != null && styles.length > 0) {
            for (int i4 = 0; i4 < styles.length; ++i4) {
                this.stylesMap.put(styles[i4].getName(), styles[i4]);
                this.exportStyle(styles[i4]);
            }
        }
        if ((pages = this.jasperPrint.getPages()) != null && pages.size() > 0) {
            JRPrintPage page = null;
            for (int i5 = this.startPageIndex; i5 <= this.endPageIndex; ++i5) {
                if (Thread.currentThread().isInterrupted()) {
                    throw new JRException("Current thread interrupted.");
                }
                page = (JRPrintPage)pages.get(i5);
                this.exportPage(page);
            }
        }
        this.xmlWriter.closeElement();
        writer.flush();
    }

    protected void exportProperties(JRPropertiesHolder propertiesHolder) throws IOException {
        JRPropertiesMap propertiesMap;
        String[] propertyNames;
        if (propertiesHolder.hasProperties() && (propertyNames = (propertiesMap = propertiesHolder.getPropertiesMap()).getPropertyNames()) != null && propertyNames.length > 0) {
            for (int i2 = 0; i2 < propertyNames.length; ++i2) {
                this.xmlWriter.startElement("property");
                this.xmlWriter.addEncodedAttribute("name", propertyNames[i2]);
                String value = propertiesMap.getProperty(propertyNames[i2]);
                if (value != null) {
                    this.xmlWriter.addEncodedAttribute("value", value);
                }
                this.xmlWriter.closeElement();
            }
        }
    }

    protected void exportReportFont(JRReportFont font2) throws IOException {
        this.xmlWriter.startElement("reportFont");
        this.xmlWriter.addEncodedAttribute("name", font2.getName());
        this.xmlWriter.addAttribute("isDefault", font2.isDefault());
        this.xmlWriter.addEncodedAttribute("fontName", font2.getFontName());
        this.xmlWriter.addAttribute("size", font2.getFontSize());
        this.xmlWriter.addAttribute("isBold", font2.isBold());
        this.xmlWriter.addAttribute("isItalic", font2.isItalic());
        this.xmlWriter.addAttribute("isUnderline", font2.isUnderline());
        this.xmlWriter.addAttribute("isStrikeThrough", font2.isStrikeThrough());
        this.xmlWriter.addEncodedAttribute("pdfFontName", font2.getPdfFontName());
        this.xmlWriter.addEncodedAttribute("pdfEncoding", font2.getPdfEncoding());
        this.xmlWriter.addAttribute("isPdfEmbedded", font2.isPdfEmbedded());
        this.xmlWriter.closeElement();
    }

    protected void exportStyle(JRStyle style2) throws IOException {
        this.xmlWriter.startElement("style");
        this.xmlWriter.addEncodedAttribute("name", style2.getName());
        this.xmlWriter.addAttribute("isDefault", style2.isDefault());
        if (style2.getStyle() != null) {
            JRStyle baseStyle = (JRStyle)this.stylesMap.get(style2.getStyle().getName());
            if (baseStyle != null) {
                this.xmlWriter.addEncodedAttribute("style", style2.getStyle().getName());
            } else {
                throw new JRRuntimeException("Referenced report style not found : " + style2.getStyle().getName());
            }
        }
        this.xmlWriter.addAttribute("mode", style2.getOwnMode(), JRXmlConstants.getModeMap());
        this.xmlWriter.addAttribute("forecolor", style2.getOwnForecolor());
        this.xmlWriter.addAttribute("backcolor", style2.getOwnBackcolor());
        this.xmlWriter.addAttribute("fill", style2.getOwnFill(), JRXmlConstants.getFillMap());
        this.xmlWriter.addAttribute("radius", style2.getOwnRadius());
        this.xmlWriter.addAttribute("scaleImage", style2.getOwnScaleImage(), JRXmlConstants.getScaleImageMap());
        this.xmlWriter.addAttribute("hAlign", style2.getOwnHorizontalAlignment(), JRXmlConstants.getHorizontalAlignMap());
        this.xmlWriter.addAttribute("vAlign", style2.getOwnVerticalAlignment(), JRXmlConstants.getVerticalAlignMap());
        this.xmlWriter.addAttribute("rotation", style2.getOwnRotation(), JRXmlConstants.getRotationMap());
        this.xmlWriter.addAttribute("lineSpacing", style2.getOwnLineSpacing(), JRXmlConstants.getLineSpacingMap());
        this.xmlWriter.addAttribute("markup", style2.getOwnMarkup());
        this.xmlWriter.addEncodedAttribute("fontName", style2.getOwnFontName());
        this.xmlWriter.addAttribute("fontSize", style2.getOwnFontSize());
        this.xmlWriter.addAttribute("isBold", style2.isOwnBold());
        this.xmlWriter.addAttribute("isItalic", style2.isOwnItalic());
        this.xmlWriter.addAttribute("isUnderline", style2.isOwnUnderline());
        this.xmlWriter.addAttribute("isStrikeThrough", style2.isOwnStrikeThrough());
        this.xmlWriter.addEncodedAttribute("pdfFontName", style2.getOwnPdfFontName());
        this.xmlWriter.addEncodedAttribute("pdfEncoding", style2.getOwnPdfEncoding());
        this.xmlWriter.addAttribute("isPdfEmbedded", style2.isOwnPdfEmbedded());
        this.exportPen(style2.getLinePen());
        this.exportBox(style2.getLineBox());
        this.xmlWriter.closeElement();
    }

    protected void exportOrigin(JROrigin origin) throws IOException {
        this.xmlWriter.startElement("origin");
        this.xmlWriter.addEncodedAttribute("report", origin.getReportName());
        this.xmlWriter.addEncodedAttribute("group", origin.getGroupName());
        this.xmlWriter.addAttribute("band", origin.getBandType(), JRXmlConstants.getBandTypeMap());
        this.xmlWriter.closeElement();
    }

    protected void exportPage(JRPrintPage page) throws JRException, IOException {
        this.xmlWriter.startElement("page");
        this.exportElements(page.getElements());
        this.xmlWriter.closeElement();
        if (this.progressMonitor != null) {
            this.progressMonitor.afterPageExport();
        }
    }

    protected void exportElements(Collection elements) throws IOException, JRException {
        if (elements != null && elements.size() > 0) {
            Iterator it = elements.iterator();
            while (it.hasNext()) {
                JRPrintElement element = (JRPrintElement)it.next();
                if (this.filter != null && !this.filter.isToExport(element)) continue;
                if (element instanceof JRPrintLine) {
                    this.exportLine((JRPrintLine)element);
                    continue;
                }
                if (element instanceof JRPrintRectangle) {
                    this.exportRectangle((JRPrintRectangle)element);
                    continue;
                }
                if (element instanceof JRPrintEllipse) {
                    this.exportEllipse((JRPrintEllipse)element);
                    continue;
                }
                if (element instanceof JRPrintImage) {
                    this.exportImage((JRPrintImage)element);
                    continue;
                }
                if (element instanceof JRPrintText) {
                    this.exportText((JRPrintText)element);
                    continue;
                }
                if (element instanceof JRPrintFrame) {
                    this.exportFrame((JRPrintFrame)element);
                    continue;
                }
                if (!(element instanceof JRGenericPrintElement)) continue;
                this.exportGenericElement((JRGenericPrintElement)element);
            }
        }
    }

    protected void exportLine(JRPrintLine line) throws IOException {
        this.xmlWriter.startElement("line");
        this.xmlWriter.addAttribute("direction", line.getDirection(), JRXmlConstants.getDirectionMap(), (byte)1);
        this.exportReportElement(line);
        this.exportGraphicElement(line);
        this.xmlWriter.closeElement();
    }

    protected void exportReportElement(JRPrintElement element) throws IOException {
        this.xmlWriter.startElement("reportElement");
        this.xmlWriter.addEncodedAttribute("key", element.getKey());
        JRStyle style2 = element.getStyle();
        if (style2 != null) {
            this.xmlWriter.addEncodedAttribute("style", style2.getName());
        }
        this.xmlWriter.addAttribute("mode", element.getOwnMode(), JRXmlConstants.getModeMap());
        this.xmlWriter.addAttribute("x", element.getX() + this.getOffsetX());
        this.xmlWriter.addAttribute("y", element.getY() + this.getOffsetY());
        this.xmlWriter.addAttribute("width", element.getWidth());
        this.xmlWriter.addAttribute("height", element.getHeight());
        this.xmlWriter.addAttribute("forecolor", element.getOwnForecolor());
        this.xmlWriter.addAttribute("backcolor", element.getOwnBackcolor());
        JROrigin origin = element.getOrigin();
        if (origin != null) {
            this.xmlWriter.addAttribute("origin", this.jasperPrint.getOriginsMap().get(origin));
        }
        this.exportProperties(element);
        this.xmlWriter.closeElement();
    }

    protected void exportGraphicElement(JRPrintGraphicElement element) throws IOException {
        this.xmlWriter.startElement("graphicElement");
        this.xmlWriter.addAttribute("fill", element.getOwnFill(), JRXmlConstants.getFillMap());
        this.exportPen(element.getLinePen());
        this.xmlWriter.closeElement(true);
    }

    protected void exportPen(JRPen pen) throws IOException {
        this.exportPen("pen", pen);
    }

    protected void exportPen(String element, JRPen pen) throws IOException {
        this.xmlWriter.startElement(element);
        this.xmlWriter.addAttribute("lineWidth", pen.getOwnLineWidth());
        this.xmlWriter.addAttribute("lineStyle", pen.getOwnLineStyle(), JRXmlConstants.getLineStyleMap());
        this.xmlWriter.addAttribute("lineColor", pen.getOwnLineColor());
        this.xmlWriter.closeElement(true);
    }

    protected void exportRectangle(JRPrintRectangle rectangle) throws IOException {
        this.xmlWriter.startElement("rectangle");
        this.xmlWriter.addAttribute("radius", rectangle.getOwnRadius());
        this.exportReportElement(rectangle);
        this.exportGraphicElement(rectangle);
        this.xmlWriter.closeElement();
    }

    protected void exportEllipse(JRPrintEllipse ellipse) throws IOException {
        this.xmlWriter.startElement("ellipse");
        this.exportReportElement(ellipse);
        this.exportGraphicElement(ellipse);
        this.xmlWriter.closeElement();
    }

    protected void exportImage(JRPrintImage image) throws JRException, IOException {
        this.xmlWriter.startElement("image");
        this.xmlWriter.addAttribute("scaleImage", image.getOwnScaleImage(), JRXmlConstants.getScaleImageMap());
        this.xmlWriter.addAttribute("hAlign", image.getOwnHorizontalAlignment(), JRXmlConstants.getHorizontalAlignMap());
        this.xmlWriter.addAttribute("vAlign", image.getOwnVerticalAlignment(), JRXmlConstants.getVerticalAlignMap());
        this.xmlWriter.addAttribute("isLazy", image.isLazy(), false);
        this.xmlWriter.addAttribute("onErrorType", image.getOnErrorType(), JRXmlConstants.getOnErrorTypeMap(), (byte)1);
        if (this.hyperlinkProducerFactory == null) {
            this.xmlWriter.addEncodedAttribute("hyperlinkType", image.getLinkType(), "None");
            this.xmlWriter.addEncodedAttribute("hyperlinkReference", image.getHyperlinkReference());
            this.xmlWriter.addEncodedAttribute("hyperlinkAnchor", image.getHyperlinkAnchor());
            this.xmlWriter.addAttribute("hyperlinkPage", image.getHyperlinkPage());
        } else {
            String reference = this.hyperlinkProducerFactory.produceHyperlink(image);
            if (reference != null) {
                this.xmlWriter.addAttribute("hyperlinkType", "Reference");
                this.xmlWriter.addEncodedAttribute("hyperlinkReference", reference);
            }
        }
        this.xmlWriter.addAttribute("hyperlinkTarget", image.getLinkTarget(), "Self");
        this.xmlWriter.addEncodedAttribute("hyperlinkTooltip", image.getHyperlinkTooltip());
        this.xmlWriter.addEncodedAttribute("anchorName", image.getAnchorName());
        this.xmlWriter.addAttribute("bookmarkLevel", image.getBookmarkLevel(), 0);
        this.exportReportElement(image);
        this.exportBox(image.getLineBox());
        this.exportGraphicElement(image);
        JRRenderable renderer = image.getRenderer();
        if (renderer != null) {
            this.xmlWriter.startElement("imageSource");
            this.xmlWriter.addAttribute("isEmbedded", this.isEmbeddingImages && !image.isLazy(), false);
            String imageSource = "";
            if (renderer.getType() == 1) {
                renderer = new JRWrappingSvgRenderer(renderer, new Dimension(image.getWidth(), image.getHeight()), 1 == image.getMode() ? image.getBackcolor() : null);
            }
            if (image.isLazy()) {
                imageSource = ((JRImageRenderer)renderer).getImageLocation();
            } else if (this.isEmbeddingImages) {
                try {
                    ByteArrayInputStream bais = new ByteArrayInputStream(renderer.getImageData());
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    Base64Encoder encoder = new Base64Encoder(bais, baos);
                    encoder.process();
                    imageSource = new String(baos.toByteArray(), DEFAULT_XML_ENCODING);
                }
                catch (IOException e2) {
                    throw new JRException("Error embedding image into XML.", e2);
                }
            } else if (renderer.getType() == 0 && this.rendererToImagePathMap.containsKey(renderer)) {
                imageSource = (String)this.rendererToImagePathMap.get(renderer);
            } else {
                imageSource = IMAGE_PREFIX + JRXmlExporter.getNextImageId();
                this.imageNameToImageDataMap.put(imageSource, renderer.getImageData());
                imageSource = new File(this.imagesDir, imageSource).getPath();
                this.rendererToImagePathMap.put(renderer, imageSource);
            }
            this.xmlWriter.writeCDATA(imageSource);
            this.xmlWriter.closeElement();
        }
        if (this.hyperlinkProducerFactory == null) {
            this.exportHyperlinkParameters(image);
        }
        this.xmlWriter.closeElement();
    }

    protected void exportText(JRPrintText text) throws IOException {
        this.xmlWriter.startElement("text");
        this.xmlWriter.addAttribute("textAlignment", text.getOwnHorizontalAlignment(), JRXmlConstants.getHorizontalAlignMap());
        this.xmlWriter.addAttribute("verticalAlignment", text.getOwnVerticalAlignment(), JRXmlConstants.getVerticalAlignMap());
        this.xmlWriter.addAttribute("textHeight", text.getTextHeight());
        this.xmlWriter.addAttribute("rotation", text.getOwnRotation(), JRXmlConstants.getRotationMap());
        this.xmlWriter.addAttribute("runDirection", text.getRunDirection(), JRXmlConstants.getRunDirectionMap(), (byte)0);
        this.xmlWriter.addAttribute("lineSpacing", text.getOwnLineSpacing(), JRXmlConstants.getLineSpacingMap());
        this.xmlWriter.addAttribute("markup", text.getOwnMarkup());
        this.xmlWriter.addAttribute("lineSpacingFactor", text.getLineSpacingFactor());
        this.xmlWriter.addAttribute("leadingOffset", text.getLeadingOffset());
        if (this.hyperlinkProducerFactory == null) {
            this.xmlWriter.addEncodedAttribute("hyperlinkType", text.getLinkType());
            this.xmlWriter.addEncodedAttribute("hyperlinkReference", text.getHyperlinkReference());
            this.xmlWriter.addEncodedAttribute("hyperlinkAnchor", text.getHyperlinkAnchor());
            this.xmlWriter.addAttribute("hyperlinkPage", text.getHyperlinkPage());
        } else {
            String reference = this.hyperlinkProducerFactory.produceHyperlink(text);
            if (reference != null) {
                this.xmlWriter.addAttribute("hyperlinkType", "Reference");
                this.xmlWriter.addEncodedAttribute("hyperlinkReference", reference);
            }
        }
        this.xmlWriter.addAttribute("hyperlinkTarget", text.getLinkTarget());
        this.xmlWriter.addEncodedAttribute("hyperlinkTooltip", text.getHyperlinkTooltip());
        this.xmlWriter.addEncodedAttribute("anchorName", text.getAnchorName());
        this.xmlWriter.addAttribute("bookmarkLevel", text.getBookmarkLevel(), 0);
        this.xmlWriter.addAttribute("valueClass", text.getValueClassName());
        this.xmlWriter.addEncodedAttribute("pattern", text.getPattern());
        this.xmlWriter.addAttribute("formatFactoryClass", text.getFormatFactoryClass());
        this.xmlWriter.addEncodedAttribute("locale", text.getLocaleCode());
        this.xmlWriter.addEncodedAttribute("timezone", text.getTimeZoneId());
        this.exportReportElement(text);
        this.exportBox(text.getLineBox());
        this.exportFont(text);
        if (text.getOriginalText() != null) {
            this.xmlWriter.writeCDATAElement("textContent", text.getOriginalText(), "truncateIndex", text.getTextTruncateIndex());
        }
        this.xmlWriter.writeCDATAElement("textTruncateSuffix", text.getTextTruncateSuffix());
        short[] lineBreakOffsets = text.getLineBreakOffsets();
        if (lineBreakOffsets != null) {
            StringBuffer offsetsString = this.formatTextLineBreakOffsets(lineBreakOffsets);
            this.xmlWriter.writeCDATAElement("lineBreakOffsets", offsetsString.toString());
        }
        if (this.hyperlinkProducerFactory == null) {
            this.exportHyperlinkParameters(text);
        }
        this.xmlWriter.closeElement();
    }

    protected StringBuffer formatTextLineBreakOffsets(short[] lineBreakOffsets) {
        StringBuffer offsetsString = new StringBuffer();
        for (int i2 = 0; i2 < lineBreakOffsets.length; ++i2) {
            if (i2 > 0) {
                offsetsString.append(",");
            }
            offsetsString.append(lineBreakOffsets[i2]);
        }
        return offsetsString;
    }

    private void exportBox(JRLineBox box) throws IOException {
        if (box != null) {
            this.xmlWriter.startElement("box");
            this.xmlWriter.addAttribute("padding", box.getOwnPadding());
            this.xmlWriter.addAttribute("topPadding", box.getOwnTopPadding());
            this.xmlWriter.addAttribute("leftPadding", box.getOwnLeftPadding());
            this.xmlWriter.addAttribute("bottomPadding", box.getOwnBottomPadding());
            this.xmlWriter.addAttribute("rightPadding", box.getOwnRightPadding());
            this.exportPen("pen", box.getPen());
            this.exportPen("topPen", box.getTopPen());
            this.exportPen("leftPen", box.getLeftPen());
            this.exportPen("bottomPen", box.getBottomPen());
            this.exportPen("rightPen", box.getRightPen());
            this.xmlWriter.closeElement(true);
        }
    }

    protected void exportFont(JRFont font2) throws IOException {
        if (font2 != null) {
            this.xmlWriter.startElement("font");
            if (font2.getReportFont() != null) {
                JRFont baseFont = (JRFont)this.fontsMap.get(font2.getReportFont().getName());
                if (baseFont != null) {
                    this.xmlWriter.addEncodedAttribute("reportFont", font2.getReportFont().getName());
                } else {
                    throw new JRRuntimeException("Referenced report font not found : " + font2.getReportFont().getName());
                }
            }
            this.xmlWriter.addEncodedAttribute("fontName", font2.getOwnFontName());
            this.xmlWriter.addAttribute("size", font2.getOwnFontSize());
            this.xmlWriter.addAttribute("isBold", font2.isOwnBold());
            this.xmlWriter.addAttribute("isItalic", font2.isOwnItalic());
            this.xmlWriter.addAttribute("isUnderline", font2.isOwnUnderline());
            this.xmlWriter.addAttribute("isStrikeThrough", font2.isOwnStrikeThrough());
            this.xmlWriter.addEncodedAttribute("pdfFontName", font2.getOwnPdfFontName());
            this.xmlWriter.addEncodedAttribute("pdfEncoding", font2.getOwnPdfEncoding());
            this.xmlWriter.addAttribute("isPdfEmbedded", font2.isOwnPdfEmbedded());
            this.xmlWriter.closeElement(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void exportFrame(JRPrintFrame frame2) throws IOException, JRException {
        this.xmlWriter.startElement("frame");
        this.setFrameElementsOffset(frame2, true);
        try {
            this.exportReportElement(frame2);
            this.exportBox(frame2.getLineBox());
            this.exportElements(frame2.getElements());
            this.xmlWriter.closeElement();
        }
        finally {
            this.restoreElementOffsets();
        }
    }

    private static synchronized int getNextImageId() {
        return imageId++;
    }

    protected void exportHyperlinkParameters(JRPrintHyperlink hyperlink) throws IOException {
        JRPrintHyperlinkParameters hyperlinkParameters = hyperlink.getHyperlinkParameters();
        if (hyperlinkParameters != null) {
            Iterator it = hyperlinkParameters.getParameters().iterator();
            while (it.hasNext()) {
                JRPrintHyperlinkParameter parameter = (JRPrintHyperlinkParameter)it.next();
                this.exportHyperlinkParameter(parameter);
            }
        }
    }

    protected void exportHyperlinkParameter(JRPrintHyperlinkParameter parameter) throws IOException {
        this.xmlWriter.startElement("hyperlinkParameter");
        this.xmlWriter.addEncodedAttribute("name", parameter.getName());
        this.xmlWriter.addAttribute("class", parameter.getValueClass(), DEFAULT_OBJECT_TYPE);
        if (parameter.getValue() != null) {
            String data = JRValueStringUtils.serialize(parameter.getValueClass(), parameter.getValue());
            this.xmlWriter.writeCDATAElement("hyperlinkParameterValue", data);
        }
        this.xmlWriter.closeElement();
    }

    protected void exportGenericElement(JRGenericPrintElement element) throws IOException {
        this.xmlWriter.startElement("genericElement");
        this.exportReportElement(element);
        JRGenericElementType genericType = element.getGenericType();
        this.xmlWriter.startElement("genericElementType");
        this.xmlWriter.addEncodedAttribute("namespace", genericType.getNamespace());
        this.xmlWriter.addEncodedAttribute("name", genericType.getName());
        this.xmlWriter.closeElement();
        Set names = element.getParameterNames();
        Iterator it = names.iterator();
        while (it.hasNext()) {
            String name = (String)it.next();
            Object value = element.getParameterValue(name);
            this.xmlWriter.startElement("genericElementParameter");
            this.xmlWriter.addAttribute("name", name);
            if (value != null) {
                String valueClass = value.getClass().getName();
                String data = JRValueStringUtils.serialize(valueClass, value);
                this.xmlWriter.startElement("genericElementParameterValue");
                this.xmlWriter.addAttribute("class", valueClass);
                this.xmlWriter.writeCDATA(data);
                this.xmlWriter.closeElement();
            }
            this.xmlWriter.closeElement();
        }
        this.xmlWriter.closeElement();
    }
}

