/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.convert;

import java.awt.Color;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.jasperreports.engine.JRBand;
import net.sf.jasperreports.engine.JRDefaultStyleProvider;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintPage;
import net.sf.jasperreports.engine.JRPropertiesHolder;
import net.sf.jasperreports.engine.JRReport;
import net.sf.jasperreports.engine.JRReportTemplate;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRSection;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.JRStyleContainer;
import net.sf.jasperreports.engine.JRStyleSetter;
import net.sf.jasperreports.engine.JRTemplate;
import net.sf.jasperreports.engine.JRTemplateReference;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.base.JRBaseObjectFactory;
import net.sf.jasperreports.engine.base.JRBasePrintFrame;
import net.sf.jasperreports.engine.base.JRBasePrintPage;
import net.sf.jasperreports.engine.base.JRBaseStyle;
import net.sf.jasperreports.engine.convert.ConvertVisitor;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.util.JRExpressionUtil;
import net.sf.jasperreports.engine.util.JRProperties;
import net.sf.jasperreports.engine.xml.JRXmlTemplateLoader;
import org.apache.commons.collections.SequencedHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ReportConverter {
    private static final Log log = LogFactory.getLog(ReportConverter.class);
    public static final Color GRID_LINE_COLOR = new Color(170, 170, 255);
    private final JRReport report;
    private JasperPrint jasperPrint;
    private JRPrintPage page;
    int pageWidth;
    private int offsetY;
    private int upColumns;
    private int downColumns;
    private List pageElements = new ArrayList();
    private StyleFactory styleFactory;
    protected Map stylesMap;
    protected final boolean cacheStyles;

    public ReportConverter(JRReport report, boolean ignoreContent, boolean cacheStyles) {
        this.report = report;
        this.cacheStyles = cacheStyles;
        if (report instanceof JasperDesign) {
            ((JasperDesign)report).preprocess();
        }
        this.convert(ignoreContent);
    }

    protected void convert(boolean ignoreContent) {
        this.jasperPrint = new JasperPrint();
        this.jasperPrint.setDefaultFont(this.report.getDefaultFont());
        this.jasperPrint.setFormatFactoryClass(this.report.getFormatFactoryClass());
        this.jasperPrint.setName(this.report.getName());
        this.jasperPrint.setOrientation(this.report.getOrientation());
        this.jasperPrint.setPageWidth(this.report.getPageWidth());
        this.jasperPrint.setPageHeight(this.report.getPageHeight());
        JRProperties.transferProperties(this.report, (JRPropertiesHolder)this.jasperPrint, "net.sf.jasperreports.print.transfer.");
        this.setStyles(this.report);
        if (!ignoreContent) {
            int i2;
            this.pageWidth = this.report.getPageWidth();
            this.page = new JRBasePrintPage();
            this.offsetY = this.report.getTopMargin();
            this.addBand(this.report.getBackground());
            this.addBand(this.report.getTitle());
            this.addBand(this.report.getPageHeader());
            this.upColumns = this.offsetY;
            this.addBand(this.report.getColumnHeader());
            JRGroup[] groups = this.report.getGroups();
            if (groups != null) {
                for (i2 = 0; i2 < groups.length; ++i2) {
                    this.addSection(groups[i2].getGroupHeaderSection());
                }
            }
            this.addSection(this.report.getDetailSection());
            if (groups != null) {
                for (i2 = 0; i2 < groups.length; ++i2) {
                    this.addSection(groups[i2].getGroupFooterSection());
                }
            }
            this.addBand(this.report.getColumnFooter());
            this.downColumns = this.offsetY;
            this.addBand(this.report.getPageFooter());
            this.addBand(this.report.getLastPageFooter());
            this.addBand(this.report.getSummary());
            this.addBand(this.report.getNoData());
            this.jasperPrint.setPageHeight(this.offsetY + this.report.getBottomMargin());
            int colX = this.report.getLeftMargin();
            for (int i3 = 0; i3 < this.report.getColumnCount(); ++i3) {
                this.addColumnSeparator(colX);
                this.addColumnSeparator(colX += this.report.getColumnWidth());
                colX += this.report.getColumnSpacing();
            }
            this.addHorizontalGridLine(0, this.report.getTopMargin(), this.pageWidth);
            this.addHorizontalGridLine(0, this.offsetY, this.pageWidth);
            this.addVerticalGridLine(this.report.getLeftMargin(), 0, this.jasperPrint.getPageHeight());
            this.addVerticalGridLine(this.pageWidth - this.report.getRightMargin(), 0, this.jasperPrint.getPageHeight());
            this.page.setElements(this.pageElements);
            this.jasperPrint.addPage(this.page);
        }
    }

    protected void setStyles(JRReport report) {
        this.styleFactory = new StyleFactory();
        this.stylesMap = new SequencedHashMap();
        this.loadReportStyles(report);
        try {
            Iterator it = this.stylesMap.values().iterator();
            while (it.hasNext()) {
                JRStyle style2 = (JRStyle)it.next();
                this.jasperPrint.addStyle(style2);
            }
        }
        catch (JRException e2) {
            throw new JRRuntimeException(e2);
        }
        JRStyle reportDefault = report.getDefaultStyle();
        JRStyle printDefault = null;
        if (reportDefault == null) {
            Iterator it = this.stylesMap.values().iterator();
            while (it.hasNext()) {
                JRStyle style3 = (JRStyle)it.next();
                if (!style3.isDefault()) continue;
                printDefault = style3;
            }
        } else {
            printDefault = reportDefault;
        }
        if (printDefault != null) {
            this.jasperPrint.setDefaultStyle(printDefault);
        }
    }

    protected void loadReportStyles(JRReport report) {
        JRReportTemplate[] templates = report.getTemplates();
        if (templates != null) {
            HashSet loadedLocations = new HashSet();
            for (int i2 = 0; i2 < templates.length; ++i2) {
                this.loadReportTemplateStyles(templates[i2], loadedLocations);
            }
        }
        this.collectStyles(report.getStyles());
    }

    protected void loadReportTemplateStyles(JRReportTemplate template, Set loadedLocations) {
        JRExpression sourceExpression = template.getSourceExpression();
        if (sourceExpression != null) {
            String location = JRExpressionUtil.getSimpleExpressionText(sourceExpression);
            if (location == null) {
                log.warn("Template source expression " + sourceExpression.getText() + "cannot be evaluated; some styles might remain unresolved.");
            } else {
                HashSet parentLocations = new HashSet();
                this.loadTemplateStyles(location, loadedLocations, parentLocations);
            }
        }
    }

    protected void loadTemplateStyles(String location, Set loadedLocations, Set parentLocations) {
        JRTemplate template;
        if (!parentLocations.add(location)) {
            throw new JRRuntimeException("Circular dependency found for template at location " + location);
        }
        if (!loadedLocations.add(location)) {
            return;
        }
        try {
            template = JRXmlTemplateLoader.load(location);
        }
        catch (Exception e2) {
            log.warn("Could not load template from location " + location + "; some styles might remain unresolved.");
            return;
        }
        JRTemplateReference[] includedTemplates = template.getIncludedTemplates();
        if (includedTemplates != null) {
            for (int i2 = 0; i2 < includedTemplates.length; ++i2) {
                JRTemplateReference reference = includedTemplates[i2];
                this.loadTemplateStyles(reference.getLocation(), loadedLocations, parentLocations);
            }
        }
        this.collectStyles(template.getStyles());
    }

    protected void collectStyles(JRStyle[] styles) {
        if (styles != null) {
            for (int i2 = 0; i2 < styles.length; ++i2) {
                JRStyle style2 = styles[i2];
                JRStyle copy = this.styleFactory.getStyle(style2);
                this.stylesMap.put(copy.getName(), copy);
            }
        }
    }

    private void addSection(JRSection section) {
        JRBand[] bands;
        if (section != null && (bands = section.getBands()) != null && bands.length > 0) {
            for (int i2 = 0; i2 < bands.length; ++i2) {
                this.addBand(bands[i2]);
            }
        }
    }

    private void addBand(JRBand band) {
        if (band != null) {
            JRBasePrintFrame frame2 = new JRBasePrintFrame(null);
            frame2.setX(this.report.getLeftMargin());
            frame2.setY(this.offsetY);
            frame2.setWidth(this.report.getPageWidth() - this.report.getLeftMargin() - this.report.getRightMargin());
            frame2.setHeight(band.getHeight());
            band.visit(new ConvertVisitor(this, frame2));
            this.pageElements.add(frame2);
            this.offsetY += band.getHeight();
            this.addBandSeparator(this.offsetY);
        }
    }

    private void addBandSeparator(int bandY) {
        this.addHorizontalGridLine(0, bandY, this.pageWidth);
    }

    private void addColumnSeparator(int colX) {
        if (this.downColumns > this.upColumns) {
            this.addVerticalGridLine(colX, this.upColumns, this.downColumns - this.upColumns);
        }
    }

    private void addHorizontalGridLine(int x, int y, int width) {
        JRBasePrintFrame printFrame = new JRBasePrintFrame(this.getDefaultStyleProvider());
        printFrame.setX(x);
        printFrame.setY(y);
        printFrame.setWidth(width);
        printFrame.setHeight(1);
        printFrame.getLineBox().getPen().setLineWidth(0.0f);
        printFrame.getLineBox().getPen().setLineStyle((byte)0);
        printFrame.getLineBox().getTopPen().setLineWidth(0.1f);
        printFrame.getLineBox().getTopPen().setLineStyle((byte)1);
        printFrame.getLineBox().getTopPen().setLineColor(GRID_LINE_COLOR);
        this.pageElements.add(0, printFrame);
    }

    private void addVerticalGridLine(int x, int y, int height) {
        JRBasePrintFrame printFrame = new JRBasePrintFrame(this.getDefaultStyleProvider());
        printFrame.setX(x);
        printFrame.setY(y);
        printFrame.setWidth(1);
        printFrame.setHeight(height);
        printFrame.getLineBox().getPen().setLineWidth(0.0f);
        printFrame.getLineBox().getPen().setLineStyle((byte)0);
        printFrame.getLineBox().getLeftPen().setLineWidth(0.1f);
        printFrame.getLineBox().getLeftPen().setLineStyle((byte)1);
        printFrame.getLineBox().getLeftPen().setLineColor(GRID_LINE_COLOR);
        this.pageElements.add(0, printFrame);
    }

    protected JRStyle resolveStyle(JRStyleContainer originalContainer) {
        JRStyle style2;
        JRStyle originalStyle = originalContainer.getStyle();
        String nameReference = originalContainer.getStyleNameReference();
        if (originalStyle != null) {
            style2 = this.styleFactory.getStyle(originalStyle);
        } else if (nameReference != null) {
            style2 = (JRStyle)this.stylesMap.get(nameReference);
            if (style2 == null) {
                log.warn("Style " + nameReference + " could not be resolved.");
            }
        } else {
            style2 = null;
        }
        return style2;
    }

    public JRReport getReport() {
        return this.report;
    }

    public JasperPrint getJasperPrint() {
        return this.jasperPrint;
    }

    public JRDefaultStyleProvider getDefaultStyleProvider() {
        return this.jasperPrint.getDefaultStyleProvider();
    }

    public void copyBaseAttributes(JRElement source, JRPrintElement converted) {
        converted.setX(source.getX());
        converted.setY(source.getY());
        converted.setWidth(source.getWidth());
        converted.setHeight(source.getHeight());
        converted.setBackcolor(source.getOwnBackcolor());
        converted.setForecolor(source.getOwnForecolor());
        converted.setMode(source.getOwnMode());
        converted.setStyle(this.resolveStyle(source));
    }

    protected class StyleFactory
    extends JRBaseObjectFactory {
        public StyleFactory() {
            super(ReportConverter.this.getDefaultStyleProvider());
        }

        public JRExpression getExpression(JRExpression expression, boolean assignNotUsedId) {
            return expression;
        }

        public JRStyle getStyle(JRStyle style2) {
            JRBaseStyle baseStyle = null;
            if (!(style2 == null || (baseStyle = (JRBaseStyle)this.get(style2)) != null && ReportConverter.this.cacheStyles)) {
                baseStyle = new JRBaseStyle(style2, this);
                this.put(style2, baseStyle);
            }
            return baseStyle;
        }

        protected void handleStyleNameReference(JRStyleSetter setter, String nameReference) {
            JRStyle style2 = (JRStyle)ReportConverter.this.stylesMap.get(nameReference);
            if (style2 == null) {
                log.warn("Style " + nameReference + " could not be resolved.");
            } else {
                setter.setStyle(style2);
            }
        }
    }
}

