/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.base;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRHyperlink;
import net.sf.jasperreports.engine.JRHyperlinkHelper;
import net.sf.jasperreports.engine.JRHyperlinkParameter;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.base.JRBaseObjectFactory;

public class JRBaseHyperlink
implements JRHyperlink,
Serializable {
    private static final long serialVersionUID = 10200L;
    protected String linkType;
    protected String linkTarget;
    protected JRExpression hyperlinkReferenceExpression;
    protected JRExpression hyperlinkAnchorExpression;
    protected JRExpression hyperlinkPageExpression;
    protected JRExpression hyperlinkTooltipExpression;
    protected JRHyperlinkParameter[] hyperlinkParameters;
    private byte hyperlinkTarget = 1;

    public JRBaseHyperlink() {
    }

    protected JRBaseHyperlink(JRHyperlink link2, JRBaseObjectFactory factory) {
        factory.put(link2, this);
        this.linkType = link2.getLinkType();
        this.linkTarget = link2.getLinkTarget();
        this.hyperlinkReferenceExpression = factory.getExpression(link2.getHyperlinkReferenceExpression());
        this.hyperlinkAnchorExpression = factory.getExpression(link2.getHyperlinkAnchorExpression());
        this.hyperlinkPageExpression = factory.getExpression(link2.getHyperlinkPageExpression());
        this.hyperlinkTooltipExpression = factory.getExpression(link2.getHyperlinkTooltipExpression());
        this.hyperlinkParameters = JRBaseHyperlink.copyHyperlinkParameters(link2, factory);
    }

    public static JRHyperlinkParameter[] copyHyperlinkParameters(JRHyperlink link2, JRBaseObjectFactory factory) {
        JRHyperlinkParameter[] linkParameters = link2.getHyperlinkParameters();
        JRHyperlinkParameter[] parameters = null;
        if (linkParameters != null && linkParameters.length > 0) {
            parameters = new JRHyperlinkParameter[linkParameters.length];
            for (int i2 = 0; i2 < linkParameters.length; ++i2) {
                JRHyperlinkParameter parameter = linkParameters[i2];
                parameters[i2] = factory.getHyperlinkParameter(parameter);
            }
        }
        return parameters;
    }

    public JRExpression getHyperlinkAnchorExpression() {
        return this.hyperlinkAnchorExpression;
    }

    public JRExpression getHyperlinkPageExpression() {
        return this.hyperlinkPageExpression;
    }

    public JRHyperlinkParameter[] getHyperlinkParameters() {
        return this.hyperlinkParameters;
    }

    public JRExpression getHyperlinkReferenceExpression() {
        return this.hyperlinkReferenceExpression;
    }

    public byte getHyperlinkTarget() {
        return JRHyperlinkHelper.getHyperlinkTarget(this);
    }

    public byte getHyperlinkType() {
        return JRHyperlinkHelper.getHyperlinkType(this);
    }

    public String getLinkType() {
        return this.linkType;
    }

    public String getLinkTarget() {
        return this.linkTarget;
    }

    public JRExpression getHyperlinkTooltipExpression() {
        return this.hyperlinkTooltipExpression;
    }

    public Object clone() {
        JRBaseHyperlink clone = null;
        try {
            clone = (JRBaseHyperlink)super.clone();
        }
        catch (CloneNotSupportedException e2) {
            throw new JRRuntimeException(e2);
        }
        if (this.hyperlinkParameters != null) {
            clone.hyperlinkParameters = new JRHyperlinkParameter[this.hyperlinkParameters.length];
            for (int i2 = 0; i2 < this.hyperlinkParameters.length; ++i2) {
                clone.hyperlinkParameters[i2] = (JRHyperlinkParameter)this.hyperlinkParameters[i2].clone();
            }
        }
        if (this.hyperlinkReferenceExpression != null) {
            clone.hyperlinkReferenceExpression = (JRExpression)this.hyperlinkReferenceExpression.clone();
        }
        if (this.hyperlinkAnchorExpression != null) {
            clone.hyperlinkAnchorExpression = (JRExpression)this.hyperlinkAnchorExpression.clone();
        }
        if (this.hyperlinkPageExpression != null) {
            clone.hyperlinkPageExpression = (JRExpression)this.hyperlinkPageExpression.clone();
        }
        if (this.hyperlinkTooltipExpression != null) {
            clone.hyperlinkTooltipExpression = (JRExpression)this.hyperlinkTooltipExpression.clone();
        }
        return clone;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.linkTarget == null) {
            this.linkTarget = JRHyperlinkHelper.getLinkTarget(this.hyperlinkTarget);
        }
        this.hyperlinkTarget = 1;
    }
}

