/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.base;

import java.awt.Color;
import java.io.Serializable;
import net.sf.jasperreports.engine.JRDefaultStyleProvider;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRElementGroup;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JRPropertiesHolder;
import net.sf.jasperreports.engine.JRPropertiesMap;
import net.sf.jasperreports.engine.JRPropertyExpression;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.base.JRBaseObjectFactory;
import net.sf.jasperreports.engine.design.events.JRChangeEventsSupport;
import net.sf.jasperreports.engine.design.events.JRPropertyChangeSupport;
import net.sf.jasperreports.engine.util.JRStyleResolver;

public abstract class JRBaseElement
implements JRElement,
Serializable,
JRChangeEventsSupport {
    private static final long serialVersionUID = 10200L;
    public static final String PROPERTY_POSITION_TYPE = "positionType";
    public static final String PROPERTY_PRINT_IN_FIRST_WHOLE_BAND = "isPrintInFirstWholeBand";
    public static final String PROPERTY_PRINT_REPEATED_VALUES = "isPrintRepeatedValues";
    public static final String PROPERTY_PRINT_WHEN_DETAIL_OVERFLOWS = "isPrintWhenDetailOverflows";
    public static final String PROPERTY_REMOVE_LINE_WHEN_BLANK = "isRemoveLineWhenBlank";
    public static final String PROPERTY_STRETCH_TYPE = "stretchType";
    public static final String PROPERTY_WIDTH = "width";
    public static final String PROPERTY_X = "x";
    protected String key = null;
    protected byte positionType;
    protected byte stretchType;
    protected boolean isPrintRepeatedValues = true;
    protected Byte mode;
    protected int x = 0;
    protected int y = 0;
    protected int width = 0;
    protected int height = 0;
    protected boolean isRemoveLineWhenBlank = false;
    protected boolean isPrintInFirstWholeBand = false;
    protected boolean isPrintWhenDetailOverflows = false;
    protected Color forecolor = null;
    protected Color backcolor = null;
    protected JRExpression printWhenExpression = null;
    protected JRGroup printWhenGroupChanges = null;
    protected JRElementGroup elementGroup = null;
    protected JRDefaultStyleProvider defaultStyleProvider;
    protected JRStyle parentStyle;
    protected String parentStyleNameReference;
    private JRPropertiesMap propertiesMap;
    private JRPropertyExpression[] propertyExpressions;
    private transient JRPropertyChangeSupport eventSupport;

    protected JRBaseElement(JRDefaultStyleProvider defaultStyleProvider) {
        this.defaultStyleProvider = defaultStyleProvider;
    }

    protected JRBaseElement(JRElement element, JRBaseObjectFactory factory) {
        factory.put(element, this);
        this.defaultStyleProvider = factory.getDefaultStyleProvider();
        this.parentStyle = factory.getStyle(element.getStyle());
        this.parentStyleNameReference = element.getStyleNameReference();
        this.key = element.getKey();
        this.positionType = element.getPositionType();
        this.stretchType = element.getStretchType();
        this.isPrintRepeatedValues = element.isPrintRepeatedValues();
        this.mode = element.getOwnMode();
        this.x = element.getX();
        this.y = element.getY();
        this.width = element.getWidth();
        this.height = element.getHeight();
        this.isRemoveLineWhenBlank = element.isRemoveLineWhenBlank();
        this.isPrintInFirstWholeBand = element.isPrintInFirstWholeBand();
        this.isPrintWhenDetailOverflows = element.isPrintWhenDetailOverflows();
        this.forecolor = element.getOwnForecolor();
        this.backcolor = element.getOwnBackcolor();
        this.printWhenExpression = factory.getExpression(element.getPrintWhenExpression());
        this.printWhenGroupChanges = factory.getGroup(element.getPrintWhenGroupChanges());
        this.elementGroup = (JRElementGroup)factory.getVisitResult(element.getElementGroup());
        this.propertiesMap = JRPropertiesMap.getPropertiesClone(element);
        this.copyPropertyExpressions(element, factory);
    }

    private void copyPropertyExpressions(JRElement element, JRBaseObjectFactory factory) {
        JRPropertyExpression[] props = element.getPropertyExpressions();
        if (props != null && props.length > 0) {
            this.propertyExpressions = new JRPropertyExpression[props.length];
            for (int i2 = 0; i2 < props.length; ++i2) {
                this.propertyExpressions[i2] = factory.getPropertyExpression(props[i2]);
            }
        }
    }

    public JRDefaultStyleProvider getDefaultStyleProvider() {
        return this.defaultStyleProvider;
    }

    protected JRStyle getBaseStyle() {
        if (this.parentStyle != null) {
            return this.parentStyle;
        }
        if (this.defaultStyleProvider != null) {
            return this.defaultStyleProvider.getDefaultStyle();
        }
        return null;
    }

    public String getKey() {
        return this.key;
    }

    public byte getPositionType() {
        return this.positionType;
    }

    public void setPositionType(byte positionType) {
        byte old = this.positionType;
        this.positionType = positionType;
        this.getEventSupport().firePropertyChange(PROPERTY_POSITION_TYPE, old, this.positionType);
    }

    public byte getStretchType() {
        return this.stretchType;
    }

    public void setStretchType(byte stretchType) {
        byte old = this.stretchType;
        this.stretchType = stretchType;
        this.getEventSupport().firePropertyChange(PROPERTY_STRETCH_TYPE, old, this.stretchType);
    }

    public boolean isPrintRepeatedValues() {
        return this.isPrintRepeatedValues;
    }

    public void setPrintRepeatedValues(boolean isPrintRepeatedValues) {
        boolean old = this.isPrintRepeatedValues;
        this.isPrintRepeatedValues = isPrintRepeatedValues;
        this.getEventSupport().firePropertyChange(PROPERTY_PRINT_REPEATED_VALUES, old, this.isPrintRepeatedValues);
    }

    public byte getMode() {
        return JRStyleResolver.getMode(this, (byte)1);
    }

    public Byte getOwnMode() {
        return this.mode;
    }

    public void setMode(byte mode) {
        this.setMode(new Byte(mode));
    }

    public void setMode(Byte mode) {
        Byte old = this.mode;
        this.mode = mode;
        this.getEventSupport().firePropertyChange("mode", old, this.mode);
    }

    public int getX() {
        return this.x;
    }

    public void setX(int x) {
        int old = this.x;
        this.x = x;
        this.getEventSupport().firePropertyChange(PROPERTY_X, old, this.x);
    }

    public int getY() {
        return this.y;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        int old = this.width;
        this.width = width;
        this.getEventSupport().firePropertyChange(PROPERTY_WIDTH, old, this.width);
    }

    public int getHeight() {
        return this.height;
    }

    public boolean isRemoveLineWhenBlank() {
        return this.isRemoveLineWhenBlank;
    }

    public void setRemoveLineWhenBlank(boolean isRemoveLine) {
        boolean old = this.isRemoveLineWhenBlank;
        this.isRemoveLineWhenBlank = isRemoveLine;
        this.getEventSupport().firePropertyChange(PROPERTY_REMOVE_LINE_WHEN_BLANK, old, this.isRemoveLineWhenBlank);
    }

    public boolean isPrintInFirstWholeBand() {
        return this.isPrintInFirstWholeBand;
    }

    public void setPrintInFirstWholeBand(boolean isPrint) {
        boolean old = this.isPrintInFirstWholeBand;
        this.isPrintInFirstWholeBand = isPrint;
        this.getEventSupport().firePropertyChange(PROPERTY_PRINT_IN_FIRST_WHOLE_BAND, old, this.isPrintInFirstWholeBand);
    }

    public boolean isPrintWhenDetailOverflows() {
        return this.isPrintWhenDetailOverflows;
    }

    public void setPrintWhenDetailOverflows(boolean isPrint) {
        boolean old = this.isPrintWhenDetailOverflows;
        this.isPrintWhenDetailOverflows = isPrint;
        this.getEventSupport().firePropertyChange(PROPERTY_PRINT_WHEN_DETAIL_OVERFLOWS, old, this.isPrintWhenDetailOverflows);
    }

    public Color getForecolor() {
        return JRStyleResolver.getForecolor(this);
    }

    public Color getOwnForecolor() {
        return this.forecolor;
    }

    public void setForecolor(Color forecolor) {
        Color old = this.forecolor;
        this.forecolor = forecolor;
        this.getEventSupport().firePropertyChange("forecolor", old, this.forecolor);
    }

    public Color getBackcolor() {
        return JRStyleResolver.getBackcolor(this);
    }

    public Color getOwnBackcolor() {
        return this.backcolor;
    }

    public void setBackcolor(Color backcolor) {
        Color old = this.backcolor;
        this.backcolor = backcolor;
        this.getEventSupport().firePropertyChange("backcolor", old, this.backcolor);
    }

    public JRExpression getPrintWhenExpression() {
        return this.printWhenExpression;
    }

    public JRGroup getPrintWhenGroupChanges() {
        return this.printWhenGroupChanges;
    }

    public JRElementGroup getElementGroup() {
        return this.elementGroup;
    }

    public JRStyle getStyle() {
        return this.parentStyle;
    }

    public String getStyleNameReference() {
        return this.parentStyleNameReference;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JRPropertyChangeSupport getEventSupport() {
        JRBaseElement jRBaseElement = this;
        synchronized (jRBaseElement) {
            if (this.eventSupport == null) {
                this.eventSupport = new JRPropertyChangeSupport(this);
            }
        }
        return this.eventSupport;
    }

    public Object clone() {
        JRBaseElement clone = null;
        try {
            clone = (JRBaseElement)super.clone();
        }
        catch (CloneNotSupportedException e2) {
            throw new JRRuntimeException(e2);
        }
        if (this.printWhenExpression != null) {
            clone.printWhenExpression = (JRExpression)this.printWhenExpression.clone();
        }
        return clone;
    }

    public Object clone(JRElementGroup parentGroup) {
        JRBaseElement clone = (JRBaseElement)this.clone();
        clone.elementGroup = parentGroup;
        return clone;
    }

    public boolean hasProperties() {
        return this.propertiesMap != null && this.propertiesMap.hasProperties();
    }

    public JRPropertiesMap getPropertiesMap() {
        if (this.propertiesMap == null) {
            this.propertiesMap = new JRPropertiesMap();
        }
        return this.propertiesMap;
    }

    public JRPropertiesHolder getParentProperties() {
        return null;
    }

    public JRPropertyExpression[] getPropertyExpressions() {
        return this.propertyExpressions;
    }
}

