/*
 * Decompiled with CFR 0.152.
 */
package groovy.lang;

import groovy.lang.Interceptor;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;

public class TracingInterceptor
implements Interceptor {
    protected Writer writer = new PrintWriter(System.out);
    private int indent = 0;

    public Writer getWriter() {
        return this.writer;
    }

    public void setWriter(Writer writer) {
        this.writer = writer;
    }

    public Object beforeInvoke(Object object2, String methodName, Object[] arguments) {
        this.write(object2, methodName, arguments, "before");
        ++this.indent;
        return null;
    }

    public Object afterInvoke(Object object2, String methodName, Object[] arguments, Object result) {
        --this.indent;
        this.write(object2, methodName, arguments, "after ");
        return result;
    }

    public boolean doInvoke() {
        return true;
    }

    private String indent() {
        StringBuffer result = new StringBuffer();
        for (int i2 = 0; i2 < this.indent; ++i2) {
            result.append("  ");
        }
        return result.toString();
    }

    protected void write(Object object2, String methodName, Object[] arguments, String origin) {
        try {
            this.writer.write(this.indent());
            this.writer.write(origin);
            this.writer.write(" ");
            Class<?> theClass = object2 instanceof Class ? (Class<?>)object2 : object2.getClass();
            this.writeInfo(theClass, methodName, arguments);
            this.writer.write("\n");
            this.writer.flush();
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }

    protected void writeInfo(Class aClass, String methodName, Object[] arguments) throws IOException {
        this.writer.write(aClass.getName());
        this.writer.write(".");
        this.writer.write(methodName);
        this.writer.write("(");
        for (int i2 = 0; i2 < arguments.length; ++i2) {
            if (i2 > 0) {
                this.writer.write(", ");
            }
            Object argument = arguments[i2];
            this.writer.write(argument.getClass().getName());
        }
        this.writer.write(")");
    }
}

