/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.pdf.OutputStreamCounter;
import com.lowagie.text.pdf.OutputStreamEncryption;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfEncryption;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNull;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfStream;
import com.lowagie.text.pdf.PdfWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;

public class PdfEFStream
extends PdfStream {
    public PdfEFStream(InputStream inputStream, PdfWriter pdfWriter) {
        super(inputStream, pdfWriter);
    }

    public PdfEFStream(byte[] byArray) {
        super(byArray);
    }

    public void toPdf(PdfWriter pdfWriter, OutputStream outputStream) throws IOException {
        Object object2;
        Object object3;
        PdfObject pdfObject;
        if (this.inputStream != null && this.compressed) {
            this.put(PdfName.FILTER, PdfName.FLATEDECODE);
        }
        PdfEncryption pdfEncryption = null;
        if (pdfWriter != null) {
            pdfEncryption = pdfWriter.getEncryption();
        }
        if (pdfEncryption != null && (pdfObject = this.get(PdfName.FILTER)) != null) {
            if (PdfName.CRYPT.equals(pdfObject)) {
                pdfEncryption = null;
            } else if (pdfObject.isArray() && !((ArrayList)(object3 = ((PdfArray)pdfObject).getArrayList())).isEmpty() && PdfName.CRYPT.equals(((ArrayList)object3).get(0))) {
                pdfEncryption = null;
            }
        }
        if (pdfEncryption != null && pdfEncryption.isEmbeddedFilesOnly()) {
            pdfObject = new PdfArray();
            object3 = new PdfArray();
            object2 = new PdfDictionary();
            ((PdfDictionary)object2).put(PdfName.NAME, PdfName.STDCF);
            ((PdfArray)pdfObject).add(PdfName.CRYPT);
            ((PdfArray)object3).add((PdfObject)object2);
            if (this.compressed) {
                ((PdfArray)pdfObject).add(PdfName.FLATEDECODE);
                ((PdfArray)object3).add(new PdfNull());
            }
            this.put(PdfName.FILTER, pdfObject);
            this.put(PdfName.DECODEPARMS, (PdfObject)object3);
        }
        pdfObject = this.get(PdfName.LENGTH);
        if (pdfEncryption != null && pdfObject != null && pdfObject.isNumber()) {
            int n = ((PdfNumber)pdfObject).intValue();
            this.put(PdfName.LENGTH, new PdfNumber(pdfEncryption.calculateStreamSize(n)));
            this.superToPdf(pdfWriter, outputStream);
            this.put(PdfName.LENGTH, pdfObject);
        } else {
            this.superToPdf(pdfWriter, outputStream);
        }
        outputStream.write(STARTSTREAM);
        if (this.inputStream != null) {
            int n;
            this.rawLength = 0;
            DeflaterOutputStream deflaterOutputStream = null;
            object2 = new OutputStreamCounter(outputStream);
            OutputStreamEncryption outputStreamEncryption = null;
            Object object4 = object2;
            if (pdfEncryption != null) {
                outputStreamEncryption = pdfEncryption.getEncryptionStream((OutputStream)object4);
                object4 = outputStreamEncryption;
            }
            if (this.compressed) {
                deflaterOutputStream = new DeflaterOutputStream((OutputStream)object4, new Deflater(this.compressionLevel), 32768);
                object4 = deflaterOutputStream;
            }
            byte[] byArray = new byte[4192];
            while ((n = this.inputStream.read(byArray)) > 0) {
                ((OutputStream)object4).write(byArray, 0, n);
                this.rawLength += n;
            }
            if (deflaterOutputStream != null) {
                deflaterOutputStream.finish();
            }
            if (outputStreamEncryption != null) {
                outputStreamEncryption.finish();
            }
            this.inputStreamLength = ((OutputStreamCounter)object2).getCounter();
        } else if (pdfEncryption == null) {
            if (this.streamBytes != null) {
                this.streamBytes.writeTo(outputStream);
            } else {
                outputStream.write(this.bytes);
            }
        } else {
            byte[] byArray = this.streamBytes != null ? pdfEncryption.encryptByteArray(this.streamBytes.toByteArray()) : pdfEncryption.encryptByteArray(this.bytes);
            outputStream.write(byArray);
        }
        outputStream.write(ENDSTREAM);
    }
}

