/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.Barcode;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfContentByte;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Image;
import java.awt.image.MemoryImageSource;

public class BarcodeInter25
extends Barcode {
    private static final byte[][] BARS = new byte[][]{{0, 0, 1, 1, 0}, {1, 0, 0, 0, 1}, {0, 1, 0, 0, 1}, {1, 1, 0, 0, 0}, {0, 0, 1, 0, 1}, {1, 0, 1, 0, 0}, {0, 1, 1, 0, 0}, {0, 0, 0, 1, 1}, {1, 0, 0, 1, 0}, {0, 1, 0, 1, 0}};

    public BarcodeInter25() {
        try {
            this.x = 0.8f;
            this.n = 2.0f;
            this.font = BaseFont.createFont("Helvetica", "winansi", false);
            this.baseline = this.size = 8.0f;
            this.barHeight = this.size * 3.0f;
            this.textAlignment = 1;
            this.generateChecksum = false;
            this.checksumText = false;
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
    }

    public static String keepNumbers(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int j = 0; j < string.length(); ++j) {
            char c2 = string.charAt(j);
            if (c2 < '0' || c2 > '9') continue;
            stringBuffer.append(c2);
        }
        return stringBuffer.toString();
    }

    public static char getChecksum(String string) {
        int n = 3;
        int n2 = 0;
        for (int j = string.length() - 1; j >= 0; --j) {
            int n3 = string.charAt(j) - 48;
            n2 += n * n3;
            n ^= 2;
        }
        return (char)((10 - n2 % 10) % 10 + 48);
    }

    public static byte[] getBarsInter25(String string) {
        if (((string = BarcodeInter25.keepNumbers(string)).length() & 1) != 0) {
            throw new IllegalArgumentException("The text length must be even.");
        }
        byte[] byArray = new byte[string.length() * 5 + 7];
        int n = 0;
        byArray[n++] = 0;
        byArray[n++] = 0;
        byArray[n++] = 0;
        byArray[n++] = 0;
        int n2 = string.length() / 2;
        for (int j = 0; j < n2; ++j) {
            int n3 = string.charAt(j * 2) - 48;
            int n4 = string.charAt(j * 2 + 1) - 48;
            byte[] byArray2 = BARS[n3];
            byte[] byArray3 = BARS[n4];
            for (int k = 0; k < 5; ++k) {
                byArray[n++] = byArray2[k];
                byArray[n++] = byArray3[k];
            }
        }
        byArray[n++] = 1;
        byArray[n++] = 0;
        byArray[n++] = 0;
        return byArray;
    }

    public Rectangle getBarcodeSize() {
        String string;
        float f2 = 0.0f;
        float f3 = 0.0f;
        if (this.font != null) {
            f3 = this.baseline > 0.0f ? this.baseline - this.font.getFontDescriptor(3, this.size) : -this.baseline + this.size;
            string = this.code;
            if (this.generateChecksum && this.checksumText) {
                string = string + BarcodeInter25.getChecksum(string);
            }
            f2 = this.font.getWidthPoint(this.altText != null ? this.altText : string, this.size);
        }
        string = BarcodeInter25.keepNumbers(this.code);
        int n = string.length();
        if (this.generateChecksum) {
            ++n;
        }
        float f4 = (float)n * (3.0f * this.x + 2.0f * this.x * this.n) + (6.0f + this.n) * this.x;
        f4 = Math.max(f4, f2);
        float f5 = this.barHeight + f3;
        return new Rectangle(f4, f5);
    }

    public Rectangle placeBarcode(PdfContentByte pdfContentByte, Color color, Color color2) {
        String string = this.code;
        float f2 = 0.0f;
        if (this.font != null) {
            if (this.generateChecksum && this.checksumText) {
                string = string + BarcodeInter25.getChecksum(string);
            }
            string = this.altText != null ? this.altText : string;
            f2 = this.font.getWidthPoint(string, this.size);
        }
        String string2 = BarcodeInter25.keepNumbers(this.code);
        if (this.generateChecksum) {
            string2 = string2 + BarcodeInter25.getChecksum(string2);
        }
        int n = string2.length();
        float f3 = (float)n * (3.0f * this.x + 2.0f * this.x * this.n) + (6.0f + this.n) * this.x;
        float f4 = 0.0f;
        float f5 = 0.0f;
        switch (this.textAlignment) {
            case 0: {
                break;
            }
            case 2: {
                if (f2 > f3) {
                    f4 = f2 - f3;
                    break;
                }
                f5 = f3 - f2;
                break;
            }
            default: {
                if (f2 > f3) {
                    f4 = (f2 - f3) / 2.0f;
                    break;
                }
                f5 = (f3 - f2) / 2.0f;
            }
        }
        float f6 = 0.0f;
        float f7 = 0.0f;
        if (this.font != null) {
            if (this.baseline <= 0.0f) {
                f7 = this.barHeight - this.baseline;
            } else {
                f7 = -this.font.getFontDescriptor(3, this.size);
                f6 = f7 + this.baseline;
            }
        }
        byte[] byArray = BarcodeInter25.getBarsInter25(string2);
        boolean bl = true;
        if (color != null) {
            pdfContentByte.setColorFill(color);
        }
        for (int j = 0; j < byArray.length; ++j) {
            float f8;
            float f9 = f8 = byArray[j] == 0 ? this.x : this.x * this.n;
            if (bl) {
                pdfContentByte.rectangle(f4, f6, f8 - this.inkSpreading, this.barHeight);
            }
            bl = !bl;
            f4 += f8;
        }
        pdfContentByte.fill();
        if (this.font != null) {
            if (color2 != null) {
                pdfContentByte.setColorFill(color2);
            }
            pdfContentByte.beginText();
            pdfContentByte.setFontAndSize(this.font, this.size);
            pdfContentByte.setTextMatrix(f5, f7);
            pdfContentByte.showText(string);
            pdfContentByte.endText();
        }
        return this.getBarcodeSize();
    }

    public Image createAwtImage(Color color, Color color2) {
        int n;
        int n2 = color.getRGB();
        int n3 = color2.getRGB();
        Canvas canvas = new Canvas();
        String string = BarcodeInter25.keepNumbers(this.code);
        if (this.generateChecksum) {
            string = string + BarcodeInter25.getChecksum(string);
        }
        int n4 = string.length();
        int n5 = (int)this.n;
        int n6 = n4 * (3 + 2 * n5) + (6 + n5);
        byte[] byArray = BarcodeInter25.getBarsInter25(string);
        boolean bl = true;
        int n7 = 0;
        int n8 = (int)this.barHeight;
        int[] nArray = new int[n6 * n8];
        for (n = 0; n < byArray.length; ++n) {
            int n9 = byArray[n] == 0 ? 1 : n5;
            int n10 = n3;
            if (bl) {
                n10 = n2;
            }
            bl = !bl;
            for (int j = 0; j < n9; ++j) {
                nArray[n7++] = n10;
            }
        }
        for (n = n6; n < nArray.length; n += n6) {
            System.arraycopy(nArray, 0, nArray, n, n6);
        }
        Image image = canvas.createImage(new MemoryImageSource(n6, n8, nArray, 0, n6));
        return image;
    }
}

