/*
 * Decompiled with CFR 0.152.
 */
package com.d_project.qrcode.web;

import com.d_project.qrcode.GIFImage;
import com.d_project.qrcode.QRCode;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import javax.imageio.ImageIO;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public final class QRCodeServlet
extends HttpServlet {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        request.setCharacterEncoding("ISO-8859-1");
        String output = QRCodeServlet.getParameter(request, "o", "image/gif");
        String encoding = QRCodeServlet.getParameter(request, "c", "SJIS");
        int typeNumber = QRCodeServlet.getIntParameter(request, "t", 0);
        if (typeNumber < 0 || 10 < typeNumber) {
            throw new IllegalArgumentException("illegal type number : " + typeNumber);
        }
        int margin = QRCodeServlet.getIntParameter(request, "m", 2);
        if (margin < 0 || 32 < margin) {
            throw new IllegalArgumentException("illegal margin : " + margin);
        }
        int cellSize = QRCodeServlet.getIntParameter(request, "s", 1);
        if (cellSize < 1 || 4 < cellSize) {
            throw new IllegalArgumentException("illegal cell size : " + cellSize);
        }
        String data = QRCodeServlet.getParameter(request, "d", "qrcode");
        data = new String(data.getBytes("ISO-8859-1"), encoding);
        int errorCorrectLevel = QRCodeServlet.parseErrorCorrectLevel(QRCodeServlet.getParameter(request, "e", "H"));
        QRCode qrCode = QRCodeServlet.getQRCode(data, typeNumber, errorCorrectLevel);
        if ("text/plain".equals(output)) {
            response.setContentType("text/plain");
            PrintWriter out = new PrintWriter(new OutputStreamWriter((OutputStream)response.getOutputStream(), "ISO-8859-1"));
            try {
                for (int row = 0; row < qrCode.getModuleCount(); ++row) {
                    for (int col2 = 0; col2 < qrCode.getModuleCount(); ++col2) {
                        out.print(qrCode.isDark(row, col2) ? "1" : "0");
                    }
                    out.print("\r\n");
                }
            }
            finally {
                out.close();
            }
        } else if ("image/jpeg".equals(output)) {
            BufferedImage image = qrCode.createImage(cellSize, margin);
            response.setContentType("image/jpeg");
            BufferedOutputStream out = new BufferedOutputStream((OutputStream)response.getOutputStream());
            try {
                ImageIO.write((RenderedImage)image, "jpeg", out);
            }
            finally {
                ((OutputStream)out).close();
            }
        } else if ("image/png".equals(output)) {
            BufferedImage image = qrCode.createImage(cellSize, margin);
            response.setContentType("image/png");
            BufferedOutputStream out = new BufferedOutputStream((OutputStream)response.getOutputStream());
            try {
                ImageIO.write((RenderedImage)image, "png", out);
            }
            finally {
                ((OutputStream)out).close();
            }
        } else if ("image/gif".equals(output)) {
            GIFImage image = qrCode.createGIFImage(cellSize, margin);
            response.setContentType("image/gif");
            BufferedOutputStream out = new BufferedOutputStream((OutputStream)response.getOutputStream());
            try {
                image.write(out);
            }
            finally {
                ((OutputStream)out).close();
            }
        } else {
            throw new IllegalArgumentException("illegal output type : " + output);
        }
    }

    private static String getParameter(HttpServletRequest request, String name, String defaultValue) {
        String value = request.getParameter(name);
        return value != null ? value : defaultValue;
    }

    private static int getIntParameter(HttpServletRequest request, String name, int defaultValue) {
        String value = request.getParameter(name);
        return value != null ? Integer.parseInt(value) : defaultValue;
    }

    private static QRCode getQRCode(String text, int typeNumber, int errorCorrectLevel) {
        if (typeNumber == 0) {
            return QRCode.getMinimumQRCode(text, errorCorrectLevel);
        }
        QRCode qr = new QRCode();
        qr.setTypeNumber(typeNumber);
        qr.setErrorCorrectLevel(errorCorrectLevel);
        qr.addData(text);
        qr.make();
        return qr;
    }

    private static int parseErrorCorrectLevel(String ecl) {
        if ("L".equals(ecl)) {
            return 1;
        }
        if ("Q".equals(ecl)) {
            return 3;
        }
        if ("M".equals(ecl)) {
            return 0;
        }
        if ("H".equals(ecl)) {
            return 2;
        }
        throw new IllegalArgumentException("invalid error correct level : " + ecl);
    }
}

