/*
 * Decompiled with CFR 0.152.
 */
package com.d_project.qrcode;

import com.d_project.qrcode.Polynomial;
import com.d_project.qrcode.QRCode;
import com.d_project.qrcode.QRMath;
import java.io.UnsupportedEncodingException;

class QRUtil {
    private static final int[][] PATTERN_POSITION_TABLE = new int[][]{new int[0], {6, 18}, {6, 22}, {6, 26}, {6, 30}, {6, 34}, {6, 22, 38}, {6, 24, 42}, {6, 26, 46}, {6, 28, 50}, {6, 30, 54}, {6, 32, 58}, {6, 34, 62}, {6, 26, 46, 66}, {6, 26, 48, 70}, {6, 26, 50, 74}, {6, 30, 54, 78}, {6, 30, 56, 82}, {6, 30, 58, 86}, {6, 34, 62, 90}, {6, 28, 50, 72, 94}, {6, 26, 50, 74, 98}, {6, 30, 54, 78, 102}, {6, 28, 54, 80, 106}, {6, 32, 58, 84, 110}, {6, 30, 58, 86, 114}, {6, 34, 62, 90, 118}, {6, 26, 50, 74, 98, 122}, {6, 30, 54, 78, 102, 126}, {6, 26, 52, 78, 104, 130}, {6, 30, 56, 82, 108, 134}, {6, 34, 60, 86, 112, 138}, {6, 30, 58, 86, 114, 142}, {6, 34, 62, 90, 118, 146}, {6, 30, 54, 78, 102, 126, 150}, {6, 24, 50, 76, 102, 128, 154}, {6, 28, 54, 80, 106, 132, 158}, {6, 32, 58, 84, 110, 136, 162}, {6, 26, 54, 82, 110, 138, 166}, {6, 30, 58, 86, 114, 142, 170}};
    private static int[][][] MAX_LENGTH = new int[][][]{new int[][]{{41, 25, 17, 10}, {34, 20, 14, 8}, {27, 16, 11, 7}, {17, 10, 7, 4}}, new int[][]{{77, 47, 32, 20}, {63, 38, 26, 16}, {48, 29, 20, 12}, {34, 20, 14, 8}}, new int[][]{{127, 77, 53, 32}, {101, 61, 42, 26}, {77, 47, 32, 20}, {58, 35, 24, 15}}, new int[][]{{187, 114, 78, 48}, {149, 90, 62, 38}, {111, 67, 46, 28}, {82, 50, 34, 21}}, new int[][]{{255, 154, 106, 65}, {202, 122, 84, 52}, {144, 87, 60, 37}, {106, 64, 44, 27}}, new int[][]{{322, 195, 134, 82}, {255, 154, 106, 65}, {178, 108, 74, 45}, {139, 84, 58, 36}}, new int[][]{{370, 224, 154, 95}, {293, 178, 122, 75}, {207, 125, 86, 53}, {154, 93, 64, 39}}, new int[][]{{461, 279, 192, 118}, {365, 221, 152, 93}, {259, 157, 108, 66}, {202, 122, 84, 52}}, new int[][]{{552, 335, 230, 141}, {432, 262, 180, 111}, {312, 189, 130, 80}, {235, 143, 98, 60}}, new int[][]{{652, 395, 271, 167}, {513, 311, 213, 131}, {364, 221, 151, 93}, {288, 174, 119, 74}}};
    private static final int G15 = 1335;
    private static final int G18 = 7973;
    private static final int G15_MASK = 21522;

    private QRUtil() {
    }

    public static String getJISEncoding() {
        return "SJIS";
    }

    public static int[] getPatternPosition(int typeNumber) {
        return PATTERN_POSITION_TABLE[typeNumber - 1];
    }

    public static int getMaxLength(int typeNumber, int mode, int errorCorrectLevel) {
        int t = typeNumber - 1;
        int e2 = 0;
        int m = 0;
        switch (errorCorrectLevel) {
            case 1: {
                e2 = 0;
                break;
            }
            case 0: {
                e2 = 1;
                break;
            }
            case 3: {
                e2 = 2;
                break;
            }
            case 2: {
                e2 = 3;
                break;
            }
            default: {
                throw new IllegalArgumentException("e:" + errorCorrectLevel);
            }
        }
        switch (mode) {
            case 1: {
                m = 0;
                break;
            }
            case 2: {
                m = 1;
                break;
            }
            case 4: {
                m = 2;
                break;
            }
            case 8: {
                m = 3;
                break;
            }
            default: {
                throw new IllegalArgumentException("m:" + mode);
            }
        }
        return MAX_LENGTH[t][e2][m];
    }

    public static Polynomial getErrorCorrectPolynomial(int errorCorrectLength) {
        Polynomial a2 = new Polynomial(new int[]{1});
        for (int i2 = 0; i2 < errorCorrectLength; ++i2) {
            a2 = a2.multiply(new Polynomial(new int[]{1, QRMath.gexp(i2)}));
        }
        return a2;
    }

    public static boolean getMask(int maskPattern, int i2, int j) {
        switch (maskPattern) {
            case 0: {
                return (i2 + j) % 2 == 0;
            }
            case 1: {
                return i2 % 2 == 0;
            }
            case 2: {
                return j % 3 == 0;
            }
            case 3: {
                return (i2 + j) % 3 == 0;
            }
            case 4: {
                return (i2 / 2 + j / 3) % 2 == 0;
            }
            case 5: {
                return i2 * j % 2 + i2 * j % 3 == 0;
            }
            case 6: {
                return (i2 * j % 2 + i2 * j % 3) % 2 == 0;
            }
            case 7: {
                return (i2 * j % 3 + (i2 + j) % 2) % 2 == 0;
            }
        }
        throw new IllegalArgumentException("mask:" + maskPattern);
    }

    public static int getLostPoint(QRCode qrCode) {
        int col2;
        int row;
        int moduleCount = qrCode.getModuleCount();
        int lostPoint = 0;
        for (row = 0; row < moduleCount; ++row) {
            for (col2 = 0; col2 < moduleCount; ++col2) {
                int sameCount = 0;
                boolean dark = qrCode.isDark(row, col2);
                for (int r = -1; r <= 1; ++r) {
                    if (row + r < 0 || moduleCount <= row + r) continue;
                    for (int c2 = -1; c2 <= 1; ++c2) {
                        if (col2 + c2 < 0 || moduleCount <= col2 + c2 || r == 0 && c2 == 0 || dark != qrCode.isDark(row + r, col2 + c2)) continue;
                        ++sameCount;
                    }
                }
                if (sameCount <= 5) continue;
                lostPoint += 3 + sameCount - 5;
            }
        }
        for (row = 0; row < moduleCount - 1; ++row) {
            for (col2 = 0; col2 < moduleCount - 1; ++col2) {
                int count = 0;
                if (qrCode.isDark(row, col2)) {
                    ++count;
                }
                if (qrCode.isDark(row + 1, col2)) {
                    ++count;
                }
                if (qrCode.isDark(row, col2 + 1)) {
                    ++count;
                }
                if (qrCode.isDark(row + 1, col2 + 1)) {
                    ++count;
                }
                if (count != 0 && count != 4) continue;
                lostPoint += 3;
            }
        }
        for (row = 0; row < moduleCount; ++row) {
            for (col2 = 0; col2 < moduleCount - 6; ++col2) {
                if (!qrCode.isDark(row, col2) || qrCode.isDark(row, col2 + 1) || !qrCode.isDark(row, col2 + 2) || !qrCode.isDark(row, col2 + 3) || !qrCode.isDark(row, col2 + 4) || qrCode.isDark(row, col2 + 5) || !qrCode.isDark(row, col2 + 6)) continue;
                lostPoint += 40;
            }
        }
        for (int col3 = 0; col3 < moduleCount; ++col3) {
            for (int row2 = 0; row2 < moduleCount - 6; ++row2) {
                if (!qrCode.isDark(row2, col3) || qrCode.isDark(row2 + 1, col3) || !qrCode.isDark(row2 + 2, col3) || !qrCode.isDark(row2 + 3, col3) || !qrCode.isDark(row2 + 4, col3) || qrCode.isDark(row2 + 5, col3) || !qrCode.isDark(row2 + 6, col3)) continue;
                lostPoint += 40;
            }
        }
        int darkCount = 0;
        for (col2 = 0; col2 < moduleCount; ++col2) {
            for (int row3 = 0; row3 < moduleCount; ++row3) {
                if (!qrCode.isDark(row3, col2)) continue;
                ++darkCount;
            }
        }
        int ratio = Math.abs(100 * darkCount / moduleCount / moduleCount - 50) / 5;
        return lostPoint += ratio * 10;
    }

    public static int getMode(String s2) {
        if (QRUtil.isAlphaNum(s2)) {
            if (QRUtil.isNumber(s2)) {
                return 1;
            }
            return 2;
        }
        if (QRUtil.isKanji(s2)) {
            return 8;
        }
        return 4;
    }

    private static boolean isNumber(String s2) {
        for (int i2 = 0; i2 < s2.length(); ++i2) {
            char c2 = s2.charAt(i2);
            if ('0' <= c2 && c2 <= '9') continue;
            return false;
        }
        return true;
    }

    private static boolean isAlphaNum(String s2) {
        for (int i2 = 0; i2 < s2.length(); ++i2) {
            char c2 = s2.charAt(i2);
            if ('0' <= c2 && c2 <= '9' || 'A' <= c2 && c2 <= 'Z' || " $%*+-./:".indexOf(c2) != -1) continue;
            return false;
        }
        return true;
    }

    private static boolean isKanji(String s2) {
        try {
            byte[] data = s2.getBytes(QRUtil.getJISEncoding());
            int i2 = 0;
            while (i2 + 1 < data.length) {
                int c2 = (0xFF & data[i2]) << 8 | 0xFF & data[i2 + 1];
                if (!(33088 <= c2 && c2 <= 40956 || 57408 <= c2 && c2 <= 60351)) {
                    return false;
                }
                i2 += 2;
            }
            return i2 >= data.length;
        }
        catch (UnsupportedEncodingException e2) {
            throw new Error(e2.getMessage());
        }
    }

    public static int getBCHTypeInfo(int data) {
        int d2 = data << 10;
        while (QRUtil.getBCHDigit(d2) - QRUtil.getBCHDigit(1335) >= 0) {
            d2 ^= 1335 << QRUtil.getBCHDigit(d2) - QRUtil.getBCHDigit(1335);
        }
        return (data << 10 | d2) ^ 0x5412;
    }

    public static int getBCHTypeNumber(int data) {
        int d2 = data << 12;
        while (QRUtil.getBCHDigit(d2) - QRUtil.getBCHDigit(7973) >= 0) {
            d2 ^= 7973 << QRUtil.getBCHDigit(d2) - QRUtil.getBCHDigit(7973);
        }
        return data << 12 | d2;
    }

    private static int getBCHDigit(int data) {
        int digit = 0;
        while (data != 0) {
            ++digit;
            data >>>= 1;
        }
        return digit;
    }
}

