
   /*$RCSfile: validateTime.js,v $ $Revision: 1.1 $ $Date: 2008/09/30 12:26:08 $ */
    /**
    * Check to see if fields are a valid date.
    * Fields are not checked if they are disabled.
    * <p>
    * @param form The form validation is taking place on.
    */
    function validateTime(form) {
       var bValid = true;
       var focusField = null;
       var i = 0;
       var fields = new Array();
       var formName = form.getAttributeNode("name"); 

       oTime = eval('new ' + formName.value + '_TimeValidations()');

       for (x in oTime) {
           var field = form[oTime[x][0]];
           var value = field.value;
           var timePattern = oTime[x][2]("timePatternStrict");
           // try loose pattern
           if (timePattern == null)
               timePattern = oTime[x][2]("timePattern");
           if ((field.type == 'hidden' ||
                field.type == 'text' ||
                field.type == 'textarea') &&
               (value.length > 0) && (timePattern.length > 0) &&
                field.disabled == false) {
                 var HOUR = "HH";
                 var MINUTE = "mm";
                 var SECOND = "ss";
                 var orderHour = timePattern.indexOf(HOUR);
                 var orderMinute = timePattern.indexOf(MINUTE);
                 var orderSecond = timePattern.indexOf(SECOND);

                 if( orderHour < orderMinute && orderMinute < orderSecond ) {
	                 
	                 var iDelim1 = orderHour + HOUR.length;
	                 var iDelim2 = orderMinute + MINUTE.length;
	                 
	                 var delim1 = timePattern.substring(iDelim1, iDelim1 + 1);
	                 var delim2 = timePattern.substring(iDelim2, iDelim2 + 1);
	
	                 if (iDelim1 == orderMinute && iDelim2 == orderSecond) {
	                    dateRegexp = new RegExp("^(\\d{2})(\\d{2})(\\d{2})$");
	                 } else if (iDelim1 == orderMinute) {
	                    dateRegexp = new RegExp("^(\\d{2})(\\d{2})[" + delim2 + "](\\d{2})$");
	                 } else if (iDelim2 == orderSecond) {
	                    dateRegexp = new RegExp("^(\\d{2})[" + delim1 + "](\\d{2})(\\d{2})$");
	                 } else {
	                    dateRegexp = new RegExp("^(\\d{2})[" + delim1 + "](\\d{2})[" + delim2 + "](\\d{4})$");
	                 }
	                 var matched = dateRegexp.exec(value);
	                 if(matched != null) {
	                    if (!isValidTime(matched[1], matched[2], matched[3])) {
	                       if (i == 0) {
	                           focusField = field;
	                       }
	                       fields[i++] = oTime[x][1];
	                       bValid =  false;
	                    }
	                 } else {
	                    if (i == 0) {
	                        focusField = field;
	                    }
	                    fields[i++] = oTime[x][1];
	                    bValid =  false;
	                 }
	                 
	             }
                 
          }
          
       }
       if (fields.length > 0) {
          focusField.focus();
          alert(fields.join('\n'));
       }
       return bValid;
    }
    
    function isValidTime(hour, minute, second) {
	    if (hour < 0 || month > 23) {
            return false;
        }
        if (minute < 0 || minute > 59) {
            return false;
        }
        if (second < 0 || second > 59) {
            return false;
        }
        return true;
    }
    
    