/*
 * Decompiled with CFR 0.152.
 */
package org.ajaxtags.helpers;

import au.id.jericho.lib.html.Attribute;
import au.id.jericho.lib.html.Attributes;
import au.id.jericho.lib.html.AttributesOutputSegment;
import au.id.jericho.lib.html.Element;
import au.id.jericho.lib.html.IOutputSegment;
import au.id.jericho.lib.html.OutputDocument;
import au.id.jericho.lib.html.Source;
import au.id.jericho.lib.html.StartTag;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class AjaxHtmlHelper {
    public static String getTagContent(String html, String tag) {
        if (StringUtils.isBlank((String)html)) {
            return null;
        }
        Source source = new Source((CharSequence)html);
        return source.findNextStartTag(1, tag).getElement().getContentText();
    }

    public static String getTagContent(String html, String tag, String className) {
        if (StringUtils.isBlank((String)html)) {
            return null;
        }
        Source source = new Source((CharSequence)html);
        List spans = source.findAllElements(tag);
        Iterator spanIter = spans.iterator();
        while (spanIter.hasNext()) {
            Element spanElement = (Element)spanIter.next();
            if (StringUtils.isBlank((String)className)) {
                return spanElement.getContentText();
            }
            Attributes spanAttributes = spanElement.getAttributes();
            Attribute classAttribute = spanAttributes.get("class");
            if (classAttribute == null || classAttribute.getValue() == null || !classAttribute.getValue().equalsIgnoreCase(className)) continue;
            return spanElement.getContentText();
        }
        return null;
    }

    public static String getTagContentById(String html, String id) {
        if (StringUtils.isBlank((String)html)) {
            return null;
        }
        Source source = new Source((CharSequence)html);
        List spans = source.findAllElements();
        Iterator spanIter = spans.iterator();
        while (spanIter.hasNext()) {
            Element spanElement = (Element)spanIter.next();
            Attributes spanAttributes = spanElement.getAttributes();
            Attribute classAttribute = spanAttributes.get("id");
            if (classAttribute == null || classAttribute.getValue() == null || !classAttribute.getValue().equalsIgnoreCase(id)) continue;
            return spanElement.getContentText();
        }
        return null;
    }

    public static String ajaxAnchors(String html, String target) {
        return AjaxHtmlHelper.ajaxAnchors(html, target, null);
    }

    public static String ajaxAnchors(String html, String target, String ajaxFlag) {
        if (StringUtils.isBlank((String)html)) {
            return null;
        }
        OutputDocument outputDocument = new OutputDocument((CharSequence)html);
        Source source = new Source((CharSequence)html);
        List anchors = source.findAllStartTags("a");
        Iterator i = anchors.iterator();
        while (i.hasNext()) {
            String href;
            StartTag anchorTag = (StartTag)i.next();
            Attributes attributes = anchorTag.getAttributes();
            Attribute hrefAttribute = attributes.get("href");
            if (hrefAttribute == null || (href = hrefAttribute.getValue()) == null) continue;
            AttributesOutputSegment outputSegment = new AttributesOutputSegment(attributes, true);
            outputSegment.getMap().put("href", "javascript://nop/");
            outputSegment.getMap().put("onclick", AjaxHtmlHelper.getOnclickAjax(target, href, ajaxFlag));
            outputDocument.add((IOutputSegment)outputSegment);
        }
        return outputDocument.toString();
    }

    public static final String getOnclickAjax(String target, String href, String ajaxFlag) {
        StringBuffer onclick = new StringBuffer("new Ajax.Updater('");
        onclick.append(target);
        onclick.append("', '");
        onclick.append(href);
        if (StringUtils.isNotBlank((String)ajaxFlag) && href.indexOf(ajaxFlag + "=") < 0) {
            if (href.indexOf("?") >= 0) {
                onclick.append("&");
            } else {
                onclick.append("?");
            }
            onclick.append(ajaxFlag);
            onclick.append("=true");
        }
        onclick.append("'); return false;");
        return onclick.toString();
    }
}

