/*
 * Decompiled with CFR 0.152.
 */
package com.edb.copy;

import com.edb.core.BaseConnection;
import com.edb.core.Encoding;
import com.edb.core.PGStream;
import com.edb.util.PSQLException;
import com.edb.util.PSQLState;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.SQLException;

public class CopyManager {
    private BaseConnection pgConn;
    private PGStream pgStream;

    public CopyManager(BaseConnection pgConn, PGStream pgStream) {
        this.pgConn = pgConn;
        this.pgStream = pgStream;
    }

    public void copyIn(String table, InputStream is) throws SQLException {
        this.copyInQuery("COPY " + table + " FROM STDIN", is);
    }

    public void copyIn(String table, InputStream is, char copyDelimiter) throws SQLException {
        this.copyInQuery("COPY " + table + " FROM STDIN WITH DELIMITER AS '" + copyDelimiter + "'", is);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyInQuery(String query, InputStream is) throws SQLException {
        PGStream pGStream = this.pgStream;
        synchronized (pGStream) {
            this.sendQuery(query);
            this.copyResultLoop(is, null);
        }
    }

    public void copyOut(String table, OutputStream os) throws SQLException {
        this.copyOutQuery("COPY " + table + " TO STDOUT", os);
    }

    public void copyOut(String table, OutputStream os, char copyDelimiter) throws SQLException {
        this.copyOutQuery("COPY " + table + " TO STDOUT WITH DELIMITER AS '" + copyDelimiter + "'", os);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyOutQuery(String query, OutputStream os) throws SQLException {
        PGStream pGStream = this.pgStream;
        synchronized (pGStream) {
            this.sendQuery(query);
            this.copyResultLoop(null, os);
        }
    }

    private void copyResultLoop(InputStream is, OutputStream os) throws SQLException {
        Encoding encoding = this.pgConn.getEncoding();
        PSQLException topLevelError = null;
        boolean queryDone = false;
        block13: while (!queryDone) {
            try {
                int c = this.pgStream.ReceiveChar();
                switch (c) {
                    case 65: {
                        int pid = this.pgStream.ReceiveIntegerR(4);
                        String msg = this.pgStream.ReceiveString();
                        continue block13;
                    }
                    case 67: {
                        int commandLength = this.pgStream.ReceiveIntegerR(4);
                        String command = encoding.decode(this.pgStream.Receive(commandLength - 4 - 1));
                        this.pgStream.Receive(1);
                        continue block13;
                    }
                    case 69: {
                        int errorLength = this.pgStream.ReceiveIntegerR(4);
                        String errorMessage = encoding.decode(this.pgStream.Receive(errorLength - 4));
                        PSQLException error = new PSQLException(errorMessage);
                        if (topLevelError != null) {
                            topLevelError.setNextException(error);
                            continue block13;
                        }
                        topLevelError = error;
                        continue block13;
                    }
                    case 78: {
                        int notificationLength = this.pgStream.ReceiveIntegerR(4);
                        String notificationMessage = encoding.decode(this.pgStream.Receive(notificationLength - 4));
                        continue block13;
                    }
                    case 71: {
                        if (is == null) {
                            throw new PSQLException("edb.copy.type", PSQLState.COMMUNICATION_ERROR);
                        }
                        this.receiveCopyInOutResponse();
                        this.sendCopyData(is);
                        continue block13;
                    }
                    case 72: {
                        if (os == null) {
                            throw new PSQLException("edb.copy.type", PSQLState.COMMUNICATION_ERROR);
                        }
                        this.receiveCopyInOutResponse();
                        continue block13;
                    }
                    case 100: {
                        if (os == null) {
                            throw new PSQLException("edb.copy.type", PSQLState.COMMUNICATION_ERROR);
                        }
                        this.receiveCopyData(os);
                        continue block13;
                    }
                    case 99: {
                        int copyDoneLength = this.pgStream.ReceiveIntegerR(4);
                        continue block13;
                    }
                    case 90: {
                        int messageLength = this.pgStream.ReceiveIntegerR(4);
                        char messageStatus = (char)this.pgStream.ReceiveChar();
                        queryDone = true;
                        continue block13;
                    }
                }
                throw new PSQLException("edb.copy.type", PSQLState.COMMUNICATION_ERROR);
            }
            catch (IOException ioe) {
                throw new PSQLException("edb.copy.ioerror: " + ioe.getMessage(), PSQLState.CONNECTION_FAILURE_DURING_TRANSACTION);
            }
        }
        if (topLevelError != null) {
            throw topLevelError;
        }
    }

    private void sendQuery(String query) throws SQLException {
        Encoding encoding = this.pgConn.getEncoding();
        try {
            this.pgStream.SendChar(81);
            byte[] message = encoding.encode(query);
            int messageSize = 4 + message.length + 1;
            this.pgStream.SendInteger4(messageSize);
            this.pgStream.Send(message);
            this.pgStream.SendChar(0);
            this.pgStream.flush();
        }
        catch (IOException ioe) {
            throw new PSQLException("edb.copy.ioerror: " + ioe.getMessage(), PSQLState.CONNECTION_FAILURE_DURING_TRANSACTION, (Throwable)ioe);
        }
    }

    private void sendCopyData(InputStream is) throws SQLException {
        byte[] buf = new byte[8192];
        int read = 0;
        while (read >= 0) {
            try {
                read = is.read(buf);
            }
            catch (IOException ioe) {
                throw new PSQLException("edb.copy.inputsource", PSQLState.DATA_ERROR, (Throwable)ioe);
            }
            if (read <= 0) continue;
            try {
                this.pgStream.SendChar(100);
                int messageSize = read + 4;
                this.pgStream.SendInteger4(messageSize);
                this.pgStream.Send(buf, read);
            }
            catch (IOException ioe) {
                throw new PSQLException("edb.copy.ioerror: " + ioe.getMessage(), PSQLState.CONNECTION_FAILURE_DURING_TRANSACTION, (Throwable)ioe);
            }
        }
        try {
            this.pgStream.SendChar(99);
            this.pgStream.SendInteger4(4);
            this.pgStream.flush();
        }
        catch (IOException ioe) {
            throw new PSQLException("edb.copy.ioerror: " + ioe.getMessage(), PSQLState.CONNECTION_FAILURE_DURING_TRANSACTION, (Throwable)ioe);
        }
    }

    private void receiveCopyInOutResponse() throws SQLException {
        try {
            int messageLength = this.pgStream.ReceiveIntegerR(4);
            int copyFormat = this.pgStream.ReceiveIntegerR(1);
            int numColumns = this.pgStream.ReceiveIntegerR(2);
            for (int i = 0; i < numColumns; ++i) {
                int copyColumnFormat = this.pgStream.ReceiveIntegerR(2);
            }
        }
        catch (IOException ioe) {
            throw new PSQLException("edb.copy.ioerror: " + ioe.getMessage(), PSQLState.CONNECTION_FAILURE_DURING_TRANSACTION, (Throwable)ioe);
        }
    }

    private void receiveCopyData(OutputStream os) throws SQLException {
        try {
            int messageLength = this.pgStream.ReceiveIntegerR(4);
            byte[] data = this.pgStream.Receive(messageLength - 4);
            os.write(data);
        }
        catch (IOException ioe) {
            throw new PSQLException("edb.copy.ioerror: " + ioe.getMessage(), PSQLState.DATA_ERROR, (Throwable)ioe);
        }
    }
}

