/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.rowset;

import java.io.BufferedReader;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringBufferInputStream;
import java.io.Writer;
import java.sql.Clob;
import java.sql.SQLException;
import oracle.jdbc.driver.DatabaseError;

public class OracleSerialClob
implements Clob,
Serializable,
Cloneable {
    private char[] buffer;
    private long length;

    public OracleSerialClob(Clob clob) throws SQLException {
        this.length = clob.length();
        this.buffer = new char[(int)this.length];
        BufferedReader bufferedReader = new BufferedReader(clob.getCharacterStream());
        try {
            int n2 = 0;
            int n3 = 0;
            do {
                n2 = bufferedReader.read(this.buffer, n3, (int)(this.length - (long)n3));
                n3 += n2;
            } while (n2 > 0);
        }
        catch (IOException iOException) {
            throw new SQLException("SerialClob: " + iOException.getMessage());
        }
    }

    public InputStream getAsciiStream() throws SQLException {
        return new StringBufferInputStream(new String(this.buffer));
    }

    public Reader getCharacterStream() throws SQLException {
        return new CharArrayReader(this.buffer);
    }

    public String getSubString(long l2, int n2) throws SQLException {
        if (l2 < 0L || (long)n2 > this.length || l2 + (long)n2 > this.length) {
            throw new SQLException("Invalid Arguments");
        }
        return new String(this.buffer, (int)l2, n2);
    }

    public long length() throws SQLException {
        return this.length;
    }

    /*
     * Unable to fully structure code
     */
    public long position(String var1_1, long var2_2) throws SQLException {
        if (var2_2 < 0L || var2_2 > this.length || var2_2 + (long)var1_1.length() > this.length) {
            throw new SQLException("Invalid Arguments");
        }
        var4_3 = var1_1.toCharArray();
        var5_4 = (int)(var2_2 - 1L);
        var6_5 = false;
        var7_6 = var4_3.length;
        if (var2_2 >= 0L && var2_2 <= this.length) ** GOTO lbl14
        return -1L;
lbl-1000:
        // 1 sources

        {
            var9_7 = 0;
            var10_8 = var5_4 + 1;
            while (var4_3[var9_7++] == this.buffer[var5_4++]) {
                if ((long)var9_7 != var7_6) continue;
                return var10_8;
            }
lbl14:
            // 2 sources

            ** while ((long)var5_4 < this.length)
        }
lbl15:
        // 1 sources

        return -1L;
    }

    public long position(Clob clob, long l2) throws SQLException {
        return this.position(clob.getSubString(0L, (int)clob.length()), l2);
    }

    public OutputStream setAsciiStream(long l2) throws SQLException {
        DatabaseError.throwUnsupportedFeatureSqlException();
        return null;
    }

    public Writer setCharacterStream(long l2) throws SQLException {
        DatabaseError.throwUnsupportedFeatureSqlException();
        return null;
    }

    public int setString(long l2, String string) throws SQLException {
        DatabaseError.throwUnsupportedFeatureSqlException();
        return -1;
    }

    public int setString(long l2, String string, int n2, int n3) throws SQLException {
        DatabaseError.throwUnsupportedFeatureSqlException();
        return -1;
    }

    public void truncate(long l2) throws SQLException {
        DatabaseError.throwUnsupportedFeatureSqlException();
    }
}

