/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jmx.connector.invoker;

import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import javax.security.auth.Subject;
import org.jboss.jmx.connector.invoker.SecurityActions;
import org.jboss.security.SecurityAssociation;

class SecurityActions {
    SecurityActions() {
    }

    static Subject getActiveSubject() {
        Subject subject = (Subject)AccessController.doPrivileged(GetSubjectAction.ACTION);
        return subject;
    }

    static ClassLoader getContextClassLoader() {
        ClassLoader loader = (ClassLoader)AccessController.doPrivileged(GetTCLAction.ACTION);
        return loader;
    }

    static void setContextClassLoader(ClassLoader loader) {
        SetTCLAction action = new SetTCLAction(loader);
        AccessController.doPrivileged(action);
    }

    static void pushSubjectContext(Principal principal, Object credential, Subject subject) {
        if (System.getSecurityManager() == null) {
            PrincipalInfoAction.NON_PRIVILEGED.push(principal, credential, subject);
        } else {
            PrincipalInfoAction.PRIVILEGED.push(principal, credential, subject);
        }
    }

    static void popSubjectContext() {
        if (System.getSecurityManager() == null) {
            PrincipalInfoAction.NON_PRIVILEGED.pop();
        } else {
            PrincipalInfoAction.PRIVILEGED.pop();
        }
    }

    static interface PrincipalInfoAction {
        public static final PrincipalInfoAction PRIVILEGED = new PrincipalInfoAction(){

            public void push(Principal principal, Object credential, Subject subject) {
                AccessController.doPrivileged(new PrivilegedAction(this, subject, principal, credential){
                    private final /* synthetic */ Subject val$subject;
                    private final /* synthetic */ Principal val$principal;
                    private final /* synthetic */ Object val$credential;
                    private final /* synthetic */ 1 this$0;
                    {
                        this.this$0 = this$0;
                        this.val$subject = val$subject;
                        this.val$principal = val$principal;
                        this.val$credential = val$credential;
                    }

                    public Object run() {
                        SecurityAssociation.pushSubjectContext((Subject)this.val$subject, (Principal)this.val$principal, (Object)this.val$credential);
                        return null;
                    }
                });
            }

            public void pop() {
                AccessController.doPrivileged(new PrivilegedAction(this){
                    private final /* synthetic */ 1 this$0;
                    {
                        this.this$0 = this$0;
                    }

                    public Object run() {
                        SecurityAssociation.popSubjectContext();
                        return null;
                    }
                });
            }
        };
        public static final PrincipalInfoAction NON_PRIVILEGED = new PrincipalInfoAction(){

            public void push(Principal principal, Object credential, Subject subject) {
                SecurityAssociation.pushSubjectContext((Subject)subject, (Principal)principal, (Object)credential);
            }

            public void pop() {
                SecurityAssociation.popSubjectContext();
            }
        };

        public void push(Principal var1, Object var2, Subject var3);

        public void pop();
    }

    private static class SetTCLAction
    implements PrivilegedAction {
        ClassLoader loader;

        SetTCLAction(ClassLoader loader) {
            this.loader = loader;
        }

        public Object run() {
            Thread.currentThread().setContextClassLoader(this.loader);
            this.loader = null;
            return null;
        }
    }

    private static class GetTCLAction
    implements PrivilegedAction {
        static PrivilegedAction ACTION = new GetTCLAction();

        private GetTCLAction() {
        }

        public Object run() {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            return loader;
        }
    }

    private static class GetSubjectAction
    implements PrivilegedAction {
        static PrivilegedAction ACTION = new GetSubjectAction();

        private GetSubjectAction() {
        }

        public Object run() {
            Subject subject = SecurityAssociation.getSubject();
            return subject;
        }
    }
}

