/*
 * Decompiled with CFR 0.152.
 */
package au.id.jericho.lib.html;

import au.id.jericho.lib.html.Element;
import au.id.jericho.lib.html.EndTag;
import au.id.jericho.lib.html.Segment;
import au.id.jericho.lib.html.StartTag;
import au.id.jericho.lib.html.Tag;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

final class SearchCache {
    private static final String START_TAG_PREFIX = "ST";
    private static final String END_TAG_PREFIX = "ET";
    private static final String ELEMENT_PREFIX = "E";
    private static final String TAG_PREFIX = "T";
    private final HashMap cache = new HashMap();

    SearchCache() {
    }

    public List getTagList() {
        Segment segment;
        Object object;
        if (this.cache.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>(this.cache.size());
        Iterator<Object> iterator = this.cache.values().iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            if (object == StartTag.CACHED_NULL || object == EndTag.CACHED_NULL) continue;
            if (object instanceof Element) {
                segment = (Element)object;
                arrayList.add(((Element)segment).getStartTag());
                arrayList.add(((Element)segment).getEndTag());
                continue;
            }
            arrayList.add(object);
        }
        Collections.sort(arrayList);
        iterator = arrayList.iterator();
        object = (Tag)iterator.next();
        while (iterator.hasNext()) {
            segment = (Tag)iterator.next();
            if (segment.getBegin() == ((Segment)object).getBegin()) {
                iterator.remove();
            }
            object = segment;
        }
        return arrayList;
    }

    public static String getStartTagKey(int n, String string, boolean bl) {
        if (string == Tag.SERVER_MASON_NAMED_BLOCK) {
            string = "%named>";
        }
        return SearchCache.getKey(START_TAG_PREFIX, n, string, bl);
    }

    public StartTag getStartTag(String string) {
        return (StartTag)this.cache.get(string);
    }

    public void setStartTag(String string, StartTag startTag) {
        this.cache.put(string, startTag == null ? StartTag.CACHED_NULL : startTag);
    }

    public static String getEndTagKey(int n, String string, boolean bl) {
        return SearchCache.getKey(END_TAG_PREFIX, n, string, bl);
    }

    public static String getEndTagKey(int n) {
        return ELEMENT_PREFIX + n;
    }

    public EndTag getEndTag(String string) {
        return (EndTag)this.cache.get(string);
    }

    public void setEndTag(String string, EndTag endTag) {
        this.cache.put(string, endTag == null ? EndTag.CACHED_NULL : endTag);
    }

    public static String getElementKey(StartTag startTag) {
        return END_TAG_PREFIX + startTag.begin;
    }

    public Element getElement(String string) {
        return (Element)this.cache.get(string);
    }

    public void setElement(String string, Element element) {
        this.cache.put(string, element);
    }

    public static String getTagKey(int n) {
        return TAG_PREFIX + n;
    }

    public Tag getTag(String string) {
        return (Tag)this.cache.get(string);
    }

    public void setTag(String string, Tag tag) {
        this.cache.put(string, tag == null ? EndTag.CACHED_NULL : tag);
    }

    private static String getKey(String string, int n, String string2, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.append(n);
        if (string2 != null) {
            stringBuffer.append(string2);
        }
        if (bl) {
            stringBuffer.append('<');
        }
        return stringBuffer.toString();
    }
}

