/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.usermodel;

import org.apache.poi.hssf.record.FooterRecord;

public class HSSFFooter {
    FooterRecord footerRecord;
    String left;
    String center;
    String right;

    protected HSSFFooter(FooterRecord footerRecord) {
        this.footerRecord = footerRecord;
        String foot = footerRecord.getFooter();
        block5: while (foot != null && foot.length() > 1) {
            int pos = foot.length();
            switch (foot.substring(1, 2).charAt(0)) {
                case 'L': {
                    if (foot.indexOf("&C") >= 0) {
                        pos = Math.min(pos, foot.indexOf("&C"));
                    }
                    if (foot.indexOf("&R") >= 0) {
                        pos = Math.min(pos, foot.indexOf("&R"));
                    }
                    this.left = foot.substring(2, pos);
                    foot = foot.substring(pos);
                    continue block5;
                }
                case 'C': {
                    if (foot.indexOf("&L") >= 0) {
                        pos = Math.min(pos, foot.indexOf("&L"));
                    }
                    if (foot.indexOf("&R") >= 0) {
                        pos = Math.min(pos, foot.indexOf("&R"));
                    }
                    this.center = foot.substring(2, pos);
                    foot = foot.substring(pos);
                    continue block5;
                }
                case 'R': {
                    if (foot.indexOf("&C") >= 0) {
                        pos = Math.min(pos, foot.indexOf("&C"));
                    }
                    if (foot.indexOf("&L") >= 0) {
                        pos = Math.min(pos, foot.indexOf("&L"));
                    }
                    this.right = foot.substring(2, pos);
                    foot = foot.substring(pos);
                    continue block5;
                }
            }
            foot = null;
        }
    }

    public String getLeft() {
        return this.left;
    }

    public void setLeft(String newLeft) {
        this.left = newLeft;
        this.createFooterString();
    }

    public String getCenter() {
        return this.center;
    }

    public void setCenter(String newCenter) {
        this.center = newCenter;
        this.createFooterString();
    }

    public String getRight() {
        return this.right;
    }

    public void setRight(String newRight) {
        this.right = newRight;
        this.createFooterString();
    }

    private void createFooterString() {
        this.footerRecord.setFooter("&C" + (this.center == null ? "" : this.center) + "&L" + (this.left == null ? "" : this.left) + "&R" + (this.right == null ? "" : this.right));
        this.footerRecord.setFooterLength((byte)this.footerRecord.getFooter().length());
    }

    public static String fontSize(short size) {
        return "&" + size;
    }

    public static String font(String font2, String style2) {
        return "&\"" + font2 + "," + style2 + "\"";
    }

    public static String page() {
        return "&P";
    }

    public static String numPages() {
        return "&N";
    }

    public static String date() {
        return "&D";
    }

    public static String time() {
        return "&T";
    }

    public static String file() {
        return "&F";
    }

    public static String tab() {
        return "&A";
    }
}

