/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.aggregates;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.poi.hssf.record.ColumnInfoRecord;
import org.apache.poi.hssf.record.Record;

public class ColumnInfoRecordsAggregate
extends Record {
    int size = 0;
    List records = new ArrayList();

    protected void fillFields(byte[] data, short size, int offset) {
    }

    protected void validateSid(short id) {
    }

    public short getSid() {
        return -1012;
    }

    public int getRecordSize() {
        return this.size;
    }

    public Iterator getIterator() {
        return this.records.iterator();
    }

    public Object clone() {
        ColumnInfoRecordsAggregate rec = new ColumnInfoRecordsAggregate();
        Iterator colIter = this.getIterator();
        while (colIter.hasNext()) {
            ColumnInfoRecord col2 = (ColumnInfoRecord)((ColumnInfoRecord)colIter.next()).clone();
            rec.insertColumn(col2);
        }
        return rec;
    }

    public void insertColumn(ColumnInfoRecord col2) {
        this.size += col2.getRecordSize();
        this.records.add(col2);
    }

    public void insertColumn(int idx, ColumnInfoRecord col2) {
        this.size += col2.getRecordSize();
        this.records.add(idx, col2);
    }

    public int getNumColumns() {
        return this.records.size();
    }

    public int serialize(int offset, byte[] data) {
        Iterator itr = this.records.iterator();
        int pos = offset;
        while (itr.hasNext()) {
            pos += ((Record)itr.next()).serialize(pos, data);
        }
        return pos - offset;
    }

    public int findStartOfColumnOutlineGroup(int idx) {
        ColumnInfoRecord columnInfo = (ColumnInfoRecord)this.records.get(idx);
        short level = columnInfo.getOutlineLevel();
        while (idx != 0) {
            ColumnInfoRecord prevColumnInfo = (ColumnInfoRecord)this.records.get(idx - 1);
            if (columnInfo.getFirstColumn() - 1 != prevColumnInfo.getLastColumn() || prevColumnInfo.getOutlineLevel() < level) break;
            --idx;
            columnInfo = prevColumnInfo;
        }
        return idx;
    }

    public int findEndOfColumnOutlineGroup(int idx) {
        ColumnInfoRecord columnInfo = (ColumnInfoRecord)this.records.get(idx);
        short level = columnInfo.getOutlineLevel();
        while (idx < this.records.size() - 1) {
            ColumnInfoRecord nextColumnInfo = (ColumnInfoRecord)this.records.get(idx + 1);
            if (columnInfo.getLastColumn() + 1 != nextColumnInfo.getFirstColumn() || nextColumnInfo.getOutlineLevel() < level) break;
            ++idx;
            columnInfo = nextColumnInfo;
        }
        return idx;
    }

    public ColumnInfoRecord getColInfo(int idx) {
        return (ColumnInfoRecord)this.records.get(idx);
    }

    public ColumnInfoRecord writeHidden(ColumnInfoRecord columnInfo, int idx, boolean hidden) {
        short level = columnInfo.getOutlineLevel();
        while (idx < this.records.size()) {
            columnInfo.setHidden(hidden);
            if (idx + 1 < this.records.size()) {
                ColumnInfoRecord nextColumnInfo = (ColumnInfoRecord)this.records.get(idx + 1);
                if (columnInfo.getLastColumn() + 1 != nextColumnInfo.getFirstColumn() || nextColumnInfo.getOutlineLevel() < level) break;
                columnInfo = nextColumnInfo;
            }
            ++idx;
        }
        return columnInfo;
    }

    public boolean isColumnGroupCollapsed(int idx) {
        int endOfOutlineGroupIdx = this.findEndOfColumnOutlineGroup(idx);
        if (endOfOutlineGroupIdx >= this.records.size()) {
            return false;
        }
        if (this.getColInfo(endOfOutlineGroupIdx).getLastColumn() + 1 != this.getColInfo(endOfOutlineGroupIdx + 1).getFirstColumn()) {
            return false;
        }
        return this.getColInfo(endOfOutlineGroupIdx + 1).getCollapsed();
    }

    public boolean isColumnGroupHiddenByParent(int idx) {
        boolean startHidden;
        short startLevel;
        boolean endHidden;
        short endLevel;
        int endOfOutlineGroupIdx = this.findEndOfColumnOutlineGroup(idx);
        if (endOfOutlineGroupIdx >= this.records.size()) {
            endLevel = 0;
            endHidden = false;
        } else if (this.getColInfo(endOfOutlineGroupIdx).getLastColumn() + 1 != this.getColInfo(endOfOutlineGroupIdx + 1).getFirstColumn()) {
            endLevel = 0;
            endHidden = false;
        } else {
            endLevel = this.getColInfo(endOfOutlineGroupIdx + 1).getOutlineLevel();
            endHidden = this.getColInfo(endOfOutlineGroupIdx + 1).getHidden();
        }
        int startOfOutlineGroupIdx = this.findStartOfColumnOutlineGroup(idx);
        if (startOfOutlineGroupIdx <= 0) {
            startLevel = 0;
            startHidden = false;
        } else if (this.getColInfo(startOfOutlineGroupIdx).getFirstColumn() - 1 != this.getColInfo(startOfOutlineGroupIdx - 1).getLastColumn()) {
            startLevel = 0;
            startHidden = false;
        } else {
            startLevel = this.getColInfo(startOfOutlineGroupIdx - 1).getOutlineLevel();
            startHidden = this.getColInfo(startOfOutlineGroupIdx - 1).getHidden();
        }
        if (endLevel > startLevel) {
            return endHidden;
        }
        return startHidden;
    }

    public void collapseColumn(short columnNumber) {
        int idx = this.findColumnIdx(columnNumber, 0);
        if (idx == -1) {
            return;
        }
        ColumnInfoRecord columnInfo = (ColumnInfoRecord)this.records.get(this.findStartOfColumnOutlineGroup(idx));
        columnInfo = this.writeHidden(columnInfo, idx, true);
        this.setColumn((short)(columnInfo.getLastColumn() + 1), null, null, null, Boolean.TRUE);
    }

    public void expandColumn(short columnNumber) {
        int idx = this.findColumnIdx(columnNumber, 0);
        if (idx == -1) {
            return;
        }
        if (!this.isColumnGroupCollapsed(idx)) {
            return;
        }
        int startIdx = this.findStartOfColumnOutlineGroup(idx);
        ColumnInfoRecord columnInfo = this.getColInfo(startIdx);
        int endIdx = this.findEndOfColumnOutlineGroup(idx);
        ColumnInfoRecord endColumnInfo = this.getColInfo(endIdx);
        if (!this.isColumnGroupHiddenByParent(idx)) {
            for (int i2 = startIdx; i2 <= endIdx; ++i2) {
                if (columnInfo.getOutlineLevel() != this.getColInfo(i2).getOutlineLevel()) continue;
                this.getColInfo(i2).setHidden(false);
            }
        }
        this.setColumn((short)(columnInfo.getLastColumn() + 1), null, null, null, Boolean.FALSE);
    }

    public static Record createColInfo() {
        ColumnInfoRecord retval = new ColumnInfoRecord();
        retval.setColumnWidth((short)2275);
        retval.setOptions((short)2);
        retval.setXFIndex((short)15);
        return retval;
    }

    public void setColumn(short column, Short width, Integer level, Boolean hidden, Boolean collapsed) {
        ColumnInfoRecord ci = null;
        int k = 0;
        for (k = 0; k < this.records.size() && ((ci = (ColumnInfoRecord)this.records.get(k)).getFirstColumn() > column || column > ci.getLastColumn()); ++k) {
            ci = null;
        }
        if (ci != null) {
            boolean columnChanged;
            boolean widthChanged = width != null && ci.getColumnWidth() != width.shortValue();
            boolean levelChanged = level != null && ci.getOutlineLevel() != level.intValue();
            boolean hiddenChanged = hidden != null && ci.getHidden() != hidden.booleanValue();
            boolean collapsedChanged = collapsed != null && ci.getCollapsed() != collapsed.booleanValue();
            boolean bl = columnChanged = widthChanged || levelChanged || hiddenChanged || collapsedChanged;
            if (columnChanged) {
                if (ci.getFirstColumn() == column && ci.getLastColumn() == column) {
                    this.setColumnInfoFields(ci, width, level, hidden, collapsed);
                } else if (ci.getFirstColumn() == column || ci.getLastColumn() == column) {
                    if (ci.getFirstColumn() == column) {
                        ci.setFirstColumn((short)(column + 1));
                    } else {
                        ci.setLastColumn((short)(column - 1));
                    }
                    ColumnInfoRecord nci = (ColumnInfoRecord)ColumnInfoRecordsAggregate.createColInfo();
                    nci.setFirstColumn(column);
                    nci.setLastColumn(column);
                    nci.setOptions(ci.getOptions());
                    nci.setXFIndex(ci.getXFIndex());
                    this.setColumnInfoFields(nci, width, level, hidden, collapsed);
                    this.insertColumn(k, nci);
                } else {
                    short lastcolumn = ci.getLastColumn();
                    ci.setLastColumn((short)(column - 1));
                    ColumnInfoRecord nci = (ColumnInfoRecord)ColumnInfoRecordsAggregate.createColInfo();
                    nci.setFirstColumn(column);
                    nci.setLastColumn(column);
                    nci.setOptions(ci.getOptions());
                    nci.setXFIndex(ci.getXFIndex());
                    this.setColumnInfoFields(nci, width, level, hidden, collapsed);
                    this.insertColumn(++k, nci);
                    nci = (ColumnInfoRecord)ColumnInfoRecordsAggregate.createColInfo();
                    nci.setFirstColumn((short)(column + 1));
                    nci.setLastColumn(lastcolumn);
                    nci.setOptions(ci.getOptions());
                    nci.setXFIndex(ci.getXFIndex());
                    nci.setColumnWidth(ci.getColumnWidth());
                    this.insertColumn(++k, nci);
                }
            }
        } else {
            ColumnInfoRecord nci = (ColumnInfoRecord)ColumnInfoRecordsAggregate.createColInfo();
            nci.setFirstColumn(column);
            nci.setLastColumn(column);
            this.setColumnInfoFields(nci, width, level, hidden, collapsed);
            this.insertColumn(k, nci);
        }
    }

    private void setColumnInfoFields(ColumnInfoRecord ci, Short width, Integer level, Boolean hidden, Boolean collapsed) {
        if (width != null) {
            ci.setColumnWidth(width);
        }
        if (level != null) {
            ci.setOutlineLevel(level.shortValue());
        }
        if (hidden != null) {
            ci.setHidden(hidden);
        }
        if (collapsed != null) {
            ci.setCollapsed(collapsed);
        }
    }

    public int findColumnIdx(int column, int fromIdx) {
        if (column < 0) {
            throw new IllegalArgumentException("column parameter out of range: " + column);
        }
        if (fromIdx < 0) {
            throw new IllegalArgumentException("fromIdx parameter out of range: " + fromIdx);
        }
        for (int k = fromIdx; k < this.records.size(); ++k) {
            ColumnInfoRecord ci = (ColumnInfoRecord)this.records.get(k);
            if (ci.getFirstColumn() <= column && column <= ci.getLastColumn()) {
                return k;
            }
            ci = null;
        }
        return -1;
    }

    public void collapseColInfoRecords(int columnIdx) {
        boolean columnsMatch;
        boolean adjacentColumns;
        if (columnIdx == 0) {
            return;
        }
        ColumnInfoRecord previousCol = (ColumnInfoRecord)this.records.get(columnIdx - 1);
        ColumnInfoRecord currentCol = (ColumnInfoRecord)this.records.get(columnIdx);
        boolean bl = adjacentColumns = previousCol.getLastColumn() == currentCol.getFirstColumn() - 1;
        if (!adjacentColumns) {
            return;
        }
        boolean bl2 = columnsMatch = previousCol.getXFIndex() == currentCol.getXFIndex() && previousCol.getOptions() == currentCol.getOptions() && previousCol.getColumnWidth() == currentCol.getColumnWidth();
        if (columnsMatch) {
            previousCol.setLastColumn(currentCol.getLastColumn());
            this.records.remove(columnIdx);
        }
    }

    public void groupColumnRange(short fromColumn, short toColumn, boolean indent) {
        int fromIdx = 0;
        for (int i2 = fromColumn; i2 <= toColumn; ++i2) {
            int level = 1;
            int columnIdx = this.findColumnIdx(i2, Math.max(0, fromIdx));
            if (columnIdx != -1) {
                level = ((ColumnInfoRecord)this.records.get(columnIdx)).getOutlineLevel();
                level = indent ? ++level : --level;
                level = Math.max(0, level);
                level = Math.min(7, level);
                fromIdx = columnIdx - 1;
            }
            this.setColumn((short)i2, null, new Integer(level), null, null);
            columnIdx = this.findColumnIdx(i2, Math.max(0, fromIdx));
            this.collapseColInfoRecords(columnIdx);
        }
    }
}

