/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordFormatException;
import org.apache.poi.util.BitField;
import org.apache.poi.util.LittleEndian;

public class WindowOneRecord
extends Record {
    public static final short sid = 61;
    private short field_1_h_hold;
    private short field_2_v_hold;
    private short field_3_width;
    private short field_4_height;
    private short field_5_options;
    private static final BitField hidden = new BitField(1);
    private static final BitField iconic = new BitField(2);
    private static final BitField reserved = new BitField(4);
    private static final BitField hscroll = new BitField(8);
    private static final BitField vscroll = new BitField(16);
    private static final BitField tabs = new BitField(32);
    private short field_6_selected_tab;
    private short field_7_displayed_tab;
    private short field_8_num_selected_tabs;
    private short field_9_tab_width_ratio;

    public WindowOneRecord() {
    }

    public WindowOneRecord(short id, short size, byte[] data) {
        super(id, size, data);
    }

    public WindowOneRecord(short id, short size, byte[] data, int offset) {
        super(id, size, data, offset);
    }

    protected void validateSid(short id) {
        if (id != 61) {
            throw new RecordFormatException("NOT A WINDOW1 RECORD");
        }
    }

    protected void fillFields(byte[] data, short size, int offset) {
        this.field_1_h_hold = LittleEndian.getShort(data, 0 + offset);
        this.field_2_v_hold = LittleEndian.getShort(data, 2 + offset);
        this.field_3_width = LittleEndian.getShort(data, 4 + offset);
        this.field_4_height = LittleEndian.getShort(data, 6 + offset);
        this.field_5_options = LittleEndian.getShort(data, 8 + offset);
        this.field_6_selected_tab = LittleEndian.getShort(data, 10 + offset);
        this.field_7_displayed_tab = LittleEndian.getShort(data, 12 + offset);
        this.field_8_num_selected_tabs = LittleEndian.getShort(data, 14 + offset);
        this.field_9_tab_width_ratio = LittleEndian.getShort(data, 16 + offset);
    }

    public void setHorizontalHold(short h7) {
        this.field_1_h_hold = h7;
    }

    public void setVerticalHold(short v) {
        this.field_2_v_hold = v;
    }

    public void setWidth(short w) {
        this.field_3_width = w;
    }

    public void setHeight(short h7) {
        this.field_4_height = h7;
    }

    public void setOptions(short o) {
        this.field_5_options = o;
    }

    public void setHidden(boolean ishidden) {
        this.field_5_options = hidden.setShortBoolean(this.field_5_options, ishidden);
    }

    public void setIconic(boolean isiconic) {
        this.field_5_options = iconic.setShortBoolean(this.field_5_options, isiconic);
    }

    public void setDisplayHorizonalScrollbar(boolean scroll) {
        this.field_5_options = hscroll.setShortBoolean(this.field_5_options, scroll);
    }

    public void setDisplayVerticalScrollbar(boolean scroll) {
        this.field_5_options = vscroll.setShortBoolean(this.field_5_options, scroll);
    }

    public void setDisplayTabs(boolean disptabs) {
        this.field_5_options = tabs.setShortBoolean(this.field_5_options, disptabs);
    }

    public void setSelectedTab(short s2) {
        this.field_6_selected_tab = s2;
    }

    public void setDisplayedTab(short t) {
        this.field_7_displayed_tab = t;
    }

    public void setNumSelectedTabs(short n) {
        this.field_8_num_selected_tabs = n;
    }

    public void setTabWidthRatio(short r) {
        this.field_9_tab_width_ratio = r;
    }

    public short getHorizontalHold() {
        return this.field_1_h_hold;
    }

    public short getVerticalHold() {
        return this.field_2_v_hold;
    }

    public short getWidth() {
        return this.field_3_width;
    }

    public short getHeight() {
        return this.field_4_height;
    }

    public short getOptions() {
        return this.field_5_options;
    }

    public boolean getHidden() {
        return hidden.isSet(this.field_5_options);
    }

    public boolean getIconic() {
        return iconic.isSet(this.field_5_options);
    }

    public boolean getDisplayHorizontalScrollbar() {
        return hscroll.isSet(this.field_5_options);
    }

    public boolean getDisplayVerticalScrollbar() {
        return vscroll.isSet(this.field_5_options);
    }

    public boolean getDisplayTabs() {
        return tabs.isSet(this.field_5_options);
    }

    public short getSelectedTab() {
        return this.field_6_selected_tab;
    }

    public short getDisplayedTab() {
        return this.field_7_displayed_tab;
    }

    public short getNumSelectedTabs() {
        return this.field_8_num_selected_tabs;
    }

    public short getTabWidthRatio() {
        return this.field_9_tab_width_ratio;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[WINDOW1]\n");
        buffer.append("    .h_hold          = ").append(Integer.toHexString(this.getHorizontalHold())).append("\n");
        buffer.append("    .v_hold          = ").append(Integer.toHexString(this.getVerticalHold())).append("\n");
        buffer.append("    .width           = ").append(Integer.toHexString(this.getWidth())).append("\n");
        buffer.append("    .height          = ").append(Integer.toHexString(this.getHeight())).append("\n");
        buffer.append("    .options         = ").append(Integer.toHexString(this.getOptions())).append("\n");
        buffer.append("        .hidden      = ").append(this.getHidden()).append("\n");
        buffer.append("        .iconic      = ").append(this.getIconic()).append("\n");
        buffer.append("        .hscroll     = ").append(this.getDisplayHorizontalScrollbar()).append("\n");
        buffer.append("        .vscroll     = ").append(this.getDisplayVerticalScrollbar()).append("\n");
        buffer.append("        .tabs        = ").append(this.getDisplayTabs()).append("\n");
        buffer.append("    .selectedtab     = ").append(Integer.toHexString(this.getSelectedTab())).append("\n");
        buffer.append("    .displayedtab    = ").append(Integer.toHexString(this.getDisplayedTab())).append("\n");
        buffer.append("    .numselectedtabs = ").append(Integer.toHexString(this.getNumSelectedTabs())).append("\n");
        buffer.append("    .tabwidthratio   = ").append(Integer.toHexString(this.getTabWidthRatio())).append("\n");
        buffer.append("[/WINDOW1]\n");
        return buffer.toString();
    }

    public int serialize(int offset, byte[] data) {
        LittleEndian.putShort(data, 0 + offset, (short)61);
        LittleEndian.putShort(data, 2 + offset, (short)18);
        LittleEndian.putShort(data, 4 + offset, this.getHorizontalHold());
        LittleEndian.putShort(data, 6 + offset, this.getVerticalHold());
        LittleEndian.putShort(data, 8 + offset, this.getWidth());
        LittleEndian.putShort(data, 10 + offset, this.getHeight());
        LittleEndian.putShort(data, 12 + offset, this.getOptions());
        LittleEndian.putShort(data, 14 + offset, this.getSelectedTab());
        LittleEndian.putShort(data, 16 + offset, this.getDisplayedTab());
        LittleEndian.putShort(data, 18 + offset, this.getNumSelectedTabs());
        LittleEndian.putShort(data, 20 + offset, this.getTabWidthRatio());
        return this.getRecordSize();
    }

    public int getRecordSize() {
        return 22;
    }

    public short getSid() {
        return 61;
    }
}

