/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hpsf;

import org.apache.poi.hpsf.Util;
import org.apache.poi.util.LittleEndian;

public class TypeReader {
    public static Object read(byte[] src, int offset, int length, int type) {
        Object value;
        length -= 4;
        switch (type) {
            case 0: {
                value = null;
                break;
            }
            case 2: {
                value = new Integer(LittleEndian.getUShort(src, offset));
                break;
            }
            case 3: {
                value = new Long(LittleEndian.getUInt(src, offset));
                break;
            }
            case 64: {
                long low = LittleEndian.getUInt(src, offset);
                long high = LittleEndian.getUInt(src, offset += 4);
                value = Util.filetimeToDate((int)high, (int)low);
                break;
            }
            case 30: {
                int first = offset + 4;
                long last = (long)first + LittleEndian.getUInt(src, offset) - 1L;
                offset += 4;
                while (src[(int)last] == 0 && (long)first <= last) {
                    --last;
                }
                value = new String(src, first, (int)(last - (long)first + 1L));
                break;
            }
            case 31: {
                int first = offset + 4;
                long last = (long)first + LittleEndian.getUInt(src, offset) - 1L;
                long l = last - (long)first;
                offset += 4;
                StringBuffer b2 = new StringBuffer((int)(last - (long)first));
                int i2 = 0;
                while ((long)i2 <= l) {
                    int i1 = offset + i2 * 2;
                    int i22 = i1 + 1;
                    b2.append((char)((src[i22] << 8) + src[i1]));
                    ++i2;
                }
                while (b2.charAt(b2.length() - 1) == '\u0000') {
                    b2.setLength(b2.length() - 1);
                }
                value = b2.toString();
                break;
            }
            case 71: {
                byte[] v = new byte[length];
                for (int i3 = 0; i3 < length; ++i3) {
                    v[i3] = src[offset + i3];
                }
                value = v;
                break;
            }
            case 11: {
                long bool = LittleEndian.getUInt(src, offset);
                if (bool != 0L) {
                    value = new Boolean(true);
                    break;
                }
                value = new Boolean(false);
                break;
            }
            default: {
                byte[] v = new byte[length];
                for (int i4 = 0; i4 < length; ++i4) {
                    v[i4] = src[offset + i4];
                }
                value = v;
                break;
            }
        }
        return value;
    }
}

