/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.lindfors.util;

import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class BoundBuffer
extends AbstractCollection
implements Serializable {
    public static final int DEFAULT_CAPACITY = 64;
    private int size = 0;
    private int head = 0;
    private int tail = 0;
    private int modCount = 0;
    private Object[] array = null;

    public BoundBuffer() {
        this.array = new Object[64];
    }

    public BoundBuffer(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("negative capacity");
        }
        this.array = new Object[n + 1];
    }

    public BoundBuffer(Collection collection) {
        this.array = new Object[collection.size() + 1];
        System.arraycopy(collection.toArray(), 0, this.array, 0, collection.size());
        this.size = collection.size();
        this.head = this.array.length - 1;
    }

    public BoundBuffer(Collection collection, int n) {
        if (n < 0) {
            throw new IllegalArgumentException("negative capacity");
        }
        if (n < collection.size()) {
            n = collection.size();
        }
        this.array = new Object[n + 1];
        System.arraycopy(collection.toArray(), 0, this.array, 0, collection.size());
        this.head = this.size = collection.size();
    }

    public int size() {
        return this.size;
    }

    public Iterator iterator() {
        return new Iterator(){
            private int modCount;
            private int position;
            private boolean canRemove;
            {
                this.modCount = BoundBuffer.this.modCount;
                this.position = BoundBuffer.this.tail;
                this.canRemove = true;
            }

            public boolean hasNext() {
                if (this.modCount != BoundBuffer.this.modCount) {
                    throw new ConcurrentModificationException();
                }
                return this.position != BoundBuffer.this.head;
            }

            public Object next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                if (++this.position >= BoundBuffer.this.array.length) {
                    this.position = 0;
                }
                return BoundBuffer.this.array[this.position];
            }

            public void remove() {
                throw new UnsupportedOperationException("remove() not implemented");
            }
        };
    }

    public boolean add(Object object) {
        if (this.size == this.array.length - 1) {
            if (++this.tail == this.array.length) {
                this.tail = 0;
            }
            if (++this.head == this.array.length) {
                this.head = 0;
            }
            this.array[this.head] = object;
            ++this.modCount;
            return true;
        }
        if (++this.head == this.array.length) {
            this.head = 0;
        }
        this.array[this.head] = object;
        ++this.size;
        ++this.modCount;
        return true;
    }

    public void clear() {
        int n = this.array.length;
        this.array = new Object[n];
        this.size = 0;
        this.head = 0;
        this.tail = 0;
        ++this.modCount;
    }
}

