/*
 * Decompiled with CFR 0.152.
 */
package org.displaytag.properties;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.builder.HashCodeBuilder;

public final class MediaTypeEnum {
    private static final List ALL = new ArrayList();
    public static final MediaTypeEnum HTML = new MediaTypeEnum(0, "html");
    public static final MediaTypeEnum CSV = new MediaTypeEnum(1, "csv");
    public static final MediaTypeEnum EXCEL = new MediaTypeEnum(2, "excel");
    public static final MediaTypeEnum XML = new MediaTypeEnum(3, "xml");
    private final int enumCode;
    private final String enumName;

    private MediaTypeEnum(int code, String name) {
        this.enumCode = code;
        this.enumName = name;
        ALL.add(this);
    }

    public int getCode() {
        return this.enumCode;
    }

    public String getName() {
        return this.enumName;
    }

    public static MediaTypeEnum fromCode(int key) {
        for (int i2 = 0; i2 < ALL.size(); ++i2) {
            if (key != ((MediaTypeEnum)ALL.get(i2)).getCode()) continue;
            return (MediaTypeEnum)ALL.get(i2);
        }
        return null;
    }

    public static MediaTypeEnum fromCode(Integer key) {
        if (key == null) {
            return null;
        }
        return MediaTypeEnum.fromCode((int)key);
    }

    public static MediaTypeEnum fromIntegerCode(Integer key) {
        return MediaTypeEnum.fromCode(key);
    }

    public static MediaTypeEnum fromName(String code) {
        for (int i2 = 0; i2 < ALL.size(); ++i2) {
            if (!((MediaTypeEnum)ALL.get(i2)).getName().equals(code)) continue;
            return (MediaTypeEnum)ALL.get(i2);
        }
        return null;
    }

    public static Iterator iterator() {
        return ALL.iterator();
    }

    public static synchronized MediaTypeEnum registerMediaType(String name) {
        MediaTypeEnum existing = MediaTypeEnum.fromName(name);
        if (existing == null) {
            existing = new MediaTypeEnum(ALL.size() + 1, name);
        }
        return existing;
    }

    public static int getSize() {
        return ALL.size();
    }

    public String toString() {
        return this.getName();
    }

    public boolean equals(Object o) {
        return this == o;
    }

    public int hashCode() {
        return new HashCodeBuilder(1188997057, -1289297553).append(this.enumCode).toHashCode();
    }
}

