/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.www;

import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Enumeration;
import java.util.logging.Level;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.ecs.Element;
import org.apache.ecs.xhtml.big;
import org.apache.ecs.xhtml.button;
import org.apache.ecs.xhtml.form;
import org.apache.ecs.xhtml.img;
import org.apache.ecs.xhtml.input;
import org.apache.ecs.xhtml.script;
import org.apache.ecs.xhtml.small;
import org.apache.ecs.xhtml.table;
import org.apache.ecs.xhtml.td;
import org.apache.ecs.xhtml.th;
import org.apache.ecs.xhtml.thead;
import org.apache.ecs.xhtml.tr;
import org.compiere.model.GridField;
import org.compiere.model.GridTab;
import org.compiere.model.GridWindowVO;
import org.compiere.model.MSession;
import org.compiere.util.CLogger;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.WebDoc;
import org.compiere.util.WebEnv;
import org.compiere.util.WebSessionCtx;
import org.compiere.util.WebUtil;
import org.compiere.www.WWindowStatus;
import org.compiere.www.WebField;

public class WWindow
extends HttpServlet {
    protected static CLogger log = CLogger.getCLogger(WWindow.class);
    private static int s_WindowNo = 1;
    protected static final String FORM_NAME = "WForm";
    private static final String P_Command = "PCommand";
    private static final String P_Tab = "PTab";
    private static final String P_MR_RowNo = "PMRRowNo";
    private static final String P_ChangedColumn = "ChangedColumn";
    private static final int MAX_LINES = 12;
    private static final int LAST_LINE = 999999;
    private static final String ERROR = " ERROR! ";

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        if (!WebEnv.initWeb(config)) {
            throw new ServletException("WWindow.init");
        }
    }

    public String getServletInfo() {
        return "Compiere Web Window";
    }

    public void destroy() {
        log.fine("destroy");
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        GridWindowVO mWindowVO;
        HttpSession sess = request.getSession();
        WebSessionCtx wsc = WebSessionCtx.get(request);
        if (wsc == null) {
            WebUtil.createTimeoutPage(request, response, this, null);
            return;
        }
        int AD_Window_ID = WebUtil.getParameterAsInt(request, "AD_Window_ID");
        int AD_Menu_ID = WebUtil.getParameterAsInt(request, "AD_Menu_ID");
        log.info("AD_Window_ID=" + AD_Window_ID + "; AD_Menu_ID=" + AD_Menu_ID);
        WWindowStatus ws = WWindowStatus.get(request);
        if (ws != null) {
            int WindowNo = ws.mWindow.getWindowNo();
            log.fine("Disposing - WindowNo=" + WindowNo + ", ID=" + ws.mWindow.getAD_Window_ID());
            ws.mWindow.dispose();
            Env.clearWinContext(wsc.ctx, WindowNo);
        }
        if ((mWindowVO = GridWindowVO.create(wsc.ctx, s_WindowNo++, AD_Window_ID, AD_Menu_ID)) == null) {
            String msg = Msg.translate(wsc.ctx, "AD_Window_ID") + " " + Msg.getMsg(wsc.ctx, "NotFound") + ", ID=" + AD_Window_ID + "/" + AD_Menu_ID;
            WebUtil.createErrorPage(request, response, this, msg);
            sess.setAttribute("WWindowStatus", null);
            return;
        }
        ws = new WWindowStatus(mWindowVO);
        sess.setAttribute("WWindowStatus", (Object)ws);
        ws.curTab.query(ws.curTab.getOnlyCurrentDays());
        ws.curTab.navigate(0);
        WebDoc doc = null;
        doc = ws.curTab.isSingleRow() ? this.getSR_Form(request.getRequestURI(), wsc, ws) : this.getMR_Form(request.getRequestURI(), wsc, ws);
        log.fine("Fini");
        WebUtil.createResponse(request, response, this, null, doc, true);
        log.fine("Closed");
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        WebEnv.dump(request);
        WebSessionCtx wsc = WebSessionCtx.get(request);
        WWindowStatus ws = WWindowStatus.get(request);
        if (wsc == null || ws == null) {
            if (wsc == null) {
                WebUtil.createTimeoutPage(request, response, this, "No Context");
            } else {
                this.doGet(request, response);
            }
            return;
        }
        String p_cmd = WebUtil.getParameter(request, P_Command);
        String column = WebUtil.getParameter(request, P_ChangedColumn);
        log.info("Cmd=" + p_cmd + " - ChangedColumn=" + column);
        if (column != null && column.length() > 0) {
            this.updateFields(request, wsc, ws);
        } else {
            if (p_cmd.equals("Exit")) {
                MSession cSession = MSession.get(wsc.ctx, false);
                if (cSession != null) {
                    cSession.logout();
                }
                WebUtil.createLoginPage(request, response, this, ws.ctx, "Exit");
                return;
            }
            this.executeCommand(request, p_cmd, wsc, ws);
        }
        WebDoc doc = null;
        doc = ws.curTab.isSingleRow() ? this.getSR_Form(request.getRequestURI(), wsc, ws) : this.getMR_Form(request.getRequestURI(), wsc, ws);
        log.fine("Fini");
        WebUtil.createResponse(request, response, this, null, doc, true);
        log.fine("Closed");
    }

    private void executeCommand(HttpServletRequest request, String p_cmd, WebSessionCtx wsc, WWindowStatus ws) {
        String p_tab = WebUtil.getParameter(request, P_Tab);
        String p_row = WebUtil.getParameter(request, P_MR_RowNo);
        log.config(p_cmd + " - Tab=" + p_tab + " - Row=" + p_row);
        if (p_row != null && p_row.length() > 0) {
            try {
                int newRowNo = Integer.parseInt(p_row);
                ws.curTab.navigate(newRowNo);
                ws.curTab.setSingleRow(true);
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Parse RowNo=" + p_row, e);
            }
        } else if (p_tab != null && p_tab.length() > 0) {
            int newTabNo = 0;
            try {
                newTabNo = Integer.parseInt(p_tab);
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Parse TabNo=" + p_tab, e);
            }
            if (newTabNo > ws.curTab.getTabNo()) {
                ws.curTab = ws.mWindow.getTab(newTabNo);
                ws.curTab.query(0);
                ws.curTab.navigate(0);
            } else if (newTabNo < ws.curTab.getTabNo()) {
                ws.curTab = ws.mWindow.getTab(newTabNo);
                ws.curTab.dataRefresh();
            }
        } else if (p_cmd.equals("Multi")) {
            boolean single = ws.curTab.isSingleRow();
            ws.curTab.setSingleRow(!single);
            if (single) {
                ws.curTab.navigate(0);
            }
        } else if (p_cmd.equals("First")) {
            ws.curTab.navigate(0);
        } else if (p_cmd.equals("Next")) {
            ws.curTab.navigateRelative(1);
        } else if (p_cmd.equals("Previous")) {
            int rows = ws.curTab.isSingleRow() ? -1 : -24;
            ws.curTab.navigateRelative(rows);
        } else if (p_cmd.equals("Last")) {
            ws.curTab.navigateRelative(999999);
        } else if (!p_cmd.equals("Find")) {
            if (p_cmd.equals("Refresh")) {
                ws.curTab.dataRefreshAll();
            } else if (!p_cmd.equals("Attachment")) {
                if (p_cmd.equals("History")) {
                    if (ws.mWindow.isTransaction() && ws.curTab.getWindowNo() == 0) {
                        ws.curTab.query(ws.curTab.getOnlyCurrentDays());
                        ws.curTab.navigate(0);
                    }
                } else if (!p_cmd.equals("Report") && !p_cmd.equals("Print")) {
                    if (p_cmd.equals("New")) {
                        if (!ws.curTab.dataNew(false)) {
                            ws.curTab.dataIgnore();
                        }
                    } else if (p_cmd.equals("Delete")) {
                        ws.curTab.dataDelete();
                    } else if (p_cmd.equals("Save")) {
                        this.executeSave(request, wsc, ws);
                    }
                }
            }
        }
    }

    private void executeSave(HttpServletRequest request, WebSessionCtx wsc, WWindowStatus ws) {
        log.info("");
        boolean error = this.updateFields(request, wsc, ws);
        log.fine("Mandatory check");
        int size = ws.curTab.getFieldCount();
        for (int i2 = 0; i2 < size; ++i2) {
            GridField field = ws.curTab.getField(i2);
            if (!field.isMandatory(true)) continue;
            Object value = field.getValue();
            if (value == null || value.toString().length() == 0) {
                field.setInserting(true);
                field.setError(true);
                field.setErrorValue(value == null ? null : value.toString());
                if (!error) {
                    error = true;
                }
                log.info("Mandatory Error: " + field.getColumnName());
                continue;
            }
            field.setError(false);
        }
        if (error) {
            return;
        }
        if (!ws.curTab.dataSave(true)) {
            ws.curTab.dataIgnore();
        }
        log.fine("done");
    }

    private boolean updateFields(HttpServletRequest request, WebSessionCtx wsc, WWindowStatus ws) {
        Object newValue;
        String value;
        GridField mField;
        boolean error = false;
        try {
            String enc = request.getCharacterEncoding();
            if (enc == null) {
                request.setCharacterEncoding("UTF-8");
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Set CharacterEndocung=UTF-8", e);
        }
        Enumeration en = request.getParameterNames();
        while (en.hasMoreElements()) {
            String key = (String)en.nextElement();
            if (key.equals(P_Command) || key.equals(P_ChangedColumn) || key.equals(P_MR_RowNo) || key.equals(P_Tab) || (mField = ws.curTab.getField(key)) == null || !mField.isEditable(true)) continue;
            value = WebUtil.getParameter(request, key);
            Object dbValue = mField.getValue();
            boolean fieldError = false;
            String columnName = mField.getColumnName();
            log.finest(columnName + ": " + (dbValue == null ? "null" : dbValue.toString()) + " -> " + (value == null ? "null" : value.toString()));
            if (dbValue == null && value == null) continue;
            if (dbValue != null && value == null) {
                ws.curTab.setValue(mField, null);
            } else if (dbValue == null && value != null) {
                fieldError = !this.setFieldValue(wsc, ws, mField, value);
            } else {
                if (dbValue.equals(value)) continue;
                boolean bl = fieldError = !this.setFieldValue(wsc, ws, mField, value);
            }
            if (error || !fieldError) continue;
            log.info("Error: " + mField.getColumnName());
            error = true;
        }
        String columnName = WebUtil.getParameter(request, P_ChangedColumn);
        if (columnName != null && columnName.length() > 0 && (mField = ws.curTab.getField(columnName)) != null && !ERROR.equals(newValue = this.getFieldValue(wsc, mField, value = WebUtil.getParameter(request, columnName)))) {
            if (newValue == null && mField.getDisplayType() == 20) {
                newValue = "N";
            }
            log.fine("ChangedColumn: " + columnName + "=" + newValue);
            ws.curTab.setValue(mField, newValue);
        }
        return error;
    }

    private boolean setFieldValue(WebSessionCtx wsc, WWindowStatus ws, GridField mField, String value) {
        Object newValue = this.getFieldValue(wsc, mField, value);
        if (ERROR.equals(newValue)) {
            mField.setErrorValue(value);
            return false;
        }
        Object dbValue = mField.getValue();
        if (newValue == null && dbValue != null || newValue != null && !newValue.equals(dbValue)) {
            ws.curTab.setValue(mField, newValue);
        }
        return true;
    }

    private Object getFieldValue(WebSessionCtx wsc, GridField mField, String value) {
        if (value == null || value.length() == 0) {
            return null;
        }
        int dt = mField.getDisplayType();
        String columnName = mField.getColumnName();
        if (DisplayType.isNumeric(dt)) {
            BigDecimal bd = null;
            try {
                Number nn = null;
                nn = dt == 12 ? (Number)wsc.amountFormat.parse(value) : (Number)(dt == 29 ? (Number)wsc.quantityFormat.parse(value) : (Number)wsc.numberFormat.parse(value));
                bd = nn instanceof BigDecimal ? (BigDecimal)nn : new BigDecimal(nn.toString());
            }
            catch (Exception e) {
                log.warning("BigDecimal: " + columnName + "=" + value + ERROR);
                return ERROR;
            }
            log.fine("BigDecimal: " + columnName + "=" + value + " -> " + bd);
            return bd;
        }
        if (DisplayType.isID(dt)) {
            Integer ii = null;
            try {
                ii = new Integer(value);
            }
            catch (Exception e) {
                log.log(Level.WARNING, "ID: " + columnName + "=" + value, e);
                ii = null;
            }
            if (ii == -1) {
                ii = null;
            }
            log.fine("ID: " + columnName + "=" + value + " -> " + ii);
            return ii;
        }
        if (DisplayType.isDate(dt)) {
            Timestamp ts = null;
            try {
                Date d = null;
                d = dt == 15 ? wsc.dateFormat.parse(value) : wsc.dateTimeFormat.parse(value);
                ts = new Timestamp(d.getTime());
            }
            catch (Exception e) {
                log.warning("Date: " + columnName + "=" + value + ERROR);
                return ERROR;
            }
            log.fine("Date: " + columnName + "=" + value + " -> " + ts);
            return ts;
        }
        if (dt == 20) {
            Boolean retValue = Boolean.FALSE;
            if (value.equals("true")) {
                retValue = Boolean.TRUE;
            }
            log.fine("YesNo: " + columnName + "=" + value + " -> " + retValue);
            return retValue;
        }
        log.fine(columnName + "=" + value);
        return value;
    }

    private WebDoc getSR_Form(String action, WebSessionCtx wsc, WWindowStatus ws) {
        log.fine("Tab=" + ws.curTab.getTabNo());
        table table2 = new table().setAlign("center");
        StringBuffer scriptSrc = new StringBuffer();
        tr line = new tr();
        if (ws.curTab.isDisplayed(false)) {
            int noFields = ws.curTab.getFieldCount();
            for (int i2 = 0; i2 < noFields; ++i2) {
                GridField field = ws.curTab.getField(i2);
                String columnName = field.getColumnName();
                Object oData = ws.curTab.getValue(field);
                if (!field.isDisplayed(true)) continue;
                if (!field.isSameLine()) {
                    line = new tr();
                }
                boolean hasDependents = ws.curTab.hasDependants(columnName);
                this.addField(wsc, line, field, oData, hasDependents);
                table2.addElement((Element)line);
                String dispLogic = field.getDisplayLogic();
                if (dispLogic == null || dispLogic.length() <= 0) continue;
                dispLogic = dispLogic.replace('\'', '\"');
                scriptSrc.append("document.").append(FORM_NAME).append(".").append(columnName).append(".displayLogic='").append(dispLogic).append("';\n");
            }
        }
        if (scriptSrc.length() > 0) {
            table2.addElement((Element)new script(scriptSrc.toString()));
        }
        int rowNo = ws.curTab.getCurrentRow();
        String statusDB = String.valueOf(rowNo + 1) + " # " + ws.curTab.getRowCount();
        return WWindow.createLayout(action, table2, wsc, ws, "", statusDB);
    }

    private WebDoc getMR_Form(String action, WebSessionCtx wsc, WWindowStatus ws) {
        log.fine("Tab=" + ws.curTab.getTabNo());
        int initRowNo = ws.curTab.getCurrentRow();
        table table2 = new table().setAlign("center");
        table2.setClass("MultiRow");
        table2.setBorder(1);
        table2.setCellSpacing(1);
        tr line = new tr();
        line.addElement((Element)new th().addElement(" "));
        if (!ws.curTab.isDisplayed(false)) {
            return WWindow.createLayout(action, table2, wsc, ws, "", "-");
        }
        int noFields = ws.curTab.getFieldCount();
        for (int colNo = 0; colNo < noFields; ++colNo) {
            GridField field = ws.curTab.getField(colNo);
            if (!field.isDisplayed(false)) continue;
            th th2 = new th();
            th2.addElement(field.getHeader());
            th2.setAbbr(field.getDescription());
            line.addElement((Element)th2);
        }
        table2.addElement((Element)new thead().addElement((Element)line));
        int lastRow = initRowNo + 12;
        lastRow = Math.min(lastRow, ws.curTab.getRowCount());
        for (int lineNo = initRowNo; lineNo < lastRow; ++lineNo) {
            ws.curTab.navigate(lineNo);
            line = new tr();
            button selector = new button();
            selector.addElement("&gt;");
            selector.setOnClick("document.WForm.PMRRowNo.value='" + lineNo + "'; submit();");
            line.addElement((Element)new td().addElement((Element)selector));
            for (int colNo = 0; colNo < noFields; ++colNo) {
                td td2 = new td();
                GridField field = ws.curTab.getField(colNo);
                if (!field.isDisplayed(false)) continue;
                Object data = ws.curTab.getValue(field.getColumnName());
                String info = null;
                if (data == null) {
                    info = "";
                } else {
                    int dt = field.getDisplayType();
                    switch (dt) {
                        case 15: {
                            info = wsc.dateFormat.format(data);
                            td2.setAlign("right");
                            break;
                        }
                        case 16: {
                            info = wsc.dateTimeFormat.format(data);
                            td2.setAlign("right");
                            break;
                        }
                        case 12: {
                            info = wsc.amountFormat.format(data);
                            td2.setAlign("right");
                            break;
                        }
                        case 22: 
                        case 37: {
                            info = wsc.numberFormat.format(data);
                            td2.setAlign("right");
                            break;
                        }
                        case 29: {
                            info = wsc.quantityFormat.format(data);
                            td2.setAlign("right");
                            break;
                        }
                        case 11: {
                            info = wsc.integerFormat.format(data);
                            td2.setAlign("right");
                            break;
                        }
                        case 20: {
                            info = Msg.getMsg(ws.ctx, data.toString());
                            break;
                        }
                        default: {
                            info = DisplayType.isLookup(dt) ? field.getLookup().getDisplay(data) : data.toString();
                        }
                    }
                }
                if (info == null || info.length() == 0) {
                    info = "&nbsp;";
                }
                td2.addElement(info);
                line.addElement((Element)td2);
            }
            table2.addElement((Element)line);
        }
        String statusDB = String.valueOf(initRowNo + 1) + "-" + String.valueOf(lastRow) + " # " + ws.curTab.getRowCount();
        return WWindow.createLayout(action, table2, wsc, ws, "", statusDB);
    }

    private static WebDoc createLayout(String action, table contentTable, WebSessionCtx wsc, WWindowStatus ws, String statusInfo, String statusDB) {
        form myForm = null;
        myForm = new form(action);
        myForm.setTarget("WWindow");
        myForm.setID("WWindow" + ws.mWindow.getAD_Window_ID());
        String AD_Language = Env.getAD_Language(ws.ctx);
        myForm.setName(FORM_NAME);
        myForm.addElement((Element)new input("hidden", P_Command, ""));
        myForm.addElement((Element)new input("hidden", P_MR_RowNo, ""));
        myForm.addElement((Element)new input("hidden", P_ChangedColumn, ""));
        String title = ws.mWindow.getName() + " - " + wsc.loginInfo;
        myForm.addElement((Element)new script("top.document.title='" + title + "';"));
        td toolbar = new td(null, "left", "middle", true);
        toolbar.addElement((Element)WWindow.createImage(AD_Language, "Ignore", "reset();", true, false));
        toolbar.addElement("&nbsp;");
        toolbar.addElement((Element)WWindow.createImage(AD_Language, "Help", "startPopup('WHelp?AD_Window_ID=" + ws.mWindow.getAD_Window_ID() + "');", true, false));
        toolbar.addElement((Element)WWindow.createImage(AD_Language, "New"));
        toolbar.addElement((Element)WWindow.createImage(AD_Language, "Delete", "if (confirm(deleteText)) submit();", true, false));
        toolbar.addElement((Element)WWindow.createImage(AD_Language, "Save"));
        toolbar.addElement("&nbsp;");
        toolbar.addElement((Element)WWindow.createImage(AD_Language, "Find"));
        toolbar.addElement((Element)WWindow.createImage(AD_Language, "Refresh"));
        toolbar.addElement((Element)WWindow.createImage(AD_Language, "Attachment", "startPopup('WAttachment');", ws.curTab.canHaveAttachment(), ws.curTab.hasAttachment()));
        toolbar.addElement((Element)WWindow.createImage(AD_Language, "Multi", null, true, !ws.curTab.isSingleRow()));
        toolbar.addElement("&nbsp;");
        toolbar.addElement((Element)WWindow.createImage(AD_Language, "History", null, ws.mWindow.isTransaction() && ws.curTab.getTabNo() == 0, true));
        toolbar.addElement("&nbsp;");
        boolean isFirst = ws.curTab.getCurrentRow() < 1;
        toolbar.addElement((Element)WWindow.createImage(AD_Language, "First", null, !isFirst, false));
        toolbar.addElement((Element)WWindow.createImage(AD_Language, "Previous", null, !isFirst, false));
        boolean isLast = ws.curTab.getCurrentRow() + 1 == ws.curTab.getRowCount();
        toolbar.addElement((Element)WWindow.createImage(AD_Language, "Next", null, !isLast, false));
        toolbar.addElement((Element)WWindow.createImage(AD_Language, "Last", null, !isLast, false));
        toolbar.addElement("&nbsp;");
        toolbar.addElement((Element)WWindow.createImage(AD_Language, "Report"));
        toolbar.addElement((Element)WWindow.createImage(AD_Language, "Print"));
        toolbar.addElement("&nbsp;");
        toolbar.addElement((Element)WWindow.createImage(AD_Language, "Exit"));
        td tabbar = new td("windowCenter", "left", "middle", false);
        tabbar.addElement((Element)new input("hidden", P_Tab, ""));
        for (int i2 = 0; i2 < ws.mWindow.getTabCount(); ++i2) {
            GridTab tab = ws.mWindow.getTab(i2);
            if (tab.isSortTab()) continue;
            big big2 = new big(tab.getName());
            if (ws.curTab.getTabNo() == i2) {
                big2.setID("tabSelected");
            } else {
                big2.setID("tab");
                big2.setOnClick("alert('" + tab.getName() + "');");
                big2.setOnClick("document.WForm.PTab.value='" + i2 + "';submit();");
            }
            if (tab.getDescription().length() > 0) {
                big2.setOnMouseOver("status='" + tab.getDescription() + "';return true;");
            }
            tabbar.addElement((Element)big2);
        }
        table topTable = new table("0", "0", "5", "100%", null);
        topTable.setID("WWindow.topTable");
        topTable.addElement((Element)new tr((Element)toolbar));
        topTable.addElement((Element)new tr((Element)tabbar));
        myForm.addElement((Element)topTable);
        myForm.addElement((Element)contentTable);
        table statusTable = new table("0", "0", "0", "100%", null);
        topTable.setID("WWindow.statusLine");
        tr statusLine = new tr();
        statusLine.addElement((Element)new td().setWidth("85%").setAlign("left").addElement(statusInfo));
        statusLine.addElement((Element)new td().setWidth("10%").setAlign("right").addElement((Element)new small(statusDB)));
        statusLine.addElement((Element)new td().setWidth("5%").setAlign("right").addElement((Element)WWindow.createImage(AD_Language, "Save")));
        statusTable.addElement((Element)statusLine).setClass("windowCenter");
        myForm.addElement((Element)statusTable);
        WebDoc doc = WWindow.createPage(ws);
        doc.getTable().addElement((Element)new tr().addElement((Element)new td(null, "center", "middle", true, (Element)myForm).setColSpan(2)));
        return doc;
    }

    private static WebDoc createPage(WWindowStatus ws) {
        WebDoc doc = WebDoc.createWindow(ws.mWindow.getName());
        doc.getBody().addElement((Element)new script("deleteText='" + Msg.getMsg(ws.ctx, "DeleteRecord?") + "';"));
        return doc;
    }

    private static img createImage(String AD_Language, String name, String js_command, boolean enabled, boolean pressed) {
        StringBuffer imgName = new StringBuffer(name);
        if (!enabled) {
            imgName.append("D");
        } else if (pressed) {
            imgName.append("X");
        }
        imgName.append("24.gif");
        img img2 = new img(WebEnv.getImageDirectory(imgName.toString()), name);
        if (enabled) {
            img2.setAlt(Msg.getMsg(AD_Language, name));
        }
        if (!pressed || !enabled) {
            img2.setID("imgButton");
        } else {
            img2.setID("imgButtonPressed");
        }
        if (js_command == null) {
            js_command = "submit();";
        }
        if (js_command.length() > 0 && enabled) {
            img2.setOnClick("document.WForm.PCommand.value='" + name + "';" + js_command);
        }
        return img2;
    }

    private static img createImage(String AD_Language, String name) {
        return WWindow.createImage(AD_Language, name, null, true, false);
    }

    private void addField(WebSessionCtx wsc, tr line, GridField field, Object oData, boolean hasDependents) {
        String columnName = field.getColumnName();
        boolean error = field.isErrorValue();
        if (error) {
            oData = field.getErrorValue();
        }
        int dt = field.getDisplayType();
        boolean hasCallout = field.getCallout().length() > 0;
        WebField wField = new WebField(wsc, columnName, field.getHeader(), field.getDescription(), dt, field.getFieldLength(), field.getDisplayLength(), field.isLongField(), !field.isEditable(true), field.isMandatory(false), error, hasDependents, hasCallout);
        line.addElement((Element)wField.getLabel()).addElement((Element)wField.getField(field.getLookup(), oData));
    }
}

