/*
 * Decompiled with CFR 0.152.
 */
package com.jware.util.mail;

import com.jware.util.mail.BaseMailData;
import com.jware.util.mail.MXLoockup;
import com.jware.util.mail.MailStatus;
import java.io.UnsupportedEncodingException;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BaseMailSender {
    private final Log log = LogFactory.getLog(this.getClass());
    private List mailDataList = null;
    private Map domainStatusMap = null;
    private String currentDomain = null;
    private boolean smtpDirectFlg = true;
    private boolean shiftJISFlg = true;
    private boolean popBeforeSmtp = false;
    private String clientOsEncode = "UTF-8";
    private String serverOsEncode = "UTF-8";
    private String bccMailAdddress = "";
    private String smtpServerAddress = null;
    private String popServerAddress = null;
    private String popAccessUserName = null;
    private String popAccessPassword = null;
    private String smtpEncode = "iso-2022-jp";
    private String fileEncodingType = null;
    private String fileDistination = null;
    private boolean ccBccNotSendFlg = false;
    private int limitOnSession = -1;
    private int sendMailCount = 0;

    public int execute() throws UnsupportedEncodingException, AddressException {
        String currentHost;
        if (this.mailDataList == null) {
            return -1;
        }
        MailStatus mailStatus = null;
        if (this.domainStatusMap != null) {
            mailStatus = (MailStatus)this.domainStatusMap.get(this.currentDomain);
        }
        if (mailStatus == null) {
            mailStatus = new MailStatus();
            mailStatus.setMailDomain(this.currentDomain);
            mailStatus.setMailHost(MXLoockup.lookupHost(this.currentDomain));
            mailStatus.setStartTime(Calendar.getInstance().getTime());
        }
        if ((currentHost = mailStatus.getMailHost()) == null) {
            currentHost = this.smtpServerAddress;
        }
        if (this.smtpDirectFlg && currentHost != null) {
            this.smtpServerAddress = currentHost;
        }
        Properties props = new Properties();
        props.put("mail.smtp.host", this.smtpServerAddress);
        Session session = Session.getInstance((Properties)props, null);
        this.sendMailCount = 0;
        for (int mailIndex = this.mailDataList.size() - 1; mailIndex >= 0; --mailIndex) {
            BaseMailData maildata = (BaseMailData)this.mailDataList.get(mailIndex);
            String from = maildata.getFrom();
            String subject = maildata.getSubject();
            if (this.shiftJISFlg) {
                subject = this.toJIS(maildata.getSubject());
            }
            subject = subject == null ? "" : new String(subject.getBytes(this.clientOsEncode), this.serverOsEncode);
            String content = null;
            String address = null;
            List tos = maildata.getToList();
            if (tos != null && tos.size() > 0) {
                address = (String)tos.get(0);
            }
            if (address != null && maildata.isInsertTitleFlg()) {
                content = maildata.getContent(address);
                if (this.shiftJISFlg) {
                    content = this.toJIS(maildata.getContent(address));
                }
            } else {
                content = maildata.getContent();
                if (this.shiftJISFlg) {
                    content = this.toJIS(maildata.getContent());
                }
            }
            content = content == null ? "" : new String(content.getBytes(this.clientOsEncode), this.serverOsEncode);
            InternetAddress[] toList = new InternetAddress[]{};
            if (tos != null && tos.size() > 0) {
                toList = new InternetAddress[tos.size()];
                for (int i2 = 0; i2 < tos.size(); ++i2) {
                    try {
                        toList[i2] = new InternetAddress((String)tos.get(i2));
                        continue;
                    }
                    catch (AddressException e1) {
                        maildata.setUnexistAddress((String)tos.get(i2));
                        throw new AddressException(e1.toString());
                    }
                }
            }
            List ccs = maildata.getCcList();
            InternetAddress[] ccList = new InternetAddress[]{};
            if (ccs != null && ccs.size() > 0) {
                ccList = new InternetAddress[ccs.size()];
                for (int i3 = 0; i3 < ccs.size(); ++i3) {
                    try {
                        ccList[i3] = new InternetAddress((String)ccs.get(i3));
                        continue;
                    }
                    catch (AddressException e1) {
                        maildata.setUnexistAddress((String)tos.get(i3));
                        throw new AddressException(e1.toString());
                    }
                }
            }
            InternetAddress[] bccList = new InternetAddress[]{};
            if (this.bccMailAdddress != null && this.bccMailAdddress.length() > 0) {
                bccList = new InternetAddress[]{new InternetAddress(this.bccMailAdddress)};
            }
            MimeMessage message = null;
            try {
                if (!this.smtpDirectFlg && this.popBeforeSmtp) {
                    Store store = session.getStore("pop3");
                    store.connect(this.popServerAddress, -1, this.popAccessUserName, this.popAccessPassword);
                }
                message = new MimeMessage(session);
                Calendar calendar = Calendar.getInstance();
                message.setSentDate(calendar.getTime());
                message.setFrom((Address)new InternetAddress(from));
                message.setRecipients(Message.RecipientType.CC, (Address[])ccList);
                if (bccList.length > 0) {
                    message.setRecipients(Message.RecipientType.BCC, (Address[])bccList);
                }
                message.setSubject(MimeUtility.encodeWord((String)subject, (String)this.smtpEncode, (String)"B"));
                Map attachments = null;
                attachments = address != null && maildata.isInsertTitleFlg() ? maildata.getAttachments(address) : maildata.getAttachments();
                if (!attachments.isEmpty()) {
                    MimeMultipart mp = null;
                    mp = "multipart/alternative".equals(maildata.getMailType()) ? new MimeMultipart("alternative") : ("multipart/related".equals(maildata.getMailType()) ? new MimeMultipart("related") : new MimeMultipart());
                    MimeBodyPart mbp1 = new MimeBodyPart();
                    mbp1.setText(content, this.smtpEncode);
                    mbp1.setHeader("Content-Type", "text/plain;charset=" + this.smtpEncode);
                    mp.addBodyPart((BodyPart)mbp1);
                    for (String fileName : attachments.keySet()) {
                        MimeBodyPart mbp2;
                        Object attachBody = attachments.get(fileName);
                        if (attachBody != null) {
                            mbp2 = new MimeBodyPart();
                            mbp2.setText(attachBody.toString(), this.smtpEncode);
                            mbp2.setHeader("Content-Type", "text/html;charset=" + this.smtpEncode);
                            mp.addBodyPart((BodyPart)mbp2);
                            continue;
                        }
                        fileName = new String(fileName.getBytes(this.fileEncodingType), this.smtpEncode);
                        mbp2 = new MimeBodyPart();
                        FileDataSource fds = new FileDataSource(this.fileDistination + fileName);
                        mbp2.setDataHandler(new DataHandler((DataSource)fds));
                        mbp2.setFileName(MimeUtility.encodeWord((String)fds.getName()));
                        mp.addBodyPart((BodyPart)mbp2);
                    }
                    message.setContent((Multipart)mp);
                } else {
                    message.setText(content, this.smtpEncode);
                }
                if (null == maildata.getMailType() || "".equals(maildata.getMailType())) {
                    message.setHeader("Content-Type", "text/html;charset=" + this.smtpEncode);
                } else if ("text".equals(maildata.getMailType())) {
                    message.setHeader("Content-Type", "text/plain;charset=" + this.smtpEncode);
                } else if ("html".equals(maildata.getMailType())) {
                    message.setHeader("Content-Type", "text/html;charset=" + this.smtpEncode);
                }
                message.saveChanges();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            Transport transport = null;
            try {
                int i4;
                transport = session.getTransport("smtp");
                transport.connect();
                for (i4 = 0; i4 < toList.length; ++i4) {
                    block63: {
                        if (mailStatus.isAbnormalFlg()) {
                            if (this.sendMailCount >= mailStatus.getMaxSendable() && mailStatus.getLimitInterval() != 0) {
                                return mailStatus.getLimitInterval();
                            }
                            if (i4 > 0 && this.sendMailCount > 0 && mailStatus.getMaxSendable() > 0 && this.sendMailCount % mailStatus.getMaxSendable() == 0) {
                                transport.close();
                                transport = session.getTransport("smtp");
                                transport.connect();
                            }
                        } else if (i4 > 0 && this.limitOnSession > 0 && i4 % this.limitOnSession == 0) {
                            transport.close();
                            transport = session.getTransport("smtp");
                            transport.connect();
                        }
                        InternetAddress[] to = new InternetAddress[]{toList[i4]};
                        if ("OK".equalsIgnoreCase(mailStatus.getStatus(toList[i4].getAddress()))) continue;
                        try {
                            message.setRecipients(Message.RecipientType.TO, (Address[])toList);
                            transport.sendMessage((Message)message, (Address[])to);
                            mailStatus.setStatus(toList[i4].getAddress(), "OK");
                            mailStatus.setDirty(true);
                            if (this.log.isDebugEnabled()) {
                                this.log.debug((Object)(" Mail Send success ( to address = " + toList[i4].getAddress() + " )"));
                            }
                        }
                        catch (Exception e) {
                            mailStatus.setStatus(toList[i4].getAddress(), "FAIL");
                            mailStatus.setSendFailed(mailStatus.getSendFailed() + 1);
                            mailStatus.setDirty(true);
                            if (!this.log.isDebugEnabled()) break block63;
                            this.log.debug((Object)(" Mail Send Failed ( to address = " + toList[i4].getAddress() + " )"));
                            this.log.debug((Object)e.toString());
                        }
                    }
                    ++this.sendMailCount;
                }
                if (!this.ccBccNotSendFlg) {
                    for (i4 = 0; i4 < ccList.length; ++i4) {
                        block64: {
                            if (mailStatus.isAbnormalFlg()) {
                                if (this.sendMailCount >= mailStatus.getMaxSendable() && mailStatus.getLimitInterval() != 0) {
                                    return mailStatus.getLimitInterval();
                                }
                                if (this.sendMailCount > 0 && mailStatus.getMaxSendable() > 0 && this.sendMailCount % mailStatus.getMaxSendable() == 0) {
                                    transport.close();
                                    transport = session.getTransport("smtp");
                                    transport.connect();
                                }
                            } else if (this.limitOnSession > 0 && i4 % this.limitOnSession == 0) {
                                transport.close();
                                transport = session.getTransport("smtp");
                                transport.connect();
                            }
                            InternetAddress[] cc = new InternetAddress[]{ccList[i4]};
                            if ("OK".equalsIgnoreCase(mailStatus.getStatus(ccList[i4].getAddress()))) continue;
                            try {
                                message.setRecipient(Message.RecipientType.CC, (Address)ccList[i4]);
                                transport.sendMessage((Message)message, (Address[])cc);
                                mailStatus.setStatus(ccList[i4].getAddress(), "OK");
                                mailStatus.setDirty(true);
                            }
                            catch (Exception e) {
                                mailStatus.setStatus(ccList[i4].getAddress(), "FAIL");
                                mailStatus.setSendFailed(mailStatus.getSendFailed() + 1);
                                mailStatus.setDirty(true);
                                if (!this.log.isDebugEnabled()) break block64;
                                this.log.debug((Object)(" Mail Send Failed ( cc address = " + ccList[i4].getAddress() + " )"));
                                this.log.debug((Object)e.toString());
                            }
                        }
                        ++this.sendMailCount;
                    }
                    for (i4 = 0; i4 < bccList.length; ++i4) {
                        block65: {
                            if (mailStatus.isAbnormalFlg()) {
                                if (this.sendMailCount >= mailStatus.getMaxSendable() && mailStatus.getLimitInterval() != 0) {
                                    return mailStatus.getLimitInterval();
                                }
                                if (this.sendMailCount > 0 && mailStatus.getMaxSendable() > 0 && this.sendMailCount % mailStatus.getMaxSendable() == 0) {
                                    transport.close();
                                    transport = session.getTransport("smtp");
                                    transport.connect();
                                }
                            } else if (this.limitOnSession > 0 && i4 % this.limitOnSession == 0) {
                                transport.close();
                                transport = session.getTransport("smtp");
                                transport.connect();
                            }
                            InternetAddress[] bcc = new InternetAddress[]{bccList[i4]};
                            if ("OK".equalsIgnoreCase(mailStatus.getStatus(bccList[i4].getAddress()))) continue;
                            try {
                                message.setRecipient(Message.RecipientType.BCC, (Address)bccList[i4]);
                                transport.sendMessage((Message)message, (Address[])bcc);
                                mailStatus.setStatus(bccList[i4].getAddress(), "OK");
                                mailStatus.setDirty(true);
                            }
                            catch (Exception e) {
                                mailStatus.setStatus(bccList[i4].getAddress(), "FAIL");
                                mailStatus.setSendFailed(mailStatus.getSendFailed() + 1);
                                mailStatus.setDirty(true);
                                if (!this.log.isDebugEnabled()) break block65;
                                this.log.debug((Object)(" Mail Send Failed ( bcc address = " + bccList[i4].getAddress() + " )"));
                                this.log.debug((Object)e.toString());
                            }
                        }
                        ++this.sendMailCount;
                    }
                }
                transport.close();
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
            this.mailDataList.remove(mailIndex);
        }
        mailStatus.setRetryCount(mailStatus.getRetryCount() + 1);
        mailStatus.setCompleteFlg(true);
        mailStatus.setEndTime(Calendar.getInstance().getTime());
        if (this.domainStatusMap != null) {
            this.domainStatusMap.put(this.currentDomain, mailStatus);
        }
        return 0;
    }

    private String toJIS(String s) {
        if (s == null) {
            return s;
        }
        StringBuffer sb = new StringBuffer();
        for (int i2 = 0; i2 < s.length(); ++i2) {
            char c = s.charAt(i2);
            switch (c) {
                case '\uff3c': {
                    c = '\\';
                    break;
                }
                case '\uff5e': {
                    c = '\u301c';
                    break;
                }
                case '\u2225': {
                    c = '\u2016';
                    break;
                }
                case '\uff0d': {
                    c = '\u2212';
                    break;
                }
                case '\uffe0': {
                    c = '\u00a2';
                    break;
                }
                case '\uffe1': {
                    c = '\u00a3';
                    break;
                }
                case '\uffe2': {
                    c = '\u00ac';
                }
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public String getBccMailAdddress() {
        return this.bccMailAdddress;
    }

    public void setBccMailAdddress(String bccMailAdddress) {
        this.bccMailAdddress = bccMailAdddress;
    }

    public String getClientOsEncode() {
        return this.clientOsEncode;
    }

    public void setClientOsEncode(String clientOsEncode) {
        this.clientOsEncode = clientOsEncode;
    }

    public String getFileDistination() {
        return this.fileDistination;
    }

    public void setFileDistination(String fileDistination) {
        this.fileDistination = fileDistination;
    }

    public String getFileEncodingType() {
        return this.fileEncodingType;
    }

    public void setFileEncodingType(String fileEncodingType) {
        this.fileEncodingType = fileEncodingType;
    }

    public List getMailDataList() {
        return this.mailDataList;
    }

    public void setMailDataList(List mailDataList) {
        this.mailDataList = mailDataList;
    }

    public String getPopAccessPassword() {
        return this.popAccessPassword;
    }

    public void setPopAccessPassword(String popAccessPassword) {
        this.popAccessPassword = popAccessPassword;
    }

    public String getPopAccessUserName() {
        return this.popAccessUserName;
    }

    public void setPopAccessUserName(String popAccessUserName) {
        this.popAccessUserName = popAccessUserName;
    }

    public boolean isPopBeforeSmtp() {
        return this.popBeforeSmtp;
    }

    public void setPopBeforeSmtp(boolean popBeforeSmtp) {
        this.popBeforeSmtp = popBeforeSmtp;
    }

    public String getPopServerAddress() {
        return this.popServerAddress;
    }

    public void setPopServerAddress(String popServerAddress) {
        this.popServerAddress = popServerAddress;
    }

    public String getServerOsEncode() {
        return this.serverOsEncode;
    }

    public void setServerOsEncode(String serverOsEncode) {
        this.serverOsEncode = serverOsEncode;
    }

    public boolean isShiftJISFlg() {
        return this.shiftJISFlg;
    }

    public void setShiftJISFlg(boolean shiftJISFlg) {
        this.shiftJISFlg = shiftJISFlg;
    }

    public String getSmtpEncode() {
        return this.smtpEncode;
    }

    public void setSmtpEncode(String smtpEncode) {
        this.smtpEncode = smtpEncode;
    }

    public String getSmtpServerAddress() {
        return this.smtpServerAddress;
    }

    public void setSmtpServerAddress(String smtpServerAddress) {
        this.smtpServerAddress = smtpServerAddress;
    }

    public boolean isSmtpDirectFlg() {
        return this.smtpDirectFlg;
    }

    public void setSmtpDirectFlg(boolean smtpDirectFlg) {
        this.smtpDirectFlg = smtpDirectFlg;
    }

    public boolean isCcBccNotSendFlg() {
        return this.ccBccNotSendFlg;
    }

    public void setCcBccNotSendFlg(boolean ccBccNotSendFlg) {
        this.ccBccNotSendFlg = ccBccNotSendFlg;
    }

    public int getLimitOnSession() {
        return this.limitOnSession;
    }

    public void setLimitOnSession(int limitOnSession) {
        this.limitOnSession = limitOnSession;
    }

    public String getCurrentDomain() {
        return this.currentDomain;
    }

    public void setCurrentDomain(String currentDomain) {
        this.currentDomain = currentDomain;
    }

    public Map getDomainStatusMap() {
        return this.domainStatusMap;
    }

    public void setDomainStatusMap(Map domainStatusMap) {
        this.domainStatusMap = domainStatusMap;
    }

    public MailStatus getCurrentMailStatus() {
        MailStatus mailStatus = null;
        if (this.domainStatusMap != null) {
            mailStatus = (MailStatus)this.domainStatusMap.get(this.currentDomain);
        }
        return mailStatus;
    }
}

