/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jcs.utils.servlet.session;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jcs.utils.servlet.session.DistSession;
import org.apache.jcs.utils.servlet.session.DistSessionGC;
import org.apache.jcs.utils.servlet.session.DistSessionPoolManager;
import org.apache.jcs.utils.servlet.session.ISessionConstants;
import org.apache.jcs.utils.servlet.session.MetaHttpSession;

public class DistSessionTracker
implements ISessionConstants {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$jcs$utils$servlet$session$DistSessionTracker == null ? (class$org$apache$jcs$utils$servlet$session$DistSessionTracker = DistSessionTracker.class$("org.apache.jcs.utils.servlet.session.DistSessionTracker")) : class$org$apache$jcs$utils$servlet$session$DistSessionTracker));
    public static final String SESSION_COOKIE_NAME = "SESSION_ID";
    private static DistSessionPoolManager dsMgr = new DistSessionPoolManager(200);
    public static DistSessionTracker instance;
    static int clients;
    private static transient Set sessIdSet;
    private static transient DistSessionGC gc;
    static /* synthetic */ Class class$org$apache$jcs$utils$servlet$session$DistSessionTracker;

    private DistSessionTracker() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DistSessionTracker getInstance() {
        if (instance == null) {
            Class clazz = class$org$apache$jcs$utils$servlet$session$DistSessionTracker == null ? (class$org$apache$jcs$utils$servlet$session$DistSessionTracker = DistSessionTracker.class$("org.apache.jcs.utils.servlet.session.DistSessionTracker")) : class$org$apache$jcs$utils$servlet$session$DistSessionTracker;
            synchronized (clazz) {
                if (instance == null) {
                    instance = new DistSessionTracker();
                }
            }
        }
        ++clients;
        return instance;
    }

    public MetaHttpSession getSession(HttpServletRequest req) {
        return this.getSession(false, req, null);
    }

    public MetaHttpSession getSession(boolean create, HttpServletRequest req, HttpServletResponse res) {
        MetaHttpSession ses = this.getDistSession(req);
        return !ses.valid() && create ? this.createDistSession(req, res) : ses;
    }

    private MetaHttpSession createDistSession(HttpServletRequest req, HttpServletResponse res) {
        String session_id = null;
        DistSession sess = new DistSession();
        try {
            sess.initNew();
            session_id = sess.getId();
            Cookie c = new Cookie(SESSION_COOKIE_NAME, session_id);
            c.setPath("/");
            c.setMaxAge(-1);
            res.addCookie(c);
            if (log.isInfoEnabled()) {
                log.info((Object)("created cookie session with session=" + sess));
            }
            if (!sessIdSet.add(session_id)) {
                log.error((Object)("Session " + sess + " already exist when creating a session"));
            }
            gc.notifySession();
        }
        catch (Exception e) {
            log.error((Object)e);
            return new MetaHttpSession(session_id, null);
        }
        return new MetaHttpSession(session_id, sess);
    }

    private MetaHttpSession getDistSession(HttpServletRequest req) {
        int max;
        log.info((Object)"in getSession");
        DistSession sess = null;
        String session_id = this.getRequestedSessionId(req);
        if (session_id == null) {
            log.info((Object)"no cookie found");
            return new MetaHttpSession(null, null);
        }
        sess = new DistSession();
        if (!sess.init(session_id)) {
            return new MetaHttpSession(session_id, null);
        }
        long idleTime = System.currentTimeMillis() - sess.getLastAccessedTime();
        if (idleTime > (long)((max = sess.getMaxInactiveInterval()) / 2)) {
            if (idleTime < (long)max) {
                sess.access();
            } else {
                sessIdSet.remove(session_id);
                sess.invalidate();
                return new MetaHttpSession(session_id, null);
            }
        }
        return new MetaHttpSession(session_id, sess);
    }

    public String getRequestedSessionId(HttpServletRequest req) {
        String session_id = null;
        Cookie[] cookies = req.getCookies();
        if (cookies != null) {
            int i = 0;
            while (i < cookies.length) {
                String tempName = cookies[i].getName();
                if (tempName.equals(SESSION_COOKIE_NAME)) {
                    session_id = cookies[i].getValue();
                }
                ++i;
            }
        }
        return session_id;
    }

    public boolean isRequestedSessionIdValid(HttpServletRequest req) {
        DistSession sess = new DistSession();
        return sess.init(this.getRequestedSessionId(req));
    }

    public void release() {
        --clients;
    }

    public String getStats() {
        String stats = "Number of clients: " + clients;
        return stats;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        sessIdSet = Collections.synchronizedSet(new HashSet());
        gc = new DistSessionGC(sessIdSet);
        gc.setDaemon(true);
        gc.start();
    }
}

