/*
 * Decompiled with CFR 0.152.
 */
package org.apache.taglibs.standard.lang.jstl;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.taglibs.standard.lang.jstl.Coercions;
import org.apache.taglibs.standard.lang.jstl.Constants;
import org.apache.taglibs.standard.lang.jstl.ELException;
import org.apache.taglibs.standard.lang.jstl.Expression;
import org.apache.taglibs.standard.lang.jstl.Logger;
import org.apache.taglibs.standard.lang.jstl.VariableResolver;

public class FunctionInvocation
extends Expression {
    private String functionName;
    private List argumentList;

    public String getFunctionName() {
        return this.functionName;
    }

    public void setFunctionName(String f2) {
        this.functionName = f2;
    }

    public List getArgumentList() {
        return this.argumentList;
    }

    public void setArgumentList(List l) {
        this.argumentList = l;
    }

    public FunctionInvocation(String functionName, List argumentList) {
        this.functionName = functionName;
        this.argumentList = argumentList;
    }

    public String getExpressionString() {
        StringBuffer b2 = new StringBuffer();
        b2.append(this.functionName);
        b2.append("(");
        Iterator i2 = this.argumentList.iterator();
        while (i2.hasNext()) {
            b2.append(((Expression)i2.next()).getExpressionString());
            if (!i2.hasNext()) continue;
            b2.append(", ");
        }
        b2.append(")");
        return b2.toString();
    }

    public Object evaluate(Object pContext, VariableResolver pResolver, Map functions, String defaultPrefix, Logger pLogger) throws ELException {
        Class<?>[] params;
        Method target;
        String functionName;
        if (functions == null) {
            pLogger.logError(Constants.UNKNOWN_FUNCTION, this.functionName);
        }
        if ((functionName = this.functionName).indexOf(":") == -1) {
            if (defaultPrefix == null) {
                pLogger.logError(Constants.UNKNOWN_FUNCTION, functionName);
            }
            functionName = defaultPrefix + ":" + functionName;
        }
        if ((target = (Method)functions.get(functionName)) == null) {
            pLogger.logError(Constants.UNKNOWN_FUNCTION, functionName);
        }
        if ((params = target.getParameterTypes()).length != this.argumentList.size()) {
            pLogger.logError(Constants.INAPPROPRIATE_FUNCTION_ARG_COUNT, new Integer(params.length), (Object)new Integer(this.argumentList.size()));
        }
        Object[] arguments = new Object[this.argumentList.size()];
        for (int i2 = 0; i2 < params.length; ++i2) {
            arguments[i2] = ((Expression)this.argumentList.get(i2)).evaluate(pContext, pResolver, functions, defaultPrefix, pLogger);
            arguments[i2] = Coercions.coerce(arguments[i2], params[i2], pLogger);
        }
        try {
            return target.invoke(null, arguments);
        }
        catch (InvocationTargetException ex) {
            pLogger.logError(Constants.FUNCTION_INVOCATION_ERROR, ex.getTargetException(), (Object)functionName);
            return null;
        }
        catch (Exception ex) {
            pLogger.logError(Constants.FUNCTION_INVOCATION_ERROR, ex, (Object)functionName);
            return null;
        }
    }
}

