/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ecs;

import java.text.StringCharacterIterator;
import org.apache.ecs.ConcreteElement;
import org.apache.ecs.Element;
import org.apache.ecs.Printable;

public class StringElement
extends ConcreteElement
implements Printable {
    public StringElement() {
    }

    public StringElement(String string) {
        if (string != null) {
            this.setTagText(string);
        } else {
            this.setTagText("");
        }
    }

    public StringElement(Element element) {
        this.addElement(element);
    }

    private StringElement append(String string) {
        this.setTagText(this.getTagText() + string);
        return this;
    }

    public StringElement reset() {
        this.setTagText("");
        return this;
    }

    public Element setTagText(String text) {
        if (text != null && text.length() > 0) {
            StringCharacterIterator sci = new StringCharacterIterator(text);
            char c2 = sci.first();
            while (c2 != '\uffff') {
                char ii = c2;
                if (ii > '\u00ff') {
                    this.setFilterState(true);
                    break;
                }
                c2 = sci.next();
            }
        }
        return super.setTagText(text);
    }

    public Element setFilterState(boolean filter_state) {
        if (!this.getFilterState()) {
            return super.setFilterState(filter_state);
        }
        return this;
    }

    public StringElement addElement(String hashcode, Element element) {
        this.addElementToRegistry(hashcode, element);
        return this;
    }

    public StringElement addElement(String hashcode, String element) {
        StringElement se = new StringElement(element);
        se.setFilterState(this.getFilterState());
        se.setFilter(this.getFilter());
        this.addElementToRegistry(hashcode, se);
        return this;
    }

    public StringElement addElement(String element) {
        this.addElement(Integer.toString(element.hashCode()), element);
        return this;
    }

    public StringElement addElement(Element element) {
        this.addElementToRegistry(element);
        return this;
    }

    public StringElement removeElement(String hashcode) {
        this.removeElementFromRegistry(hashcode);
        return this;
    }

    protected String createStartTag() {
        return "";
    }

    protected String createEndTag() {
        return "";
    }
}

