/*
 * Decompiled with CFR 0.152.
 */
package dori.jasper.engine.export;

import com.lowagie.text.Chunk;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Font;
import com.lowagie.text.Image;
import com.lowagie.text.Phrase;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.ColumnText;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfWriter;
import dori.jasper.engine.JRAbstractExporter;
import dori.jasper.engine.JRException;
import dori.jasper.engine.JRExporterParameter;
import dori.jasper.engine.JRFont;
import dori.jasper.engine.JRPrintElement;
import dori.jasper.engine.JRPrintEllipse;
import dori.jasper.engine.JRPrintImage;
import dori.jasper.engine.JRPrintLine;
import dori.jasper.engine.JRPrintPage;
import dori.jasper.engine.JRPrintRectangle;
import dori.jasper.engine.JRPrintText;
import dori.jasper.engine.JRReportFont;
import dori.jasper.engine.JasperPrint;
import dori.jasper.engine.design.JRDesignReportFont;
import dori.jasper.engine.util.JRImageLoader;
import dori.jasper.engine.util.JRLoader;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JRPdfExporter
extends JRAbstractExporter {
    private static Log log = LogFactory.getLog((Class)(class$dori$jasper$engine$export$JRPdfExporter == null ? (class$dori$jasper$engine$export$JRPdfExporter = JRPdfExporter.class$("dori.jasper.engine.export.JRPdfExporter")) : class$dori$jasper$engine$export$JRPdfExporter));
    private JasperPrint jasperPrint = null;
    private Document document = null;
    private PdfContentByte pdfContentByte = null;
    private Document imageTesterDocument = null;
    private PdfContentByte imageTesterPdfContentByte = null;
    private JRReportFont defaultFont = null;
    private Map loadedFontsMap = null;
    static /* synthetic */ Class class$dori$jasper$engine$export$JRPdfExporter;

    private JRReportFont getDefaultFont() {
        if (this.defaultFont == null) {
            this.defaultFont = this.jasperPrint.getDefaultFont();
            if (this.defaultFont == null) {
                this.defaultFont = new JRDesignReportFont();
            }
        }
        return this.defaultFont;
    }

    public void exportReport() throws JRException {
        this.jasperPrint = (JasperPrint)this.parameters.get(JRExporterParameter.JASPER_PRINT);
        if (this.jasperPrint == null) {
            InputStream is = (InputStream)this.parameters.get(JRExporterParameter.INPUT_STREAM);
            if (is != null) {
                this.jasperPrint = (JasperPrint)JRLoader.loadObject(is);
            } else {
                URL url = (URL)this.parameters.get(JRExporterParameter.INPUT_URL);
                if (url != null) {
                    this.jasperPrint = (JasperPrint)JRLoader.loadObject(url);
                } else {
                    File file = (File)this.parameters.get(JRExporterParameter.INPUT_FILE);
                    if (file != null) {
                        this.jasperPrint = (JasperPrint)JRLoader.loadObject(file);
                    } else {
                        String fileName = (String)this.parameters.get(JRExporterParameter.INPUT_FILE_NAME);
                        if (fileName != null) {
                            this.jasperPrint = (JasperPrint)JRLoader.loadObject(fileName);
                        } else {
                            throw new JRException("No input source supplied to the exporter.");
                        }
                    }
                }
            }
        }
        this.loadedFontsMap = new HashMap();
        OutputStream os = (OutputStream)this.parameters.get(JRExporterParameter.OUTPUT_STREAM);
        if (os != null) {
            this.exportReportToStream(os);
        } else {
            File destFile = (File)this.parameters.get(JRExporterParameter.OUTPUT_FILE);
            if (destFile == null) {
                String fileName = (String)this.parameters.get(JRExporterParameter.OUTPUT_FILE_NAME);
                if (fileName != null) {
                    destFile = new File(fileName);
                } else {
                    throw new JRException("No output specified for the exporter.");
                }
            }
            try {
                os = new FileOutputStream(destFile);
                this.exportReportToStream(os);
                os.flush();
                os.close();
            }
            catch (IOException e) {
                throw new JRException("Error trying to export to file : " + destFile, e);
            }
        }
    }

    private void exportReportToStream(OutputStream os) throws JRException {
        this.document = new Document(new Rectangle((float)this.jasperPrint.getPageWidth(), (float)this.jasperPrint.getPageHeight()));
        this.imageTesterDocument = new Document(new Rectangle(10.0f, 10.0f));
        try {
            PdfWriter pdfWriter = PdfWriter.getInstance((Document)this.document, (OutputStream)os);
            pdfWriter.setCloseStream(false);
            this.document.open();
            PdfWriter imageTesterPdfWriter = PdfWriter.getInstance((Document)this.imageTesterDocument, (OutputStream)new ByteArrayOutputStream());
            this.imageTesterDocument.open();
            this.imageTesterDocument.newPage();
            this.imageTesterPdfContentByte = imageTesterPdfWriter.getDirectContent();
            this.imageTesterPdfContentByte.setLiteral("\n");
            List pages = this.jasperPrint.getPages();
            if (pages != null && pages.size() > 0) {
                Chunk chunk = null;
                ColumnText colText = null;
                JRPrintPage page = null;
                int i = 1;
                Iterator it = pages.iterator();
                while (it.hasNext()) {
                    if (Thread.currentThread().isInterrupted()) {
                        throw new JRException("Current thread interrupted.");
                    }
                    page = (JRPrintPage)it.next();
                    this.document.newPage();
                    this.pdfContentByte = pdfWriter.getDirectContent();
                    this.pdfContentByte.setLineCap(2);
                    chunk = new Chunk(" ");
                    chunk.setLocalDestination("JR_PAGE_ANCHOR_" + i);
                    colText = new ColumnText(this.pdfContentByte);
                    colText.setSimpleColumn(new Phrase(chunk), 0.0f, (float)this.jasperPrint.getPageHeight(), 1.0f, 1.0f, 0.0f, 0);
                    colText.go();
                    this.exportPage(page);
                    ++i;
                }
            }
            this.document.close();
            this.imageTesterDocument.close();
        }
        catch (DocumentException e) {
            throw new JRException("PDF Document error : " + this.jasperPrint.getName(), e);
        }
        catch (IOException e) {
            throw new JRException("Error generating PDF report : " + this.jasperPrint.getName(), e);
        }
    }

    private void exportPage(JRPrintPage page) throws JRException, DocumentException, IOException {
        JRPrintElement element = null;
        List elements = page.getElements();
        if (elements != null && elements.size() > 0) {
            Iterator it = elements.iterator();
            while (it.hasNext()) {
                element = (JRPrintElement)it.next();
                if (element instanceof JRPrintLine) {
                    this.exportLine((JRPrintLine)element);
                    continue;
                }
                if (element instanceof JRPrintRectangle) {
                    this.exportRectangle((JRPrintRectangle)element);
                    continue;
                }
                if (element instanceof JRPrintEllipse) {
                    this.exportEllipse((JRPrintEllipse)element);
                    continue;
                }
                if (element instanceof JRPrintImage) {
                    this.exportImage((JRPrintImage)element);
                    continue;
                }
                if (!(element instanceof JRPrintText)) continue;
                this.exportText((JRPrintText)element);
            }
        }
    }

    private void exportLine(JRPrintLine line) {
        if (line.getPen() != 0) {
            this.pdfContentByte.setRGBColorStroke(line.getForecolor().getRed(), line.getForecolor().getGreen(), line.getForecolor().getBlue());
            float borderCorrection = 0.0f;
            switch (line.getPen()) {
                case 4: {
                    borderCorrection = 0.0f;
                    this.pdfContentByte.setLineWidth(1.0f);
                    this.pdfContentByte.setLineDash(5.0f, 3.0f, 0.0f);
                    break;
                }
                case 3: {
                    borderCorrection = 0.0f;
                    this.pdfContentByte.setLineWidth(4.0f);
                    this.pdfContentByte.setLineDash(0.0f);
                    break;
                }
                case 2: {
                    borderCorrection = 0.0f;
                    this.pdfContentByte.setLineWidth(2.0f);
                    this.pdfContentByte.setLineDash(0.0f);
                    break;
                }
                case 0: {
                    break;
                }
                case 5: {
                    borderCorrection = 0.25f;
                    this.pdfContentByte.setLineWidth(0.5f);
                    this.pdfContentByte.setLineDash(0.0f);
                    break;
                }
                default: {
                    borderCorrection = 0.0f;
                    this.pdfContentByte.setLineWidth(1.0f);
                    this.pdfContentByte.setLineDash(0.0f);
                }
            }
            int x1 = 0;
            int y1 = 0;
            int x2 = 0;
            int y2 = 0;
            if (line.getDirection() == 1) {
                if (line.getWidth() > 1) {
                    if (line.getHeight() > 1) {
                        x1 = -1;
                        y1 = 1;
                        x2 = 1;
                        y2 = -1;
                    } else {
                        x1 = -1;
                        y1 = 1;
                        x2 = 1;
                        y2 = 1;
                    }
                } else if (line.getHeight() > 1) {
                    x1 = -1;
                    y1 = 1;
                    x2 = -1;
                    y2 = -1;
                } else {
                    x1 = -1;
                    y1 = 1;
                    x2 = -1;
                    y2 = 1;
                }
                this.pdfContentByte.moveTo((float)line.getX() + (float)x1 * borderCorrection, (float)(this.jasperPrint.getPageHeight() - line.getY()) + (float)y1 * borderCorrection);
                this.pdfContentByte.lineTo((float)(line.getX() + line.getWidth()) + (float)x2 * borderCorrection - 1.0f, (float)(this.jasperPrint.getPageHeight() - line.getY() - line.getHeight()) + (float)y2 * borderCorrection + 1.0f);
            } else {
                if (line.getWidth() > 1) {
                    if (line.getHeight() > 1) {
                        x1 = -1;
                        y1 = -1;
                        x2 = 1;
                        y2 = 1;
                    } else {
                        x1 = -1;
                        y1 = -1;
                        x2 = 1;
                        y2 = -1;
                    }
                } else if (line.getHeight() > 1) {
                    x1 = 1;
                    y1 = -1;
                    x2 = 1;
                    y2 = 1;
                } else {
                    x1 = 1;
                    y1 = -1;
                    x2 = 1;
                    y2 = -1;
                }
                this.pdfContentByte.moveTo((float)line.getX() + (float)x1 * borderCorrection, (float)(this.jasperPrint.getPageHeight() - line.getY() - line.getHeight()) + (float)y1 * borderCorrection + 1.0f);
                this.pdfContentByte.lineTo((float)(line.getX() + line.getWidth()) + (float)x2 * borderCorrection - 1.0f, (float)(this.jasperPrint.getPageHeight() - line.getY()) + (float)y2 * borderCorrection);
            }
            this.pdfContentByte.stroke();
        }
    }

    private void exportRectangle(JRPrintRectangle rectangle) {
        this.pdfContentByte.setRGBColorStroke(rectangle.getForecolor().getRed(), rectangle.getForecolor().getGreen(), rectangle.getForecolor().getBlue());
        this.pdfContentByte.setRGBColorFill(rectangle.getBackcolor().getRed(), rectangle.getBackcolor().getGreen(), rectangle.getBackcolor().getBlue());
        float borderCorrection = 0.0f;
        switch (rectangle.getPen()) {
            case 4: {
                borderCorrection = 0.0f;
                this.pdfContentByte.setLineWidth(1.0f);
                this.pdfContentByte.setLineDash(5.0f, 3.0f, 0.0f);
                break;
            }
            case 3: {
                borderCorrection = 0.0f;
                this.pdfContentByte.setLineWidth(4.0f);
                this.pdfContentByte.setLineDash(0.0f);
                break;
            }
            case 2: {
                borderCorrection = 0.0f;
                this.pdfContentByte.setLineWidth(2.0f);
                this.pdfContentByte.setLineDash(0.0f);
                break;
            }
            case 5: {
                borderCorrection = 0.25f;
                this.pdfContentByte.setLineWidth(0.5f);
                this.pdfContentByte.setLineDash(0.0f);
                break;
            }
            case 0: {
                borderCorrection = 0.5f;
                this.pdfContentByte.setLineWidth(0.0f);
                this.pdfContentByte.setLineDash(0.0f);
                this.pdfContentByte.setRGBColorStroke(rectangle.getBackcolor().getRed(), rectangle.getBackcolor().getGreen(), rectangle.getBackcolor().getBlue());
                break;
            }
            default: {
                borderCorrection = 0.0f;
                this.pdfContentByte.setLineWidth(1.0f);
                this.pdfContentByte.setLineDash(0.0f);
            }
        }
        if (rectangle.getMode() == 1) {
            this.pdfContentByte.roundRectangle((float)rectangle.getX() - borderCorrection, (float)(this.jasperPrint.getPageHeight() - rectangle.getY() - rectangle.getHeight()) - borderCorrection + 1.0f, (float)rectangle.getWidth() + 2.0f * borderCorrection - 1.0f, (float)rectangle.getHeight() + 2.0f * borderCorrection - 1.0f, (float)rectangle.getRadius());
            this.pdfContentByte.fillStroke();
        } else if (rectangle.getPen() != 0) {
            this.pdfContentByte.roundRectangle((float)rectangle.getX() - borderCorrection, (float)(this.jasperPrint.getPageHeight() - rectangle.getY() - rectangle.getHeight()) - borderCorrection + 1.0f, (float)rectangle.getWidth() + 2.0f * borderCorrection - 1.0f, (float)rectangle.getHeight() + 2.0f * borderCorrection - 1.0f, (float)rectangle.getRadius());
            this.pdfContentByte.stroke();
        }
    }

    private void exportEllipse(JRPrintEllipse ellipse) {
        this.pdfContentByte.setRGBColorStroke(ellipse.getForecolor().getRed(), ellipse.getForecolor().getGreen(), ellipse.getForecolor().getBlue());
        this.pdfContentByte.setRGBColorFill(ellipse.getBackcolor().getRed(), ellipse.getBackcolor().getGreen(), ellipse.getBackcolor().getBlue());
        float borderCorrection = 0.0f;
        switch (ellipse.getPen()) {
            case 4: {
                borderCorrection = 0.0f;
                this.pdfContentByte.setLineWidth(1.0f);
                this.pdfContentByte.setLineDash(5.0f, 3.0f, 0.0f);
                break;
            }
            case 3: {
                borderCorrection = 0.0f;
                this.pdfContentByte.setLineWidth(4.0f);
                this.pdfContentByte.setLineDash(0.0f);
                break;
            }
            case 2: {
                borderCorrection = 0.0f;
                this.pdfContentByte.setLineWidth(2.0f);
                this.pdfContentByte.setLineDash(0.0f);
                break;
            }
            case 5: {
                borderCorrection = 0.25f;
                this.pdfContentByte.setLineWidth(0.5f);
                this.pdfContentByte.setLineDash(0.0f);
                break;
            }
            case 0: {
                borderCorrection = 0.5f;
                this.pdfContentByte.setLineWidth(0.0f);
                this.pdfContentByte.setLineDash(0.0f);
                this.pdfContentByte.setRGBColorStroke(ellipse.getBackcolor().getRed(), ellipse.getBackcolor().getGreen(), ellipse.getBackcolor().getBlue());
                break;
            }
            default: {
                borderCorrection = 0.0f;
                this.pdfContentByte.setLineWidth(1.0f);
                this.pdfContentByte.setLineDash(0.0f);
            }
        }
        if (ellipse.getMode() == 1) {
            this.pdfContentByte.ellipse((float)ellipse.getX() - borderCorrection, (float)(this.jasperPrint.getPageHeight() - ellipse.getY() - ellipse.getHeight()) - borderCorrection + 1.0f, (float)(ellipse.getX() + ellipse.getWidth()) + borderCorrection - 1.0f, (float)(this.jasperPrint.getPageHeight() - ellipse.getY()) + borderCorrection);
            this.pdfContentByte.fillStroke();
        } else if (ellipse.getPen() != 0) {
            this.pdfContentByte.ellipse((float)ellipse.getX() - borderCorrection, (float)(this.jasperPrint.getPageHeight() - ellipse.getY() - ellipse.getHeight()) - borderCorrection + 1.0f, (float)(ellipse.getX() + ellipse.getWidth()) + borderCorrection - 1.0f, (float)(this.jasperPrint.getPageHeight() - ellipse.getY()) + borderCorrection);
            this.pdfContentByte.stroke();
        }
    }

    private void exportImage(JRPrintImage printImage) throws DocumentException, IOException {
        int availableImageWidth;
        this.pdfContentByte.setRGBColorFill(printImage.getBackcolor().getRed(), printImage.getBackcolor().getGreen(), printImage.getBackcolor().getBlue());
        int borderOffset = 0;
        float borderCorrection = 0.0f;
        float lineWidth = 1.0f;
        boolean isLineDotted = false;
        switch (printImage.getPen()) {
            case 4: {
                borderOffset = 0;
                borderCorrection = 0.0f;
                lineWidth = 1.0f;
                isLineDotted = true;
                break;
            }
            case 3: {
                borderOffset = 2;
                borderCorrection = 0.0f;
                lineWidth = 4.0f;
                isLineDotted = false;
                break;
            }
            case 2: {
                borderOffset = 1;
                borderCorrection = 0.0f;
                lineWidth = 2.0f;
                isLineDotted = false;
                break;
            }
            case 5: {
                borderOffset = 0;
                borderCorrection = 0.25f;
                lineWidth = 0.5f;
                isLineDotted = false;
                break;
            }
            case 0: {
                borderOffset = 0;
                borderCorrection = 0.5f;
                lineWidth = 1.0f;
                isLineDotted = false;
                break;
            }
            default: {
                borderOffset = 0;
                borderCorrection = 0.0f;
                lineWidth = 1.0f;
                isLineDotted = false;
            }
        }
        if (printImage.getMode() == 1) {
            this.pdfContentByte.setRGBColorStroke(printImage.getBackcolor().getRed(), printImage.getBackcolor().getGreen(), printImage.getBackcolor().getBlue());
            this.pdfContentByte.setLineWidth(0.1f);
            this.pdfContentByte.setLineDash(0.0f);
            this.pdfContentByte.rectangle((float)printImage.getX() - borderCorrection, (float)(this.jasperPrint.getPageHeight() - printImage.getY()) + borderCorrection, (float)printImage.getWidth() + 2.0f * borderCorrection - 1.0f, (float)(-printImage.getHeight()) - 2.0f * borderCorrection + 1.0f);
            this.pdfContentByte.fillStroke();
        }
        availableImageWidth = (availableImageWidth = printImage.getWidth() - 2 * borderOffset) < 0 ? 0 : availableImageWidth;
        int availableImageHeight = printImage.getHeight() - 2 * borderOffset;
        availableImageHeight = availableImageHeight < 0 ? 0 : availableImageHeight;
        int xoffset = 0;
        int yoffset = 0;
        if (printImage.getImageData() != null && availableImageWidth > 0 && availableImageHeight > 0) {
            Image image = null;
            float xalignFactor = 0.0f;
            switch (printImage.getHorizontalAlignment()) {
                case 3: {
                    xalignFactor = 1.0f;
                    break;
                }
                case 2: {
                    xalignFactor = 0.5f;
                    break;
                }
                default: {
                    xalignFactor = 0.0f;
                }
            }
            float yalignFactor = 0.0f;
            switch (printImage.getVerticalAlignment()) {
                case 3: {
                    yalignFactor = 1.0f;
                    break;
                }
                case 2: {
                    yalignFactor = 0.5f;
                    break;
                }
                default: {
                    yalignFactor = 0.0f;
                }
            }
            switch (printImage.getScaleImage()) {
                case 1: {
                    java.awt.Image awtImage = JRImageLoader.loadImage(printImage.getImageData());
                    int awtWidth = awtImage.getWidth(null);
                    int awtHeight = awtImage.getHeight(null);
                    xoffset = (int)(xalignFactor * (float)(availableImageWidth - awtWidth));
                    yoffset = (int)(yalignFactor * (float)(availableImageHeight - awtHeight));
                    int minWidth = Math.min(awtWidth, availableImageWidth);
                    int minHeight = Math.min(awtHeight, availableImageHeight);
                    BufferedImage bi = new BufferedImage(minWidth, minHeight, 1);
                    Graphics g = bi.getGraphics();
                    g.setColor(printImage.getBackcolor());
                    g.fillRect(0, 0, minWidth, minHeight);
                    g.drawImage(awtImage, xoffset > 0 ? 0 : xoffset, yoffset > 0 ? 0 : yoffset, null);
                    xoffset = xoffset < 0 ? 0 : xoffset;
                    yoffset = yoffset < 0 ? 0 : yoffset;
                    awtImage = bi;
                    image = Image.getInstance((java.awt.Image)awtImage, null);
                    break;
                }
                case 2: {
                    try {
                        image = Image.getInstance((byte[])printImage.getImageData());
                        this.imageTesterPdfContentByte.addImage(image, 10.0f, 0.0f, 0.0f, 10.0f, 0.0f, 0.0f);
                    }
                    catch (Exception e) {
                        java.awt.Image awtImage = JRImageLoader.loadImage(printImage.getImageData());
                        image = Image.getInstance((java.awt.Image)awtImage, null);
                    }
                    image.scaleAbsolute((float)availableImageWidth, (float)availableImageHeight);
                    break;
                }
                default: {
                    try {
                        image = Image.getInstance((byte[])printImage.getImageData());
                        this.imageTesterPdfContentByte.addImage(image, 10.0f, 0.0f, 0.0f, 10.0f, 0.0f, 0.0f);
                    }
                    catch (Exception e) {
                        java.awt.Image awtImage = JRImageLoader.loadImage(printImage.getImageData());
                        image = Image.getInstance((java.awt.Image)awtImage, null);
                    }
                    image.scaleToFit((float)availableImageWidth, (float)availableImageHeight);
                    xoffset = (int)(xalignFactor * ((float)availableImageWidth - image.plainWidth()));
                    yoffset = (int)(yalignFactor * ((float)availableImageHeight - image.plainHeight()));
                    xoffset = xoffset < 0 ? 0 : xoffset;
                    yoffset = yoffset < 0 ? 0 : yoffset;
                }
            }
            Chunk chunk = new Chunk(image, -0.5f, 0.5f);
            if (printImage.getAnchorName() != null) {
                chunk.setLocalDestination(printImage.getAnchorName());
            }
            switch (printImage.getHyperlinkType()) {
                case 2: {
                    if (printImage.getHyperlinkReference() == null) break;
                    chunk.setAnchor(printImage.getHyperlinkReference());
                    break;
                }
                case 3: {
                    if (printImage.getHyperlinkAnchor() == null) break;
                    chunk.setLocalGoto(printImage.getHyperlinkAnchor());
                    break;
                }
                case 4: {
                    if (printImage.getHyperlinkPage() == null) break;
                    chunk.setLocalGoto("JR_PAGE_ANCHOR_" + printImage.getHyperlinkPage().toString());
                    break;
                }
                case 5: {
                    if (printImage.getHyperlinkReference() == null || printImage.getHyperlinkAnchor() == null) break;
                    chunk.setRemoteGoto(printImage.getHyperlinkReference(), printImage.getHyperlinkAnchor());
                    break;
                }
                case 6: {
                    if (printImage.getHyperlinkReference() == null || printImage.getHyperlinkPage() == null) break;
                    chunk.setRemoteGoto(printImage.getHyperlinkReference(), printImage.getHyperlinkPage().intValue());
                    break;
                }
            }
            ColumnText colText = new ColumnText(this.pdfContentByte);
            colText.setSimpleColumn(new Phrase(chunk), (float)(printImage.getX() + xoffset + borderOffset), (float)(this.jasperPrint.getPageHeight() - printImage.getY()) - image.scaledHeight() - (float)yoffset - (float)borderOffset, (float)(printImage.getX() + xoffset + borderOffset) + image.scaledWidth(), (float)(this.jasperPrint.getPageHeight() - printImage.getY() - yoffset - borderOffset), image.scaledHeight(), 0);
            colText.go();
        }
        if (printImage.getPen() != 0) {
            this.pdfContentByte.setRGBColorStroke(printImage.getForecolor().getRed(), printImage.getForecolor().getGreen(), printImage.getForecolor().getBlue());
            this.pdfContentByte.setLineWidth(lineWidth);
            if (isLineDotted) {
                this.pdfContentByte.setLineDash(5.0f, 3.0f, 0.0f);
            } else {
                this.pdfContentByte.setLineDash(0.0f);
            }
            this.pdfContentByte.rectangle((float)printImage.getX() - borderCorrection, (float)(this.jasperPrint.getPageHeight() - printImage.getY()) + borderCorrection, (float)printImage.getWidth() + 2.0f * borderCorrection - 1.0f, (float)(-printImage.getHeight()) - 2.0f * borderCorrection + 1.0f);
            this.pdfContentByte.stroke();
        }
    }

    private void exportText(JRPrintText text) throws JRException, DocumentException, IOException {
        BaseFont baseFont;
        String strText = text.getText();
        if (strText == null) {
            return;
        }
        if (text.getMode() == 1) {
            this.pdfContentByte.setRGBColorStroke(text.getBackcolor().getRed(), text.getBackcolor().getGreen(), text.getBackcolor().getBlue());
            this.pdfContentByte.setRGBColorFill(text.getBackcolor().getRed(), text.getBackcolor().getGreen(), text.getBackcolor().getBlue());
            this.pdfContentByte.setLineWidth(1.0f);
            this.pdfContentByte.setLineDash(0.0f);
            this.pdfContentByte.rectangle((float)text.getX(), (float)(this.jasperPrint.getPageHeight() - text.getY()), (float)(text.getWidth() - 1), (float)(-text.getHeight() + 1));
            this.pdfContentByte.fillStroke();
        }
        if (strText.length() == 0) {
            return;
        }
        JRFont jrFont = text.getFont();
        if (jrFont == null) {
            jrFont = this.getDefaultFont();
        }
        if ((baseFont = (BaseFont)this.loadedFontsMap.get(jrFont.getPdfFontName())) == null) {
            try {
                baseFont = BaseFont.createFont((String)jrFont.getPdfFontName(), (String)jrFont.getPdfEncoding(), (boolean)jrFont.isPdfEmbedded());
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (baseFont == null) {
            byte[] bytes = null;
            try {
                bytes = JRLoader.loadBytesFromLocation(jrFont.getPdfFontName());
            }
            catch (JRException e) {
                throw new JRException("Could not load font from location : " + jrFont.getPdfFontName());
            }
            baseFont = BaseFont.createFont((String)jrFont.getPdfFontName(), (String)jrFont.getPdfEncoding(), (boolean)jrFont.isPdfEmbedded(), (boolean)true, (byte[])bytes, null);
        }
        this.loadedFontsMap.put(jrFont.getPdfFontName(), baseFont);
        Font font = new Font(baseFont, (float)jrFont.getSize(), (jrFont.isBold() ? 1 : 0) + (jrFont.isItalic() ? 2 : 0) + (jrFont.isUnderline() ? 4 : 0) + (jrFont.isStrikeThrough() ? 8 : 0), text.getForecolor());
        int horizontalAlignment = 0;
        switch (text.getTextAlignment()) {
            case 1: {
                horizontalAlignment = 0;
                break;
            }
            case 2: {
                horizontalAlignment = 1;
                break;
            }
            case 3: {
                horizontalAlignment = 2;
                break;
            }
            case 4: {
                horizontalAlignment = 3;
                break;
            }
            default: {
                horizontalAlignment = 0;
            }
        }
        float verticalOffset = 0.0f;
        switch (text.getVerticalAlignment()) {
            case 1: {
                verticalOffset = 0.0f;
                break;
            }
            case 2: {
                verticalOffset = ((float)text.getHeight() - text.getTextHeight()) / 2.0f;
                break;
            }
            case 3: {
                verticalOffset = (float)text.getHeight() - text.getTextHeight();
                break;
            }
            default: {
                verticalOffset = 0.0f;
            }
        }
        Chunk chunk = new Chunk(strText, font);
        if (text.getAnchorName() != null) {
            chunk.setLocalDestination(text.getAnchorName());
        }
        switch (text.getHyperlinkType()) {
            case 2: {
                if (text.getHyperlinkReference() == null) break;
                chunk.setAnchor(text.getHyperlinkReference());
                break;
            }
            case 3: {
                if (text.getHyperlinkAnchor() == null) break;
                chunk.setLocalGoto(text.getHyperlinkAnchor());
                break;
            }
            case 4: {
                if (text.getHyperlinkPage() == null) break;
                chunk.setLocalGoto("JR_PAGE_ANCHOR_" + text.getHyperlinkPage().toString());
                break;
            }
            case 5: {
                if (text.getHyperlinkReference() == null || text.getHyperlinkAnchor() == null) break;
                chunk.setRemoteGoto(text.getHyperlinkReference(), text.getHyperlinkAnchor());
                break;
            }
            case 6: {
                if (text.getHyperlinkReference() == null || text.getHyperlinkPage() == null) break;
                chunk.setRemoteGoto(text.getHyperlinkReference(), text.getHyperlinkPage().intValue());
                break;
            }
        }
        ColumnText colText = new ColumnText(this.pdfContentByte);
        colText.setSimpleColumn(new Phrase(chunk), (float)text.getX(), (float)(this.jasperPrint.getPageHeight() - text.getY()) - verticalOffset - text.getAbsoluteLeading() + text.getAbsoluteLineSpacing(), (float)(text.getX() + text.getWidth()), (float)(this.jasperPrint.getPageHeight() - text.getY() - text.getHeight()), text.getAbsoluteLineSpacing(), horizontalAlignment);
        colText.go();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

