/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jtds.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;

public class ReaderInputStream
extends InputStream {
    protected Reader _reader;
    protected String _encoding;
    private byte[] _singleByte = new byte[1];
    private byte[] _buffer;
    private int _pointer;

    public ReaderInputStream(Reader reader) {
        if (reader == null) {
            throw new NullPointerException();
        }
        this._reader = reader;
    }

    public ReaderInputStream(Reader reader, String encoding) {
        if (reader == null) {
            throw new NullPointerException();
        }
        if (encoding == null) {
            throw new NullPointerException();
        }
        this._reader = reader;
        this._encoding = encoding;
    }

    public synchronized int read() throws IOException {
        if (this.read(this._singleByte, 0, 1) == -1) {
            return -1;
        }
        return this._singleByte[0];
    }

    public synchronized int read(byte[] b, int off, int len) throws IOException {
        if (this._reader == null) {
            throw new IOException("stream closed");
        }
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || off > b.length || off + len > b.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        int bytesRead = 0;
        if (this._buffer != null) {
            int bufferLength = this.readBuffer(b, off, len);
            if (bufferLength == len) {
                return len;
            }
            len -= bufferLength;
            off += bufferLength;
            bytesRead += bufferLength;
        }
        if (this._buffer == null) {
            char[] buffer = new char[len];
            int result = this._reader.read(buffer, 0, len);
            if (result == -1) {
                return bytesRead > 0 ? bytesRead : -1;
            }
            String data = new String(buffer, 0, result);
            this._buffer = this._encoding == null ? data.getBytes() : data.getBytes(this._encoding);
            return this.readBuffer(b, off, len);
        }
        return -1;
    }

    private int readBuffer(byte[] b, int off, int len) {
        int bufferLength = this._buffer.length - this._pointer;
        if (bufferLength >= len) {
            System.arraycopy(this._buffer, this._pointer, b, off, len);
            this._pointer += len;
            return len;
        }
        System.arraycopy(this._buffer, this._pointer, b, off, bufferLength);
        this._buffer = null;
        this._pointer = 0;
        return bufferLength;
    }

    public synchronized void reset() throws IOException {
        if (this._reader == null) {
            throw new IOException("stream closed");
        }
        this._reader.reset();
    }

    public synchronized void close() throws IOException {
        if (this._reader != null) {
            this._reader.close();
            this._reader = null;
        }
        this._encoding = null;
    }
}

