/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jtds.jdbc;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.LinkedList;
import net.sourceforge.jtds.jdbc.CharsetInfo;
import net.sourceforge.jtds.jdbc.RequestStream;
import net.sourceforge.jtds.jdbc.ResponseStream;
import net.sourceforge.jtds.ssl.SocketFactories;
import net.sourceforge.jtds.util.Logger;

class SharedSocket {
    private Socket socket;
    private DataOutputStream out;
    private DataInputStream in;
    private int maxBufSize = 512;
    private ArrayList socketTable = new ArrayList();
    private int responseOwner = -1;
    private byte[] hdrBuf = new byte[8];
    private static int globalMemUsage = 0;
    private static int peakMemUsage = 0;
    private static int memoryBudget = 100000;
    private static int minMemPkts = 8;
    private static boolean securityViolation;
    private int tdsVersion;
    private int serverType;
    private CharsetInfo charsetInfo;
    private int packetCount;
    private static final byte TDS_DONE_TOKEN = -3;

    protected SharedSocket() {
    }

    SharedSocket(String host, int port, int tdsVersion, int serverType, boolean tcpNoDelay, String ssl, String instance) throws IOException, UnknownHostException {
        this.setTdsVersion(tdsVersion);
        this.setServerType(serverType);
        this.socket = SharedSocket.createSocket(host, port, ssl, instance);
        this.setOut(new DataOutputStream(this.socket.getOutputStream()));
        this.setIn(new DataInputStream(this.socket.getInputStream()));
        this.socket.setTcpNoDelay(tcpNoDelay);
    }

    void setCharsetInfo(CharsetInfo charsetInfo) {
        this.charsetInfo = charsetInfo;
    }

    CharsetInfo getCharsetInfo() {
        return this.charsetInfo;
    }

    String getCharset() {
        return this.charsetInfo.getCharset();
    }

    RequestStream getRequestStream() {
        ArrayList arrayList = this.socketTable;
        synchronized (arrayList) {
            int id = 0;
            while (id < this.socketTable.size()) {
                if (this.socketTable.get(id) == null) break;
                ++id;
            }
            VirtualSocket vsock = new VirtualSocket(id);
            if (id >= this.socketTable.size()) {
                this.socketTable.add(vsock);
            } else {
                this.socketTable.set(id, vsock);
            }
            RequestStream requestStream = new RequestStream(this, id);
            return requestStream;
        }
    }

    ResponseStream getResponseStream(RequestStream requestStream) {
        return new ResponseStream(this, requestStream.getStreamId());
    }

    int getTdsVersion() {
        return this.tdsVersion;
    }

    protected void setTdsVersion(int tdsVersion) {
        this.tdsVersion = tdsVersion;
    }

    int getServerType() {
        return this.serverType;
    }

    protected void setServerType(int serverType) {
        this.serverType = serverType;
    }

    static void setMemoryBudget(int memoryBudget) {
        SharedSocket.memoryBudget = memoryBudget;
    }

    static int getMemoryBudget() {
        return memoryBudget;
    }

    static void setMinMemPkts(int minMemPkts) {
        SharedSocket.minMemPkts = minMemPkts;
    }

    static int getMinMemPkts() {
        return minMemPkts;
    }

    boolean isConnected() {
        return this.socket != null;
    }

    void cancel(int streamId) {
        if (this.responseOwner == streamId) {
            try {
                byte[] cancel = new byte[]{6, 1, 0, 8, 0, 0, this.getTdsVersion() >= 3 ? (byte)1 : 0, 0};
                this.getOut().write(cancel, 0, 8);
                this.getOut().flush();
                if (Logger.isActive()) {
                    Logger.logPacket(streamId, false, cancel);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    void close() throws IOException {
        if (Logger.isActive()) {
            Logger.println("TdsSocket: Max buffer memory used = " + peakMemUsage / 1024 + "KB");
        }
        ArrayList arrayList = this.socketTable;
        synchronized (arrayList) {
            int i = 0;
            while (i < this.socketTable.size()) {
                VirtualSocket vsock = (VirtualSocket)this.socketTable.get(i);
                if (vsock != null && vsock.diskQueue != null) {
                    try {
                        vsock.diskQueue.close();
                        vsock.queueFile.delete();
                    }
                    catch (IOException ioe) {
                        // empty catch block
                    }
                }
                ++i;
            }
            if (this.socket != null) {
                this.socket.close();
            }
        }
    }

    void forceClose() {
        if (this.socket != null) {
            try {
                try {
                    this.socket.close();
                }
                catch (IOException ioe) {
                    Object var3_2 = null;
                    this.socket = null;
                }
                Object var3_1 = null;
                this.socket = null;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.socket = null;
                throw throwable;
            }
        }
    }

    void closeStream(int streamId) {
        ArrayList arrayList = this.socketTable;
        synchronized (arrayList) {
            VirtualSocket vsock = this.lookup(streamId);
            if (vsock.diskQueue != null) {
                try {
                    vsock.diskQueue.close();
                    vsock.queueFile.delete();
                }
                catch (IOException ioe) {
                    // empty catch block
                }
            }
            this.socketTable.set(streamId, null);
        }
    }

    byte[] sendNetPacket(int streamId, byte[] buffer) throws IOException {
        ArrayList arrayList = this.socketTable;
        synchronized (arrayList) {
            VirtualSocket vsock = this.lookup(streamId);
            while (vsock.inputPkts > 0) {
                if (Logger.isActive()) {
                    Logger.println("TdsSocket: Unread data in input packet queue");
                }
                this.dequeueInput(vsock);
            }
            if (this.responseOwner != -1) {
                VirtualSocket other = (VirtualSocket)this.socketTable.get(this.responseOwner);
                byte[] tmpBuf = null;
                boolean ourData = other.owner == streamId;
                do {
                    tmpBuf = this.readPacket(ourData ? tmpBuf : null);
                    if (ourData) continue;
                    this.enqueueInput(other, tmpBuf);
                } while (tmpBuf[1] == 0);
                this.responseOwner = -1;
            }
            this.getOut().write(buffer, 0, SharedSocket.getPktLen(buffer, 2));
            if (buffer[1] != 0) {
                this.getOut().flush();
                this.responseOwner = streamId;
            }
            byte[] byArray = buffer;
            return byArray;
        }
    }

    byte[] getNetPacket(int streamId, byte[] buffer) throws IOException {
        ArrayList arrayList = this.socketTable;
        synchronized (arrayList) {
            VirtualSocket vsock = this.lookup(streamId);
            if (vsock.inputPkts > 0) {
                byte[] byArray = this.dequeueInput(vsock);
                return byArray;
            }
            if (this.responseOwner == -1) {
                throw new IOException("Stream " + streamId + " attempting to read when no request has been sent");
            }
            if (this.responseOwner != streamId) {
                throw new IOException("Stream " + streamId + " is trying to read data that belongs to stream " + this.responseOwner);
            }
            if ((buffer = this.readPacket(buffer))[1] != 0) {
                this.responseOwner = -1;
            }
            byte[] byArray = buffer;
            return byArray;
        }
    }

    private void enqueueInput(VirtualSocket vsock, byte[] buffer) throws IOException {
        if (globalMemUsage + buffer.length > memoryBudget && vsock.pktQueue.size() >= minMemPkts && !securityViolation && vsock.diskQueue == null) {
            try {
                vsock.queueFile = File.createTempFile("jtds", ".tmp");
                vsock.queueFile.deleteOnExit();
                vsock.diskQueue = new RandomAccessFile(vsock.queueFile, "rw");
                while (vsock.pktQueue.size() > 0) {
                    byte[] tmpBuf = (byte[])vsock.pktQueue.removeFirst();
                    vsock.diskQueue.write(tmpBuf, 0, SharedSocket.getPktLen(tmpBuf, 2));
                    ++vsock.pktsOnDisk;
                }
            }
            catch (SecurityException se) {
                securityViolation = true;
                vsock.queueFile = null;
                vsock.diskQueue = null;
            }
        }
        if (vsock.diskQueue != null) {
            vsock.diskQueue.write(buffer, 0, SharedSocket.getPktLen(buffer, 2));
            ++vsock.pktsOnDisk;
        } else {
            vsock.pktQueue.addLast(buffer);
            if ((globalMemUsage += buffer.length) > peakMemUsage) {
                peakMemUsage = globalMemUsage;
            }
        }
        ++vsock.inputPkts;
    }

    private byte[] dequeueInput(VirtualSocket vsock) throws IOException {
        byte[] buffer = null;
        if (vsock.pktsOnDisk > 0) {
            if (vsock.diskQueue.getFilePointer() == vsock.diskQueue.length()) {
                vsock.diskQueue.seek(0L);
            }
            vsock.diskQueue.readFully(this.hdrBuf, 0, 8);
            int len = SharedSocket.getPktLen(this.hdrBuf, 2);
            buffer = new byte[len];
            System.arraycopy(this.hdrBuf, 0, buffer, 0, 8);
            vsock.diskQueue.readFully(buffer, 8, len - 8);
            --vsock.pktsOnDisk;
            if (vsock.pktsOnDisk < 1) {
                try {
                    vsock.diskQueue.close();
                    vsock.queueFile.delete();
                    Object var5_4 = null;
                    vsock.queueFile = null;
                    vsock.diskQueue = null;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    vsock.queueFile = null;
                    vsock.diskQueue = null;
                    throw throwable;
                }
            }
        } else if (vsock.pktQueue.size() > 0) {
            buffer = (byte[])vsock.pktQueue.removeFirst();
            globalMemUsage -= buffer.length;
        }
        if (buffer != null) {
            --vsock.inputPkts;
        }
        return buffer;
    }

    private byte[] readPacket(byte[] buffer) throws IOException {
        do {
            try {
                this.getIn().readFully(this.hdrBuf);
            }
            catch (EOFException e) {
                throw new IOException("DB server closed connection.");
            }
            byte packetType = this.hdrBuf[0];
            if (packetType != 2 && packetType != 1 && packetType != 4) {
                throw new IOException("Unknown packet type 0x" + Integer.toHexString(packetType));
            }
            int len = SharedSocket.getPktLen(this.hdrBuf, 2);
            if (len < 8 || len > 65536) {
                throw new IOException("Invalid network packet length " + len);
            }
            if (buffer == null || len > buffer.length) {
                buffer = new byte[len];
                if (len > this.maxBufSize) {
                    this.maxBufSize = len;
                }
            }
            System.arraycopy(this.hdrBuf, 0, buffer, 0, 8);
            try {
                this.getIn().readFully(buffer, 8, len - 8);
            }
            catch (EOFException e) {
                throw new IOException("DB server closed connection.");
            }
            if (++this.packetCount != 1 || this.serverType != 1 || !"NTLMSSP".equals(new String(buffer, 11, 7))) continue;
            buffer[1] = 1;
        } while (this.isCancelAck(buffer));
        return buffer;
    }

    private boolean isCancelAck(byte[] buffer) {
        if (buffer[1] == 0) {
            return false;
        }
        if (SharedSocket.getPktLen(buffer, 2) != 17) {
            return false;
        }
        if (buffer[8] != -3 || (buffer[9] & 0x20) == 0) {
            return false;
        }
        if (Logger.isActive()) {
            Logger.println("TdsSocket: Cancel packet read");
        }
        return true;
    }

    private VirtualSocket lookup(int streamId) {
        if (streamId < 0 || streamId > this.socketTable.size()) {
            throw new IllegalArgumentException("Invalid parameter stream ID " + streamId);
        }
        VirtualSocket vsock = (VirtualSocket)this.socketTable.get(streamId);
        if (vsock.owner != streamId) {
            throw new IllegalStateException("Internal error: bad stream ID " + streamId);
        }
        return vsock;
    }

    static int getPktLen(byte[] buf, int offset) {
        int lo = buf[offset + 1] & 0xFF;
        int hi = (buf[offset] & 0xFF) << 8;
        return hi | lo;
    }

    protected void setTimeout(int timeout) throws SocketException {
        this.socket.setSoTimeout(timeout);
    }

    protected DataInputStream getIn() {
        return this.in;
    }

    protected void setIn(DataInputStream in) {
        this.in = in;
    }

    protected DataOutputStream getOut() {
        return this.out;
    }

    protected void setOut(DataOutputStream out) {
        this.out = out;
    }

    private static Socket createSocket(String host, int port, String ssl, String instance) throws UnknownHostException, IOException {
        if (ssl.equals("off")) {
            return new Socket(host, port);
        }
        return SocketFactories.getSocketFactory(ssl, instance).createSocket(host, port);
    }

    private static class VirtualSocket {
        int owner;
        LinkedList pktQueue;
        boolean flushInput;
        boolean complete;
        File queueFile;
        RandomAccessFile diskQueue;
        int pktsOnDisk;
        int inputPkts;

        VirtualSocket(int streamId) {
            this.owner = streamId;
            this.pktQueue = new LinkedList();
            this.flushInput = false;
            this.complete = false;
            this.queueFile = null;
            this.diskQueue = null;
            this.pktsOnDisk = 0;
            this.inputPkts = 0;
        }
    }
}

