/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jcs.engine.memory.shrinking;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jcs.engine.behavior.ICacheElement;
import org.apache.jcs.engine.behavior.IElementAttributes;
import org.apache.jcs.engine.control.event.ElementEvent;
import org.apache.jcs.engine.control.event.behavior.IElementEventHandler;
import org.apache.jcs.engine.memory.MemoryCache;

public class ShrinkerThread
extends Thread {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$jcs$engine$memory$shrinking$ShrinkerThread == null ? (class$org$apache$jcs$engine$memory$shrinking$ShrinkerThread = ShrinkerThread.class$("org.apache.jcs.engine.memory.shrinking.ShrinkerThread")) : class$org$apache$jcs$engine$memory$shrinking$ShrinkerThread));
    private final MemoryCache cache;
    private final long shrinkerInterval;
    private final long maxMemoryIdleTime;
    boolean alive = true;
    static /* synthetic */ Class class$org$apache$jcs$engine$memory$shrinking$ShrinkerThread;

    public ShrinkerThread(MemoryCache cache) {
        this.cache = cache;
        this.shrinkerInterval = cache.getCacheAttributes().getShrinkerIntervalSeconds() * 1000L;
        long maxMemoryIdleTimeSeconds = cache.getCacheAttributes().getMaxMemoryIdleTimeSeconds();
        this.maxMemoryIdleTime = maxMemoryIdleTimeSeconds == -1L ? -1L : maxMemoryIdleTimeSeconds * 1000L;
    }

    public void kill() {
        this.alive = false;
    }

    public void run() {
        while (this.alive) {
            this.shrink();
            try {
                ShrinkerThread.sleep(this.shrinkerInterval);
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
        }
    }

    protected void shrink() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Shrinking memory cache for: " + this.cache.getCompositeCache().getCacheName()));
        }
        try {
            Object[] keys = this.cache.getKeyArray();
            int size = keys.length;
            int i = 0;
            while (i < size) {
                Serializable key = (Serializable)keys[i];
                ICacheElement cacheElement = this.cache.getQuiet(key);
                if (cacheElement != null) {
                    long lastAccessTime;
                    IElementAttributes attributes = cacheElement.getElementAttributes();
                    boolean remove = false;
                    long now = System.currentTimeMillis();
                    if (!cacheElement.getElementAttributes().getIsEternal() && (remove = this.checkForRemoval(cacheElement, now))) {
                        this.cache.remove(cacheElement.getKey());
                    }
                    if (!remove && this.maxMemoryIdleTime != -1L && (lastAccessTime = attributes.getLastAccessTime()) + this.maxMemoryIdleTime < now) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Exceeded memory idle time: " + cacheElement.getKey()));
                        }
                        this.cache.remove(cacheElement.getKey());
                        this.cache.waterfal(cacheElement);
                    }
                }
                ++i;
            }
        }
        catch (Throwable t) {
            log.info((Object)"Unexpected trouble in shrink cycle", t);
            return;
        }
    }

    private boolean checkForRemoval(ICacheElement cacheElement, long now) throws IOException {
        IElementAttributes attributes = cacheElement.getElementAttributes();
        long maxLifeSeconds = attributes.getMaxLifeSeconds();
        long createTime = attributes.getCreateTime();
        if (maxLifeSeconds != -1L && now - createTime > maxLifeSeconds * 1000L) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Exceeded maxLifeSeconds: " + cacheElement.getKey()));
            }
            this.handleElementEvents(cacheElement, 0);
            return true;
        }
        long idleTime = attributes.getIdleTime();
        long lastAccessTime = attributes.getLastAccessTime();
        if (idleTime != -1L && now - lastAccessTime > idleTime * 1000L) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Exceeded maxIdleTime " + cacheElement.getKey()));
            }
            this.handleElementEvents(cacheElement, 2);
            return true;
        }
        return false;
    }

    private void handleElementEvents(ICacheElement cacheElement, int eventType) throws IOException {
        IElementAttributes attributes = cacheElement.getElementAttributes();
        ArrayList eventHandlers = attributes.getElementEventHandlers();
        if (eventHandlers != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Handlers are registered, type: " + eventType));
            }
            ElementEvent event = new ElementEvent(cacheElement, eventType);
            Iterator handlerIter = eventHandlers.iterator();
            while (handlerIter.hasNext()) {
                IElementEventHandler hand = (IElementEventHandler)handlerIter.next();
                this.cache.getCompositeCache().addElementEvent(hand, event);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

