/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jcs.engine;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.apache.jcs.engine.behavior.IAttributes;

public class Attributes
implements IAttributes,
Serializable,
Cloneable {
    public boolean IS_DISTRIBUTE = false;
    public boolean IS_LATERAL = false;
    public boolean IS_NOFLUSH = false;
    public boolean IS_REPLY = false;
    public boolean IS_SYNCHRONIZE = false;
    public boolean IS_SPOOL = false;
    public boolean IS_GROUP_TTL_DESTROY = false;
    public boolean IS_ORIGINAL = false;
    public boolean IS_REMOTE = false;
    public boolean IS_ETERNAL = true;
    public long version = 0L;
    public long ttl = 0L;
    public long default_ttl = 0L;
    public long idle = 0L;
    public long lastAccess = 0L;
    public int size = 0;
    public long createTime = 0L;

    public Attributes() {
        this.createTime = System.currentTimeMillis();
    }

    private Attributes(Attributes attr) {
        this.IS_NOFLUSH = attr.IS_NOFLUSH;
        this.IS_REPLY = attr.IS_REPLY;
        this.IS_SYNCHRONIZE = attr.IS_SYNCHRONIZE;
        this.IS_GROUP_TTL_DESTROY = attr.IS_GROUP_TTL_DESTROY;
        this.IS_ETERNAL = attr.IS_ETERNAL;
        this.IS_ORIGINAL = attr.IS_ORIGINAL;
        this.IS_SPOOL = attr.IS_SPOOL;
        this.IS_DISTRIBUTE = attr.IS_DISTRIBUTE;
        this.IS_REMOTE = attr.IS_REMOTE;
        this.version = attr.version;
        this.ttl = attr.ttl;
        this.default_ttl = attr.default_ttl;
        this.idle = attr.idle;
        this.size = attr.size;
    }

    public Attributes copy() {
        try {
            Attributes attr = (Attributes)this.clone();
            attr.createTime = System.currentTimeMillis();
            return attr;
        }
        catch (Exception e) {
            return new Attributes();
        }
    }

    public Object clone2() {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(100);
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(this);
            byte[] buf = baos.toByteArray();
            oos.close();
            ByteArrayInputStream bais = new ByteArrayInputStream(buf);
            ObjectInputStream ois = new ObjectInputStream(bais);
            Attributes attr = (Attributes)ois.readObject();
            ois.close();
            attr.createTime = System.currentTimeMillis();
            return attr;
        }
        catch (Exception e) {
            return null;
        }
    }

    public void setVersion(long version) {
        this.version = version;
    }

    public void setTimeToLive(long ttl) {
        this.ttl = ttl;
    }

    public void setIdleTime(long idle) {
        this.idle = idle;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public int getSize() {
        return this.size;
    }

    public long getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime() {
        this.createTime = System.currentTimeMillis();
    }

    public long getVersion() {
        return this.version;
    }

    public long getIdleTime() {
        return this.idle;
    }

    public long getTimeToLive() {
        return this.ttl;
    }

    public String toString() {
        StringBuffer dump = new StringBuffer();
        dump.append("[ IS_LATERAL = ").append(this.IS_LATERAL).append(", IS_SPOOL = ").append(this.IS_SPOOL).append(", IS_REMOTE = ").append(this.IS_REMOTE).append(", IS_ETERNAL = ").append(this.IS_ETERNAL).append(", ttl = ").append(String.valueOf(this.ttl)).append(", createTime = ").append(String.valueOf(this.createTime)).append(" ]");
        return dump.toString();
    }
}

