/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.web;

import java.io.IOException;
import java.util.logging.Level;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.compiere.model.MUser;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import sun.misc.BASE64Decoder;

public class CompiereMonitorFilter
implements Filter {
    protected CLogger log = CLogger.getCLogger(this.getClass());
    private static final String AUTHORIZATION = "CompiereAuthorization";
    private Long m_authorization = new Long(System.currentTimeMillis());

    public void init(FilterConfig config) throws ServletException {
        this.log.info("");
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        boolean error = false;
        String errorPage = "/error.html";
        boolean pass = false;
        try {
            if (!(request instanceof HttpServletRequest) || !(response instanceof HttpServletResponse)) {
                request.getRequestDispatcher(errorPage).forward(request, response);
                return;
            }
            HttpServletRequest req = (HttpServletRequest)request;
            HttpServletResponse resp = (HttpServletResponse)response;
            HttpSession session = req.getSession(true);
            Long compare = (Long)session.getAttribute(AUTHORIZATION);
            if (compare != null && compare.compareTo(this.m_authorization) == 0) {
                pass = true;
            } else if (this.checkAuthorization(req.getHeader("Authorization"))) {
                session.setAttribute(AUTHORIZATION, (Object)this.m_authorization);
                pass = true;
            }
            if (pass) {
                chain.doFilter(request, response);
            } else {
                resp.setStatus(401);
                resp.setHeader("WWW-Authenticate", "BASIC realm=\"Compiere Server\"");
            }
            return;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "filter", e);
            request.getRequestDispatcher(errorPage).forward(request, response);
            return;
        }
    }

    private boolean checkAuthorization(String authorization) {
        if (authorization == null) {
            return false;
        }
        try {
            String userInfo = authorization.substring(6).trim();
            BASE64Decoder decoder = new BASE64Decoder();
            String namePassword = new String(decoder.decodeBuffer(userInfo));
            int index = namePassword.indexOf(":");
            String name = namePassword.substring(0, index);
            String password = namePassword.substring(index + 1);
            MUser user = MUser.get(Env.getCtx(), name, password);
            if (user == null) {
                this.log.warning("User not found: '" + name + "/" + password + "'");
                return false;
            }
            if (!user.isAdministrator()) {
                this.log.warning("Not a Sys Admin = " + name);
                return false;
            }
            this.log.info("Name=" + name);
            return true;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "check", e);
            return false;
        }
    }

    public void destroy() {
        this.log.info("");
    }
}

