/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.server;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Timestamp;
import java.util.logging.Level;
import org.compiere.Compiere;
import org.compiere.model.MAlert;
import org.compiere.model.MAlertProcessor;
import org.compiere.model.MAlertProcessorLog;
import org.compiere.model.MAlertRecipient;
import org.compiere.model.MAlertRule;
import org.compiere.model.MClient;
import org.compiere.model.MRole;
import org.compiere.model.MUserRoles;
import org.compiere.server.CompiereServer;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.TimeUtil;
import org.compiere.util.Trx;
import org.compiere.util.ValueNamePair;

public class AlertProcessor
extends CompiereServer {
    private MAlertProcessor m_model = null;
    private StringBuffer m_summary = new StringBuffer();
    private StringBuffer m_errors = new StringBuffer();
    private MClient m_client = null;

    public AlertProcessor(MAlertProcessor model) {
        super(model, 180);
        this.m_model = model;
        this.m_client = MClient.get(model.getCtx(), model.getAD_Client_ID());
    }

    protected void doWork() {
        this.m_summary = new StringBuffer();
        this.m_errors = new StringBuffer();
        int count = 0;
        int countError = 0;
        MAlert[] alerts = this.m_model.getAlerts(false);
        for (int i = 0; i < alerts.length; ++i) {
            if (!this.processAlert(alerts[i])) {
                ++countError;
            }
            ++count;
        }
        String summary = "Total=" + count;
        if (countError > 0) {
            summary = summary + ", Not processed=" + countError;
        }
        summary = summary + " - ";
        this.m_summary.insert(0, summary);
        int no = this.m_model.deleteLog();
        this.m_summary.append("Logs deleted=").append(no);
        MAlertProcessorLog pLog = new MAlertProcessorLog(this.m_model, this.m_summary.toString());
        pLog.setReference("#" + String.valueOf(this.p_runCount) + " - " + TimeUtil.formatElapsed(new Timestamp(this.p_startWork)));
        pLog.setTextMsg(this.m_errors.toString());
        pLog.save();
    }

    private boolean processAlert(MAlert alert) {
        if (!alert.isValid()) {
            return false;
        }
        this.log.info("" + alert);
        StringBuffer message = new StringBuffer(alert.getAlertMessage()).append(Env.NL);
        boolean valid = true;
        boolean processed = false;
        MAlertRule[] rules = alert.getRules(false);
        for (int i = 0; i < rules.length; ++i) {
            Trx trx;
            int no;
            ValueNamePair error;
            String sql;
            MAlertRule rule;
            String trxName;
            block15: {
                int no2;
                if (i > 0) {
                    message.append(Env.NL).append("================================").append(Env.NL);
                }
                trxName = null;
                rule = rules[i];
                if (!rule.isValid()) continue;
                this.log.fine("" + rule);
                sql = rule.getPreProcessing();
                if (sql != null && sql.length() > 0 && (no2 = DB.executeUpdate(sql, false, trxName)) == -1) {
                    error = CLogger.retrieveError();
                    rule.setErrorMsg("Pre=" + error.getName());
                    this.m_errors.append("Pre=" + error.getName());
                    rule.setIsValid(false);
                    rule.save();
                    valid = false;
                    break;
                }
                sql = rule.getSql();
                if (alert.isEnforceRoleSecurity() || alert.isEnforceClientSecurity()) {
                    int AD_Role_ID = alert.getFirstAD_Role_ID();
                    if (AD_Role_ID == -1) {
                        AD_Role_ID = alert.getFirstUserAD_Role_ID();
                    }
                    if (AD_Role_ID != -1) {
                        MRole role = MRole.get(this.getCtx(), AD_Role_ID);
                        sql = role.addAccessSQL(sql, null, true, false);
                    }
                }
                try {
                    String text = this.listSqlSelect(sql, trxName);
                    if (text == null || text.length() <= 0) break block15;
                    message.append(text);
                    processed = true;
                }
                catch (Exception e) {
                    rule.setErrorMsg("Select=" + e.getLocalizedMessage());
                    this.m_errors.append("Select=" + e.getLocalizedMessage());
                    rule.setIsValid(false);
                    rule.save();
                    valid = false;
                    break;
                }
            }
            sql = rule.getPostProcessing();
            if (sql != null && sql.length() > 0 && (no = DB.executeUpdate(sql, false, trxName)) == -1) {
                error = CLogger.retrieveError();
                rule.setErrorMsg("Post=" + error.getName());
                this.m_errors.append("Post=" + error.getName());
                rule.setIsValid(false);
                rule.save();
                valid = false;
                break;
            }
            if (trxName == null || (trx = Trx.get(trxName, false)) == null) continue;
            trx.commit();
            trx.close();
        }
        if (!valid) {
            alert.setIsValid(false);
            alert.save();
            return false;
        }
        if (!processed) {
            this.m_summary.append(alert.getName()).append("=No Result - ");
            return true;
        }
        int countMail = 0;
        MAlertRecipient[] recipients = alert.getRecipients(false);
        for (int i = 0; i < recipients.length; ++i) {
            MAlertRecipient recipient = recipients[i];
            if (recipient.getAD_User_ID() >= 0 && this.m_client.sendEMail(recipient.getAD_User_ID(), alert.getAlertSubject(), message.toString(), null)) {
                ++countMail;
            }
            if (recipient.getAD_Role_ID() < 0) continue;
            MUserRoles[] urs = MUserRoles.getOfRole(this.getCtx(), recipient.getAD_Role_ID());
            for (int j = 0; j < urs.length; ++j) {
                MUserRoles ur = urs[j];
                if (!this.m_client.sendEMail(ur.getAD_User_ID(), alert.getAlertSubject(), message.toString(), null)) continue;
                ++countMail;
            }
        }
        this.m_summary.append(alert.getName()).append(" (EMails=").append(countMail).append(") - ");
        return valid;
    }

    private String listSqlSelect(String sql, String trxName) throws Exception {
        StringBuffer result = new StringBuffer();
        CPreparedStatement pstmt = null;
        Exception error = null;
        try {
            pstmt = DB.prepareStatement(sql, trxName);
            ResultSet rs = pstmt.executeQuery();
            ResultSetMetaData meta = rs.getMetaData();
            while (rs.next()) {
                result.append("------------------").append(Env.NL);
                for (int col = 1; col <= meta.getColumnCount(); ++col) {
                    result.append(meta.getColumnLabel(col)).append(" = ");
                    result.append(rs.getString(col));
                    result.append(Env.NL);
                }
            }
            if (result.length() == 0) {
                this.log.fine("No rows selected");
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, e);
            error = e;
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        if (error != null) {
            throw new Exception("(" + sql + ") " + Env.NL + error.getLocalizedMessage());
        }
        return result.toString();
    }

    public String getServerInfo() {
        return "#" + this.p_runCount + " - Last=" + this.m_summary.toString();
    }

    public static void main(String[] args) {
        Compiere.startup(true);
        MAlertProcessor model = new MAlertProcessor(Env.getCtx(), 100, null);
        AlertProcessor ap = new AlertProcessor(model);
        ap.start();
    }
}

