/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.acct;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.ArrayList;
import org.compiere.acct.Doc;
import org.compiere.acct.DocLine;
import org.compiere.acct.Fact;
import org.compiere.acct.FactLine;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MCostDetail;
import org.compiere.model.MMovement;
import org.compiere.model.MMovementLine;
import org.compiere.model.MProductCategoryAcct;
import org.compiere.util.Env;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Doc_Movement
extends Doc {
    public Doc_Movement(MAcctSchema[] ass, ResultSet rs, String trxName) {
        super(ass, MMovement.class, rs, "MMM", trxName);
    }

    @Override
    protected String loadDocumentDetails() {
        this.setC_Currency_ID(-2);
        MMovement move = (MMovement)this.getPO();
        this.setDateDoc(move.getMovementDate());
        this.setDateAcct(move.getMovementDate());
        this.p_lines = this.loadLines(move);
        this.log.fine("Lines=" + this.p_lines.length);
        return null;
    }

    private DocLine[] loadLines(MMovement move) {
        ArrayList<DocLine> list = new ArrayList<DocLine>();
        MMovementLine[] lines = move.getLines(false);
        for (int i = 0; i < lines.length; ++i) {
            MMovementLine line = lines[i];
            DocLine docLine = new DocLine(line, this);
            docLine.setQty(line.getMovementQty(), false);
            this.log.fine(docLine.toString());
            list.add(docLine);
        }
        DocLine[] dls = new DocLine[list.size()];
        list.toArray(dls);
        return dls;
    }

    @Override
    public BigDecimal getBalance() {
        BigDecimal retValue = Env.ZERO;
        return retValue;
    }

    @Override
    public ArrayList<Fact> createFacts(MAcctSchema as) {
        Fact fact = new Fact(this, as, "A");
        this.setC_Currency_ID(as.getC_Currency_ID());
        FactLine dr = null;
        FactLine cr = null;
        for (int i = 0; i < this.p_lines.length; ++i) {
            DocLine line = this.p_lines[i];
            BigDecimal costs = line.getProductCosts(as, line.getAD_Org_ID(), false);
            dr = fact.createLine(line, line.getAccount(3, as), as.getC_Currency_ID(), costs.negate());
            if (dr == null) continue;
            dr.setM_Locator_ID(line.getM_Locator_ID());
            dr.setQty(line.getQty().negate());
            cr = fact.createLine(line, line.getAccount(3, as), as.getC_Currency_ID(), costs);
            if (cr == null) continue;
            cr.setM_Locator_ID(line.getM_LocatorTo_ID());
            cr.setQty(line.getQty());
            if (dr.getAD_Org_ID() == cr.getAD_Org_ID()) continue;
            String costingLevel = as.getCostingLevel();
            MProductCategoryAcct pca = MProductCategoryAcct.get(this.getCtx(), line.getProduct().getM_Product_Category_ID(), as.getC_AcctSchema_ID(), this.getTrxName());
            if (pca.getCostingLevel() != null) {
                costingLevel = pca.getCostingLevel();
            }
            if (!"O".equals(costingLevel)) continue;
            String description = line.getDescription();
            if (description == null) {
                description = "";
            }
            MCostDetail.createMovement(as, dr.getAD_Org_ID(), line.getM_Product_ID(), line.getM_AttributeSetInstance_ID(), line.get_ID(), 0, costs.negate(), line.getQty().negate(), true, description + "(|->)", this.getTrxName());
            MCostDetail.createMovement(as, cr.getAD_Org_ID(), line.getM_Product_ID(), line.getM_AttributeSetInstance_ID(), line.get_ID(), 0, costs, line.getQty(), false, description + "(|<-)", this.getTrxName());
        }
        ArrayList<Fact> facts = new ArrayList<Fact>();
        facts.add(fact);
        return facts;
    }
}

