/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.acct;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.ArrayList;
import org.compiere.acct.Doc;
import org.compiere.acct.DocLine;
import org.compiere.acct.Doc_Order;
import org.compiere.acct.Fact;
import org.compiere.acct.FactLine;
import org.compiere.model.MAccount;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MConversionRate;
import org.compiere.model.MCostDetail;
import org.compiere.model.MInOutLine;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MMatchInv;
import org.compiere.model.ProductCost;
import org.compiere.util.DB;
import org.compiere.util.Env;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Doc_MatchInv
extends Doc {
    private MInvoiceLine m_invoiceLine = null;
    private MInOutLine m_receiptLine = null;
    private ProductCost m_pc = null;
    private DocLine[] m_commitments = null;

    protected Doc_MatchInv(MAcctSchema[] ass, ResultSet rs, String trxName) {
        super(ass, MMatchInv.class, rs, "MXI", trxName);
    }

    @Override
    protected String loadDocumentDetails() {
        this.setC_Currency_ID(-2);
        MMatchInv matchInv = (MMatchInv)this.getPO();
        this.setDateDoc(matchInv.getDateTrx());
        this.setQty(matchInv.getQty());
        int C_InvoiceLine_ID = matchInv.getC_InvoiceLine_ID();
        this.m_invoiceLine = new MInvoiceLine(this.getCtx(), C_InvoiceLine_ID, null);
        int C_BPartner_ID = this.m_invoiceLine.getParent().getC_BPartner_ID();
        this.setC_BPartner_ID(C_BPartner_ID);
        int M_InOutLine_ID = matchInv.getM_InOutLine_ID();
        this.m_receiptLine = new MInOutLine(this.getCtx(), M_InOutLine_ID, null);
        this.m_pc = new ProductCost(Env.getCtx(), this.getM_Product_ID(), matchInv.getM_AttributeSetInstance_ID(), null);
        this.m_pc.setQty(this.getQty());
        return null;
    }

    @Override
    public BigDecimal getBalance() {
        return Env.ZERO;
    }

    @Override
    public ArrayList<Fact> createFacts(MAcctSchema as) {
        ArrayList<Fact> facts = new ArrayList<Fact>();
        if (this.getM_Product_ID() == 0 || this.getQty().signum() == 0 || this.m_receiptLine.getMovementQty().signum() == 0) {
            this.log.fine("No Product/Qty - M_Product_ID=" + this.getM_Product_ID() + ",Qty=" + this.getQty() + ",InOutQty=" + this.m_receiptLine.getMovementQty());
            return facts;
        }
        MMatchInv matchInv = (MMatchInv)this.getPO();
        Fact fact = new Fact(this, as, "A");
        this.setC_Currency_ID(as.getC_Currency_ID());
        BigDecimal multiplier = this.getQty().divide(this.m_receiptLine.getMovementQty(), 12, 4).abs();
        FactLine dr = fact.createLine(null, this.getAccount(51, as), as.getC_Currency_ID(), Env.ONE, null);
        if (dr == null) {
            this.p_Error = "No Product Costs";
            return null;
        }
        dr.setQty(this.getQty());
        BigDecimal temp = dr.getAcctBalance();
        if (!dr.updateReverseLine(319, this.m_receiptLine.getM_InOut_ID(), this.m_receiptLine.getM_InOutLine_ID(), multiplier)) {
            this.p_Error = "Mat.Receipt not posted yet";
            return null;
        }
        this.log.fine("CR - Amt(" + temp + "->" + dr.getAcctBalance() + ") - " + dr.toString());
        MAccount expense = this.m_pc.getAccount(10, as);
        if (this.m_pc.isService()) {
            expense = this.m_pc.getAccount(2, as);
        }
        BigDecimal LineNetAmt = this.m_invoiceLine.getLineNetAmt();
        multiplier = this.getQty().divide(this.m_invoiceLine.getQtyInvoiced(), 12, 4).abs();
        if (multiplier.compareTo(Env.ONE) != 0) {
            LineNetAmt = LineNetAmt.multiply(multiplier);
        }
        if (this.m_pc.isService()) {
            LineNetAmt = dr.getAcctBalance();
        }
        FactLine cr = null;
        if (as.isAccrual()) {
            cr = fact.createLine(null, expense, as.getC_Currency_ID(), null, LineNetAmt);
            if (cr == null) {
                this.log.fine("Line Net Amt=0 - M_Product_ID=" + this.getM_Product_ID() + ",Qty=" + this.getQty() + ",InOutQty=" + this.m_receiptLine.getMovementQty());
                facts.add(fact);
                return facts;
            }
            cr.setQty(this.getQty().negate());
            temp = cr.getAcctBalance();
            if (as.isAccrual() && !cr.updateReverseLine(318, this.m_invoiceLine.getC_Invoice_ID(), this.m_invoiceLine.getC_InvoiceLine_ID(), multiplier)) {
                this.p_Error = "Invoice not posted yet";
                return null;
            }
            this.log.fine("DR - Amt(" + temp + "->" + cr.getAcctBalance() + ") - " + cr.toString());
        } else {
            MInvoice invoice = this.m_invoiceLine.getParent();
            if (as.getC_Currency_ID() == invoice.getC_Currency_ID()) {
                LineNetAmt = MConversionRate.convert(this.getCtx(), LineNetAmt, invoice.getC_Currency_ID(), as.getC_Currency_ID(), invoice.getDateAcct(), invoice.getC_ConversionType_ID(), invoice.getAD_Client_ID(), invoice.getAD_Org_ID());
            }
            cr = fact.createLine(null, expense, as.getC_Currency_ID(), null, LineNetAmt);
            cr.setQty(this.getQty().multiply(multiplier).negate());
        }
        cr.setC_Activity_ID(this.m_invoiceLine.getC_Activity_ID());
        cr.setC_Campaign_ID(this.m_invoiceLine.getC_Campaign_ID());
        cr.setC_Project_ID(this.m_invoiceLine.getC_Project_ID());
        cr.setC_UOM_ID(this.m_invoiceLine.getC_UOM_ID());
        cr.setUser1_ID(this.m_invoiceLine.getUser1_ID());
        cr.setUser2_ID(this.m_invoiceLine.getUser2_ID());
        BigDecimal ipv = cr.getAcctBalance().add(dr.getAcctBalance()).negate();
        if (ipv.signum() != 0) {
            FactLine pv = fact.createLine(null, this.m_pc.getAccount(6, as), as.getC_Currency_ID(), ipv);
            pv.setC_Activity_ID(this.m_invoiceLine.getC_Activity_ID());
            pv.setC_Campaign_ID(this.m_invoiceLine.getC_Campaign_ID());
            pv.setC_Project_ID(this.m_invoiceLine.getC_Project_ID());
            pv.setC_UOM_ID(this.m_invoiceLine.getC_UOM_ID());
            pv.setUser1_ID(this.m_invoiceLine.getUser1_ID());
            pv.setUser2_ID(this.m_invoiceLine.getUser2_ID());
        }
        this.log.fine("IPV=" + ipv + "; Balance=" + fact.getSourceBalance());
        MCostDetail.createInvoice(as, this.getAD_Org_ID(), this.getM_Product_ID(), matchInv.getM_AttributeSetInstance_ID(), this.m_invoiceLine.getC_InvoiceLine_ID(), 0, cr.getAcctBalance().negate(), this.getQty(), this.getDescription(), this.getTrxName());
        this.updateProductInfo(as.getC_AcctSchema_ID(), "S".equals(as.getCostingMethod()));
        facts.add(fact);
        if (as.isAccrual() && as.isCreateCommitment()) {
            fact = Doc_Order.getCommitmentRelease(as, this, this.getQty(), this.m_invoiceLine.getC_InvoiceLine_ID(), Env.ONE);
            if (fact == null) {
                return null;
            }
            facts.add(fact);
        }
        return facts;
    }

    private boolean updateProductInfo(int C_AcctSchema_ID, boolean standardCosting) {
        this.log.fine("M_MatchInv_ID=" + this.get_ID());
        StringBuffer sql = new StringBuffer("UPDATE M_Product_Costing pc SET (CostStandardCumQty,CostStandardCumAmt, CostAverageCumQty,CostAverageCumAmt) = (SELECT pc.CostStandardCumQty + m.Qty,pc.CostStandardCumAmt + currencyConvert(il.PriceActual,i.C_Currency_ID,a.C_Currency_ID,i.DateInvoiced,i.C_ConversionType_ID,i.AD_Client_ID,i.AD_Org_ID)*m.Qty, pc.CostAverageCumQty + m.Qty,pc.CostAverageCumAmt + currencyConvert(il.PriceActual,i.C_Currency_ID,a.C_Currency_ID,i.DateInvoiced,i.C_ConversionType_ID,i.AD_Client_ID,i.AD_Org_ID)*m.Qty FROM M_MatchInv m INNER JOIN C_InvoiceLine il ON (m.C_InvoiceLine_ID=il.C_InvoiceLine_ID) INNER JOIN C_Invoice i ON (il.C_Invoice_ID=i.C_Invoice_ID), C_AcctSchema a WHERE pc.C_AcctSchema_ID=a.C_AcctSchema_ID AND pc.M_Product_ID=m.M_Product_ID AND m.M_MatchInv_ID=").append(this.get_ID()).append(")WHERE pc.C_AcctSchema_ID=").append(C_AcctSchema_ID).append(" AND EXISTS (SELECT * FROM M_MatchInv m WHERE pc.M_Product_ID=m.M_Product_ID AND m.M_MatchInv_ID=").append(this.get_ID()).append(")");
        int no = DB.executeUpdate(sql.toString(), this.getTrxName());
        this.log.fine("M_Product_Costing - Qty/Amt Updated #=" + no);
        sql = new StringBuffer("UPDATE M_Product_Costing SET CostAverage = CostAverageCumAmt/DECODE(CostAverageCumQty, 0,1, CostAverageCumQty) WHERE C_AcctSchema_ID=").append(C_AcctSchema_ID).append(" AND M_Product_ID=").append(this.getM_Product_ID());
        no = DB.executeUpdate(sql.toString(), this.getTrxName());
        this.log.fine("M_Product_Costing - AvgCost Updated #=" + no);
        if (!standardCosting) {
            sql = new StringBuffer("UPDATE M_Product_Costing SET CurrentCostPrice = CostAverage WHERE C_AcctSchema_ID=").append(C_AcctSchema_ID).append(" AND M_Product_ID=").append(this.getM_Product_ID());
            no = DB.executeUpdate(sql.toString(), this.getTrxName());
            this.log.fine("M_Product_Costing - CurrentCost Updated=" + no);
        }
        return true;
    }
}

