/*
 * Decompiled with CFR 0.152.
 */
package org.ajaxtags.helpers;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.ajaxtags.helpers.Item;
import org.apache.commons.beanutils.BeanUtils;

public class AjaxXmlBuilder {
    private String encoding = "UTF-8";
    private List items = new ArrayList();

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public AjaxXmlBuilder addItem(String name, String value) {
        this.items.add(new Item(name, value, false));
        return this;
    }

    public AjaxXmlBuilder addItemAsCData(String name, String value) {
        this.items.add(new Item(name, value, true));
        return this;
    }

    public AjaxXmlBuilder addItems(Collection collection, String nameProperty, String valueProperty) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        return this.addItems(collection, nameProperty, valueProperty, false);
    }

    public AjaxXmlBuilder addItems(Collection collection, String nameProperty, String valueProperty, boolean asCData) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Iterator iter = collection.iterator();
        while (iter.hasNext()) {
            Object element = iter.next();
            String name = BeanUtils.getProperty(element, (String)nameProperty);
            String value = BeanUtils.getProperty(element, (String)valueProperty);
            if (asCData) {
                this.items.add(new Item(name, value, false));
                continue;
            }
            this.items.add(new Item(name, value, true));
        }
        return this;
    }

    public AjaxXmlBuilder addItemsAsCData(Collection collection, String nameProperty, String valueProperty) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        return this.addItems(collection, nameProperty, valueProperty, true);
    }

    public String toString() {
        StringBuffer xml = new StringBuffer().append("<?xml version=\"1.0\"");
        if (this.encoding != null) {
            xml.append(" encoding=\"");
            xml.append(this.encoding);
            xml.append("\"");
        }
        xml.append(" ?>");
        xml.append("<ajax-response>");
        xml.append("<response>");
        Iterator iter = this.items.iterator();
        while (iter.hasNext()) {
            Item item = (Item)iter.next();
            xml.append("<item>");
            xml.append("<name>");
            if (item.isAsCData()) {
                xml.append("<![CDATA[");
            }
            xml.append(item.getName());
            if (item.isAsCData()) {
                xml.append("]]>");
            }
            xml.append("</name>");
            xml.append("<value>");
            if (item.isAsCData()) {
                xml.append("<![CDATA[");
            }
            xml.append(item.getValue());
            if (item.isAsCData()) {
                xml.append("]]>");
            }
            xml.append("</value>");
            xml.append("</item>");
        }
        xml.append("</response>");
        xml.append("</ajax-response>");
        return xml.toString();
    }
}

