/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jmx.adaptor.rmi;

import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import javax.management.Attribute;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import org.jboss.jmx.adaptor.rmi.RMIAdaptor;

public class RMIRemoteMBeanProxy
implements Serializable,
InvocationHandler {
    static final long serialVersionUID = -3728092157537581033L;
    private final RMIAdaptor remoteServer;
    private final ObjectName name;
    private static final Object[] EMPTY_ARGS = new Object[0];

    RMIRemoteMBeanProxy(ObjectName name, MBeanServer server) throws Exception {
        this.name = name;
        this.remoteServer = this.getRmiAdaptor();
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        if (methodName.startsWith("get") && args == null) {
            String attrName = methodName.substring(3);
            return this.remoteServer.getAttribute(this.name, attrName);
        }
        if (methodName.startsWith("is") && args == null) {
            String attrName = methodName.substring(2);
            return this.remoteServer.getAttribute(this.name, attrName);
        }
        if (methodName.startsWith("set") && args != null && args.length == 1) {
            String attrName = methodName.substring(3);
            this.remoteServer.setAttribute(this.name, new Attribute(attrName, args[0]));
            return null;
        }
        Class<?>[] types = method.getParameterTypes();
        String[] sig = new String[types.length];
        for (int i = 0; i < types.length; ++i) {
            sig[i] = types[i].getName();
        }
        return this.remoteServer.invoke(this.name, methodName, args == null ? EMPTY_ARGS : args, sig);
    }

    protected RMIAdaptor getRmiAdaptor() throws Exception {
        InitialContext ctx = new InitialContext();
        return (RMIAdaptor)ctx.lookup("jmx/invoker/RMIAdaptor");
    }

    public final ObjectName getMBeanProxyObjectName() {
        return this.name;
    }

    public final RMIAdaptor getMBeanProxyRMIAdaptor() {
        return this.remoteServer;
    }

    public static Object create(Class intf, String name, MBeanServer server) throws Exception {
        return RMIRemoteMBeanProxy.create(intf, new ObjectName(name), server);
    }

    public static Object create(Class intf, ObjectName name, MBeanServer server) throws Exception {
        return Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{intf}, (InvocationHandler)new RMIRemoteMBeanProxy(name, server));
    }
}

