/*
 * Decompiled with CFR 0.152.
 */
package com.jware.util.mail;

import com.jware.util.mail.BaseMailData;
import com.jware.util.mail.BaseMailSender;
import com.jware.util.mail.MXLoockup;
import com.jware.util.mail.MailPersistentManager;
import com.jware.util.mail.MailResourceUtility;
import com.jware.util.mail.MailSenderThread;
import com.jware.util.mail.MailStatus;
import com.jware.util.mail.MassMailData;
import java.util.Calendar;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MassMailSender {
    private final int MAX_RETRY_COUNT = 3;
    private final long NORMAL_MAXWAITING = 0x6DDD00L;
    private final long ABNORMAL_MAXWAITING = 14400000L;
    private final int DEFAULT_POOL_SIZE = 5;
    private final long SAVING_INTERVAL = 60000L;
    private final Log log = LogFactory.getLog(this.getClass());
    private MailResourceUtility myResources = new MailResourceUtility();
    private MailPersistentManager persistentManager = null;
    private long mailSavedTime = 0L;

    public boolean execute(BaseMailData mailData) {
        long currentTime;
        MailSenderThread tempThread;
        BaseMailData newMailData;
        LinkedList<BaseMailData> mailDataList;
        List addressList;
        List bccList;
        LinkedList<String> addressList2;
        List ccList;
        List toList;
        boolean result = false;
        if (mailData == null) {
            return result;
        }
        mailData.setProcessor(this.myResources.getResourceString("MailSendingProcessor"));
        mailData.setPreInsertTitle(this.myResources.getResourceString("mail.Title.PreInsert"));
        mailData.setPostInsertTitle(this.myResources.getResourceString("mail.Title.PostInsert"));
        this.mailSavedTime = Calendar.getInstance().getTimeInMillis();
        mailData.setStatus(1);
        int threadPoolSize = 0;
        try {
            threadPoolSize = Integer.parseInt(this.myResources.getResourceString("ThreadPoolSize"));
        }
        catch (Exception e) {
            threadPoolSize = 5;
        }
        if (threadPoolSize <= 0) {
            threadPoolSize = 5;
        }
        HashMap<String, MailSenderThread> threadPool = new HashMap<String, MailSenderThread>();
        HashMap<String, MailSenderThread> abnormalThreadPool = new HashMap<String, MailSenderThread>();
        HashMap<String, LinkedList<String>> hostAddressMap = new HashMap<String, LinkedList<String>>();
        HashMap<String, MailStatus> hostStatusMap = mailData.getHostStatusMap();
        if (hostStatusMap == null) {
            hostStatusMap = new HashMap<String, MailStatus>();
        }
        if ((toList = mailData.getToList()) != null) {
            for (int i2 = 0; i2 < toList.size(); ++i2) {
                String address = (String)toList.get(i2);
                String domain = MXLoockup.lookupDomain(address);
                if (domain == null) continue;
                LinkedList<String> addressList3 = (LinkedList<String>)hostAddressMap.get(domain);
                if (addressList3 == null) {
                    addressList3 = new LinkedList<String>();
                    hostAddressMap.put(domain, addressList3);
                }
                addressList3.add(address);
            }
        }
        if ((ccList = mailData.getCcList()) != null) {
            for (int i3 = 0; i3 < ccList.size(); ++i3) {
                String address = (String)ccList.get(i3);
                String domain = MXLoockup.lookupDomain(address);
                if (domain == null) continue;
                addressList2 = (LinkedList<String>)hostAddressMap.get(domain);
                if (addressList2 == null) {
                    addressList2 = new LinkedList<String>();
                    hostAddressMap.put(domain, addressList2);
                }
                addressList2.add(address);
            }
        }
        if ((bccList = mailData.getBccList()) != null) {
            for (int i4 = 0; i4 < bccList.size(); ++i4) {
                String address = (String)bccList.get(i4);
                String domain = MXLoockup.lookupDomain(address);
                if (domain == null) continue;
                LinkedList<String> addressList4 = (LinkedList<String>)hostAddressMap.get(domain);
                if (addressList4 == null) {
                    addressList4 = new LinkedList<String>();
                    hostAddressMap.put(domain, addressList4);
                }
                addressList4.add(address);
            }
        }
        if (mailData instanceof MassMailData) {
            BaseMailData beforMailData = ((MassMailData)mailData).getBeforeMail();
            MassMailSender beforMailSender = new MassMailSender();
            beforMailSender.execute(beforMailData);
        }
        for (String domain : hostAddressMap.keySet()) {
            addressList2 = (List)hostAddressMap.get(domain);
            String host = MXLoockup.lookupHost(domain);
            if (host == null) continue;
            MailStatus mailStatus = (MailStatus)hostStatusMap.get(host);
            if (mailStatus == null) {
                mailStatus = new MailStatus();
            }
            mailStatus.setMailHost(host);
            mailStatus.setMailDomain(domain);
            mailStatus.setStartTime(Calendar.getInstance().getTime());
            MailResourceUtility mailResourceUtility = new MailResourceUtility();
            String domainConstraint = mailResourceUtility.getResourceString(domain);
            if (domainConstraint != null) {
                String[] constraints = domainConstraint.split(",");
                int maxSendable = -1;
                if (constraints.length > 0) {
                    try {
                        maxSendable = Integer.parseInt(constraints[0].trim());
                    }
                    catch (Exception e) {
                        maxSendable = -1;
                    }
                }
                int limitInterval = 0;
                if (constraints.length > 1) {
                    try {
                        limitInterval = Integer.parseInt(constraints[1].trim());
                    }
                    catch (Exception e) {
                        limitInterval = 0;
                    }
                }
                mailStatus.setMaxSendable(maxSendable);
                mailStatus.setLimitInterval(limitInterval);
                if (limitInterval != 0 && maxSendable != -1) {
                    mailStatus.setAbnormalFlg(true);
                }
            }
            mailStatus.setCompleteFlg(false);
            hostStatusMap.put(domain, mailStatus);
        }
        mailData.setHostStatusMap(hostStatusMap);
        for (String domain : hostStatusMap.keySet()) {
            MailStatus mailStatus = (MailStatus)hostStatusMap.get(domain);
            addressList = (List)hostAddressMap.get(domain);
            BaseMailSender mailSender = new BaseMailSender();
            this.configMailSender(mailSender);
            mailSender.setCurrentDomain(domain);
            mailSender.setDomainStatusMap(hostStatusMap);
            mailSender.setCcBccNotSendFlg(true);
            mailDataList = new LinkedList<BaseMailData>();
            for (int i5 = 0; i5 < addressList.size(); ++i5) {
                String address = (String)addressList.get(i5);
                LinkedList<String> newToList = new LinkedList<String>();
                newToList.add(address);
                newMailData = new BaseMailData();
                newMailData.setFrom(mailData.getFrom());
                newMailData.setToList(newToList);
                newMailData.setCcList(mailData.getCcList());
                newMailData.setBccList(mailData.getBccList());
                newMailData.setSubject(mailData.getSubject());
                newMailData.setContentTitle(mailData.getContentTitle());
                newMailData.setContent(mailData.getContent());
                newMailData.setAttachments(mailData.getAttachments());
                newMailData.setMailType(mailData.getMailType());
                newMailData.setMailFlag(mailData.getMailFlag());
                newMailData.setCreateDate(mailData.getCreateDate());
                newMailData.setAddressNameMap(mailData.getAddressNameMap());
                newMailData.setInsertTitleFlg(mailData.isInsertTitleFlg());
                newMailData.setPreInsertTitle(mailData.getPreInsertTitle());
                newMailData.setPostInsertTitle(mailData.getPostInsertTitle());
                mailDataList.add(newMailData);
            }
            mailSender.setMailDataList(mailDataList);
            boolean kickedTheThread = false;
            while (!kickedTheThread) {
                MailSenderThread mailSenderThread;
                ThreadGroup threadGroup;
                if (mailStatus.isAbnormalFlg()) {
                    kickedTheThread = true;
                    String threadName = "AbnormalMailSender" + Calendar.getInstance().getTimeInMillis();
                    threadGroup = Thread.currentThread().getThreadGroup();
                    mailSenderThread = new MailSenderThread(threadGroup, threadName);
                    mailSenderThread.setMailSender(mailSender);
                    mailSenderThread.start();
                    abnormalThreadPool.put(threadName, mailSenderThread);
                } else if (threadPool.size() < threadPoolSize) {
                    kickedTheThread = true;
                    String threadName = "MailSender" + Calendar.getInstance().getTimeInMillis();
                    threadGroup = Thread.currentThread().getThreadGroup();
                    mailSenderThread = new MailSenderThread(threadGroup, threadName);
                    mailSenderThread.setMailSender(mailSender);
                    mailSenderThread.start();
                    threadPool.put(threadName, mailSenderThread);
                }
                if (!kickedTheThread) {
                    for (String threadName : threadPool.keySet()) {
                        MailSenderThread tempThread2 = (MailSenderThread)threadPool.get(threadName);
                        if (!MailSenderThread.isTheThreadRunning(threadName)) {
                            threadPool.remove(threadName);
                            break;
                        }
                        long currentTime2 = Calendar.getInstance().getTimeInMillis();
                        long threadTime = Calendar.getInstance().getTimeInMillis();
                        try {
                            threadTime = Long.parseLong(threadName.substring("MailSender".length()));
                        }
                        catch (Exception e) {
                            threadTime = Calendar.getInstance().getTimeInMillis();
                        }
                        if ((currentTime2 -= 0x6DDD00L) <= threadTime) continue;
                        threadPool.remove(threadName);
                        tempThread2.interrupt();
                        tempThread2.destroy();
                        break;
                    }
                }
                long currentTime3 = Calendar.getInstance().getTimeInMillis();
                if (this.persistentManager == null || currentTime3 <= this.mailSavedTime + 60000L) continue;
                this.persistentManager.save(mailData);
                this.mailSavedTime = currentTime3;
            }
        }
        do {
            if (threadPool.size() < threadPoolSize) {
                for (String host : hostStatusMap.keySet()) {
                    MailSenderThread mailSenderThread;
                    ThreadGroup threadGroup;
                    MailStatus mailStatus = (MailStatus)hostStatusMap.get(host);
                    if (mailStatus == null || !mailStatus.isCompleteFlg() || mailStatus.getSendFailed() <= 0 || mailStatus.getRetryCount() >= 3) continue;
                    mailStatus.setSendFailed(0);
                    addressList = mailStatus.getFailedList();
                    mailStatus.setCompleteFlg(false);
                    mailStatus.setSendFailed(0);
                    BaseMailSender mailSender = new BaseMailSender();
                    this.configMailSender(mailSender);
                    mailSender.setCurrentDomain(host);
                    mailSender.setDomainStatusMap(hostStatusMap);
                    mailSender.setCcBccNotSendFlg(true);
                    mailDataList = new LinkedList();
                    for (int i6 = 0; i6 < addressList.size(); ++i6) {
                        String address = (String)addressList.get(i6);
                        LinkedList<String> newToList = new LinkedList<String>();
                        newToList.add(address);
                        newMailData = new BaseMailData();
                        newMailData.setFrom(mailData.getFrom());
                        newMailData.setToList(newToList);
                        newMailData.setCcList(mailData.getCcList());
                        newMailData.setBccList(mailData.getBccList());
                        newMailData.setSubject(mailData.getSubject());
                        if (mailData instanceof MassMailData) {
                            newMailData.setContent(((MassMailData)mailData).getContent(address));
                            newMailData.setAttachments(((MassMailData)mailData).getAttachments(address));
                        } else {
                            newMailData.setContent(mailData.getContent());
                            newMailData.setAttachments(mailData.getAttachments());
                        }
                        newMailData.setMailType(mailData.getMailType());
                        newMailData.setMailFlag(mailData.getMailFlag());
                        newMailData.setCreateDate(mailData.getCreateDate());
                        newMailData.setAddressNameMap(mailData.getAddressNameMap());
                        mailDataList.add(newMailData);
                    }
                    mailSender.setMailDataList(mailDataList);
                    if (mailStatus.isAbnormalFlg()) {
                        String threadName = "AbnormalMailSender" + Calendar.getInstance().getTimeInMillis();
                        threadGroup = Thread.currentThread().getThreadGroup();
                        mailSenderThread = new MailSenderThread(threadGroup, threadName);
                        mailSenderThread.setMailSender(mailSender);
                        mailSenderThread.start();
                        abnormalThreadPool.put(threadName, mailSenderThread);
                        continue;
                    }
                    String threadName = "MailSender" + Calendar.getInstance().getTimeInMillis();
                    threadGroup = Thread.currentThread().getThreadGroup();
                    mailSenderThread = new MailSenderThread(threadGroup, threadName);
                    mailSenderThread.setMailSender(mailSender);
                    mailSenderThread.start();
                    threadPool.put(threadName, mailSenderThread);
                }
            }
            for (String threadName : threadPool.keySet()) {
                tempThread = (MailSenderThread)threadPool.get(threadName);
                if (!MailSenderThread.isTheThreadRunning(threadName)) {
                    threadPool.remove(threadName);
                    break;
                }
                long currentTime4 = Calendar.getInstance().getTimeInMillis();
                long threadTime = Calendar.getInstance().getTimeInMillis();
                try {
                    threadTime = Long.parseLong(threadName.substring("MailSender".length()));
                }
                catch (Exception e) {
                    threadTime = Calendar.getInstance().getTimeInMillis();
                }
                if ((currentTime4 -= 0x6DDD00L) <= threadTime) continue;
                threadPool.remove(threadName);
                tempThread.interrupt();
                break;
            }
            currentTime = Calendar.getInstance().getTimeInMillis();
            if (this.persistentManager == null || currentTime <= this.mailSavedTime + 60000L) continue;
            this.persistentManager.save(mailData);
            this.mailSavedTime = currentTime;
        } while (threadPool.size() > 0);
        do {
            for (String host : hostStatusMap.keySet()) {
                MailStatus mailStatus = (MailStatus)hostStatusMap.get(host);
                if (mailStatus == null || !mailStatus.isCompleteFlg() || !mailStatus.isAbnormalFlg() || mailStatus.getSendFailed() <= 0 || mailStatus.getRetryCount() >= 3) continue;
                mailStatus.setSendFailed(0);
                addressList = mailStatus.getFailedList();
                mailStatus.setCompleteFlg(false);
                mailStatus.setSendFailed(0);
                BaseMailSender mailSender = new BaseMailSender();
                this.configMailSender(mailSender);
                mailSender.setCurrentDomain(host);
                mailSender.setDomainStatusMap(hostStatusMap);
                mailSender.setCcBccNotSendFlg(true);
                mailDataList = new LinkedList();
                for (int i7 = 0; i7 < addressList.size(); ++i7) {
                    String address = (String)addressList.get(i7);
                    LinkedList<String> newToList = new LinkedList<String>();
                    newToList.add(address);
                    newMailData = new BaseMailData();
                    newMailData.setFrom(mailData.getFrom());
                    newMailData.setToList(newToList);
                    newMailData.setCcList(mailData.getCcList());
                    newMailData.setBccList(mailData.getBccList());
                    newMailData.setSubject(mailData.getSubject());
                    if (mailData instanceof MassMailData) {
                        newMailData.setContent(((MassMailData)mailData).getContent(address));
                        newMailData.setAttachments(((MassMailData)mailData).getAttachments(address));
                    } else {
                        newMailData.setContent(mailData.getContent());
                        newMailData.setAttachments(mailData.getAttachments());
                    }
                    newMailData.setMailType(mailData.getMailType());
                    newMailData.setMailFlag(mailData.getMailFlag());
                    newMailData.setCreateDate(mailData.getCreateDate());
                    newMailData.setAddressNameMap(mailData.getAddressNameMap());
                    mailDataList.add(newMailData);
                }
                mailSender.setMailDataList(mailDataList);
                String threadName = "AbnormalMailSender" + Calendar.getInstance().getTimeInMillis();
                ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
                MailSenderThread mailSenderThread = new MailSenderThread(threadGroup, threadName);
                mailSenderThread.setMailSender(mailSender);
                mailSenderThread.start();
                abnormalThreadPool.put(threadName, mailSenderThread);
            }
            for (String threadName : abnormalThreadPool.keySet()) {
                tempThread = (MailSenderThread)abnormalThreadPool.get(threadName);
                if (!MailSenderThread.isTheThreadRunning(threadName)) {
                    abnormalThreadPool.remove(threadName);
                    break;
                }
                long currentTime5 = Calendar.getInstance().getTimeInMillis();
                long threadTime = Calendar.getInstance().getTimeInMillis();
                try {
                    threadTime = Long.parseLong(threadName.substring("AbnormalMailSender".length()));
                }
                catch (Exception e) {
                    threadTime = Calendar.getInstance().getTimeInMillis();
                }
                if ((currentTime5 -= 14400000L) <= threadTime) continue;
                abnormalThreadPool.remove(threadName);
                tempThread.interrupt();
                break;
            }
            currentTime = Calendar.getInstance().getTimeInMillis();
            if (this.persistentManager == null || currentTime <= this.mailSavedTime + 60000L) continue;
            this.persistentManager.save(mailData);
            this.mailSavedTime = currentTime;
        } while (abnormalThreadPool.size() > 0);
        if (mailData instanceof MassMailData) {
            BaseMailData afterMailData = ((MassMailData)mailData).getAfterMail();
            MassMailSender afterMailSender = new MassMailSender();
            afterMailSender.execute(afterMailData);
        }
        mailData.setStatus(2);
        mailData.setEndDate(Calendar.getInstance().getTime());
        if (this.persistentManager != null) {
            this.persistentManager.save(mailData);
        }
        return result;
    }

    public void configMailSender(BaseMailSender mailSender) {
        if (mailSender != null) {
            mailSender.setSmtpDirectFlg(this.isSmtpDirectFlg());
            mailSender.setPopBeforeSmtp(this.isPopBeforeSmtp());
            mailSender.setShiftJISFlg(this.isShiftJISFlg());
            mailSender.setServerOsEncode(this.myResources.getResourceString("ServerOsEncode"));
            mailSender.setSmtpEncode(this.myResources.getResourceString("SmtpEncode"));
            mailSender.setSmtpServerAddress(this.myResources.getResourceString("SmtpServerAddress"));
            mailSender.setPopServerAddress(this.myResources.getResourceString("PopServerAddress"));
            mailSender.setPopAccessUserName(this.myResources.getResourceString("PopAccessUserName"));
            mailSender.setPopAccessPassword(this.myResources.getResourceString("PopAccessPassword"));
            mailSender.setBccMailAdddress(this.myResources.getResourceString("BccMailAdddress"));
            mailSender.setClientOsEncode(this.myResources.getResourceString("ClientOsEncode"));
            mailSender.setFileEncodingType(this.myResources.getResourceString("FileEncodingType"));
            mailSender.setFileDistination(this.myResources.getResourceString("FileDistination"));
        }
    }

    public boolean isSmtpDirectFlg() {
        return Pattern.matches("[Yy][Ee][Ss]", this.myResources.getResourceString("SmtpDirectFlg"));
    }

    public boolean isPopBeforeSmtp() {
        return Pattern.matches("[Yy][Ee][Ss]", this.myResources.getResourceString("PopBeforSmtp"));
    }

    public boolean isShiftJISFlg() {
        return Pattern.matches("[Yy][Ee][Ss]", this.myResources.getResourceString("ShiftJISFlg"));
    }

    public MailPersistentManager getPersistentManager() {
        return this.persistentManager;
    }

    public void setPersistentManager(MailPersistentManager persistentManager) {
        this.persistentManager = persistentManager;
    }
}

