/*
 * Decompiled with CFR 0.152.
 */
package com.jware.apps.scheduler.web.struts.listener;

import com.jware.apps.scheduler.web.struts.listener.EditListenersAction;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.TriggerListener;

public class EditTriggerListenersAction
extends EditListenersAction {
    public static final String CVS_INFO = "$Id: EditTriggerListenersAction.java,v 1.1 2006/09/25 14:20:45 hans Exp $";
    private static final transient Log logger = LogFactory.getLog(EditTriggerListenersAction.class);

    void removeListener(String listenerToDelete, Scheduler scheduler) throws ServletException {
        TriggerListener triggerListener = null;
        try {
            List globalListeners = scheduler.getGlobalTriggerListeners();
            for (int j = 0; j < globalListeners.size(); ++j) {
                TriggerListener gJl = (TriggerListener)globalListeners.get(j);
                if (!gJl.getName().equals(listenerToDelete)) continue;
                triggerListener = gJl;
            }
            logger.info((Object)("Deleting listener " + listenerToDelete + " class: " + triggerListener.getClass().getName()));
            scheduler.removeGlobalTriggerListener(triggerListener);
        }
        catch (SchedulerException e) {
            throw new ServletException((Throwable)e);
        }
    }

    void addListener(String newListenerClass, Scheduler scheduler) throws ServletException {
        TriggerListener listener = null;
        try {
            listener = (TriggerListener)Class.forName(newListenerClass).newInstance();
        }
        catch (InstantiationException e) {
            throw new ServletException("Must have an empty constructor", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new ServletException("Must have a public cosntructor", (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            throw new ServletException("The class " + newListenerClass + " is not found", (Throwable)e);
        }
        try {
            logger.info((Object)("Adding listener " + listener.getName() + " class: " + listener.getClass().getName()));
            scheduler.addGlobalTriggerListener(listener);
        }
        catch (SchedulerException e) {
            throw new ServletException((Throwable)e);
        }
    }

    void addAllListenerNamesAndClasses(Scheduler scheduler, List triggerListenerNames, List triggerListenerClasses) throws ServletException {
        List triggerListeners = null;
        try {
            triggerListeners = scheduler.getGlobalTriggerListeners();
        }
        catch (SchedulerException e) {
            throw new ServletException((Throwable)e);
        }
        if (triggerListeners != null) {
            for (int i2 = 0; i2 < triggerListeners.size(); ++i2) {
                TriggerListener triggerListener = (TriggerListener)triggerListeners.get(i2);
                triggerListenerClasses.add(triggerListener.getClass().getName());
                triggerListenerNames.add(triggerListener.getName());
            }
        }
    }

    void setRequest(HttpServletRequest request) {
        request.setAttribute("returnPath", (Object)"editTriggerListeners.do");
    }
}

