/*
 * Decompiled with CFR 0.152.
 */
package com.jware.apps.scheduler.web.struts.listener;

import com.jware.apps.scheduler.web.struts.listener.EditListenersAction;
import java.util.List;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.JobListener;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;

public class EditJobListenersAction
extends EditListenersAction {
    public static final String CVS_INFO = "$Id: EditJobListenersAction.java,v 1.1 2006/09/25 14:20:45 hans Exp $";
    private static final transient Log logger = LogFactory.getLog(EditJobListenersAction.class);

    void removeListener(String listenerToDelete, Scheduler scheduler) throws ServletException {
        Object jobListener = null;
        try {
            Set jobListenerNames = scheduler.getJobListenerNames();
            for (String jobListerName : jobListenerNames) {
                JobListener gJl = scheduler.getJobListener(jobListerName);
                if (!gJl.getName().equals(listenerToDelete)) continue;
                jobListener = gJl;
            }
            logger.info((Object)("Deleting listener " + listenerToDelete + " class: " + jobListener.getClass().getName()));
            scheduler.removeJobListener(jobListener.getName());
        }
        catch (SchedulerException e) {
            throw new ServletException((Throwable)e);
        }
    }

    void addListener(String newListenerClass, Scheduler scheduler) throws ServletException {
        JobListener listener = null;
        try {
            listener = (JobListener)Class.forName(newListenerClass).newInstance();
        }
        catch (InstantiationException e) {
            throw new ServletException("Must have an empty constructor", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new ServletException("Must have a public cosntructor", (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            throw new ServletException("The class " + newListenerClass + " is not found", (Throwable)e);
        }
        try {
            logger.info((Object)("Adding listener " + listener.getName() + " class: " + listener.getClass().getName()));
            scheduler.addJobListener(listener);
        }
        catch (SchedulerException e) {
            throw new ServletException((Throwable)e);
        }
    }

    void addAllListenerNamesAndClasses(Scheduler scheduler, List jobListenerNames, List jobListenerClasses) throws ServletException {
        Set jobListeners = null;
        try {
            jobListeners = scheduler.getJobListenerNames();
        }
        catch (SchedulerException e) {
            logger.error((Object)("When getting all job listeners" + e.getMessage()), (Throwable)e);
            throw new ServletException((Throwable)e);
        }
        if (jobListeners != null) {
            for (String jobListenerName : jobListeners) {
                JobListener jobListener = null;
                try {
                    jobListener = scheduler.getJobListener(jobListenerName);
                }
                catch (SchedulerException e) {
                    logger.error((Object)("When getting job listener from name " + e.getMessage()), (Throwable)e);
                    throw new ServletException("When getting job listener from name " + e.getMessage(), (Throwable)e);
                }
                jobListenerClasses.add(jobListener.getClass().getName());
                jobListenerNames.add(jobListener.getName());
            }
        }
    }

    void setRequest(HttpServletRequest request) {
        request.setAttribute("returnPath", (Object)"editJobListeners.do");
    }
}

